/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.legend.shared;

import java.util.ArrayList;
import java.util.List;
import oracle.dss.legend.shared.CompositeLegendItem;
import oracle.dss.legend.shared.LegendItem;
import oracle.dss.legend.shared.LegendSection;
import oracle.dss.legend.shared.text.LegendSectionGroupTitle;
import oracle.dss.legend.shared.text.LegendText;
import oracle.dss.legend.shared.visit.LegendVisitContext;
import oracle.dss.legend.shared.visit.LegendVisitor;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Fill;
import oracle.dss.util.shapes.FillColor;
import oracle.dss.util.shapes.Stroke;

public class LegendSectionGroup
extends CompositeLegendItem<LegendSection> {
    private LegendSectionGroupTitle m_title;
    private boolean disclosed = true;

    @Override
    public void internalAccept(LegendVisitor visitor, LegendVisitContext context) {
        visitor.visit(this, context);
        if (this.m_title != null) {
            this.m_title.accept(visitor, context);
        }
        super.internalAccept(visitor, context);
    }

    public LegendText getTitle() {
        return this.m_title;
    }

    public void setTitle(LegendSectionGroupTitle title) {
        this.m_title = title;
    }

    protected int calcWidth(int width) {
        return this.m_title != null ? Math.max(this.m_title.getWidth(), width) : width;
    }

    @Override
    public void calc() {
        int runningHeight = 0;
        int allocWidth = this.m_width;
        int titleHeight = 0;
        int titleWidth = 0;
        if (this.m_title != null) {
            this.m_title.setWidth(this.m_width);
            this.m_title.calc();
            titleHeight = this.m_title.getHeight();
            titleWidth = this.m_title.getWidth();
            runningHeight += titleHeight + 2;
        }
        allocWidth -= 7;
        int maxWidth = Integer.MIN_VALUE;
        for (int i = 0; i < this.m_items.size(); ++i) {
            LegendItem item = (LegendItem)this.m_items.get(i);
            item.setWidth(allocWidth);
            item.setHeight(this.m_height - titleHeight);
            item.calc();
            runningHeight += item.getHeight();
            if (i < this.m_items.size() - 1) {
                runningHeight += 2;
            }
            maxWidth = Math.max(maxWidth, item.getWidth() + 7);
        }
        this.m_width = this.calcWidth(maxWidth);
        this.m_height = runningHeight;
    }

    @Override
    public void calcFinal() {
        for (LegendItem item : this.m_items) {
            if (!(item instanceof LegendSection)) continue;
            int allocWidth = this.m_width;
            this.m_height -= item.getHeight();
            item.setWidth(allocWidth -= 7);
            item.calcFinal();
            this.m_height += item.getHeight();
        }
    }

    @Override
    public List<DrawableObject> render() {
        ArrayList<DrawableObject> section = new ArrayList<DrawableObject>();
        int curr_y = this.m_y;
        boolean isBidi = this.m_settings.isBidi();
        int curr_x = this.m_x;
        if (isBidi) {
            curr_x += this.m_width;
        }
        if (this.m_title != null) {
            if (isBidi) {
                this.m_title.setPosition(curr_x - this.m_title.getWidth(), curr_y);
            } else {
                this.m_title.setPosition(curr_x, curr_y);
            }
            section.addAll(this.m_title.render());
            curr_y += this.m_title.getHeight() + 2;
        }
        curr_x = isBidi ? (curr_x -= 7) : (curr_x += 7);
        for (int i = 0; i < this.m_items.size(); ++i) {
            LegendItem item = (LegendItem)this.m_items.get(i);
            if (isBidi) {
                item.setPosition(curr_x - item.getWidth(), curr_y);
            } else {
                item.setPosition(curr_x, curr_y);
            }
            section.addAll(item.render());
            curr_y += item.getHeight();
            if (i >= this.m_items.size() - 1) continue;
            curr_y += 2;
        }
        return section;
    }

    public List<LegendSection> getSections() {
        return this.getItems();
    }

    @Override
    public Fill getDefaultFill() {
        return new FillColor(this.m_settings.getStyles().getBackgroundColor());
    }

    @Override
    public Stroke getDefaultBorder() {
        return null;
    }

    public String getTitleText() {
        return this.m_title == null ? null : this.m_title.getText();
    }

    public void setDisclosed(boolean disclosed) {
        this.disclosed = disclosed;
    }

    public boolean isDisclosed() {
        return this.disclosed;
    }
}

