/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.legend.impl;

import java.awt.Color;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import oracle.dss.legend.LegendItem;
import oracle.dss.legend.LegendSection;
import oracle.dss.legend.impl.LegendMarker;
import oracle.dss.legend.impl.ListLegendItem;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Fill;
import oracle.dss.util.shapes.FillColor;

public class ListLegend
extends LegendSection {
    protected int m_columnCount = 1;
    protected int m_columnWidth = 0;
    protected int m_rowHeight = 0;
    protected int m_numLines = 1;
    protected int m_initHeight = 0;
    protected static int SECTION_INDENT = 7;
    protected boolean m_bListLegendItemOnly = true;

    @Override
    public void calc() {
        int allocWidth = this.m_width;
        int titleHeight = 0;
        int titleWidth = 0;
        if (this.m_title != null) {
            this.m_title.setWidth(this.m_width);
            this.m_title.calc();
            titleHeight = this.m_title.getHeight() + ITEM_GAP;
            titleWidth = this.m_title.getWidth();
            allocWidth -= SECTION_INDENT;
        }
        for (int i = 0; i < this.m_items.size(); ++i) {
            LegendItem item = (LegendItem)this.m_items.get(i);
            item.setWidth(allocWidth);
            item.setHeight(this.m_height - titleHeight);
            item.calc();
            this.m_rowHeight = Math.max(this.m_rowHeight, item.getHeight());
            if (item instanceof ListLegendItem) {
                this.m_numLines = Math.max(this.m_numLines, ((ListLegendItem)item).m_label.getLines());
            } else {
                this.m_bListLegendItemOnly = false;
            }
            this.m_columnWidth = Math.max(this.m_columnWidth, item.getWidth());
        }
        this.m_width = this.calcWidth(this.m_columnWidth);
        this.m_initHeight = (this.m_rowHeight + ITEM_GAP) * this.m_items.size();
        this.m_height = this.m_initHeight + titleHeight - ITEM_GAP;
    }

    @Override
    public void calcFinal() {
        int numItems = this.m_items.size();
        int titleHeight = this.m_title != null ? this.m_title.getHeight() : 0;
        int boundHeight = this.m_height - titleHeight + ITEM_GAP;
        if (this.m_bListLegendItemOnly) {
            int lineHeight = this.m_rowHeight / this.m_numLines;
            while (this.m_numLines > 1) {
                int newHeight = (this.m_rowHeight + ITEM_GAP) * numItems;
                if (newHeight <= boundHeight) {
                    for (LegendItem item : this.m_items) {
                        item.setHeight(this.m_rowHeight);
                        item.calcFinal();
                    }
                    this.m_width = this.calcWidth(this.m_columnWidth);
                    this.m_height = newHeight + titleHeight - ITEM_GAP;
                    return;
                }
                --this.m_numLines;
                this.m_rowHeight = lineHeight * this.m_numLines;
                this.m_initHeight = numItems * this.m_rowHeight;
            }
            for (LegendItem item : this.m_items) {
                item.setHeight(this.m_rowHeight);
                item.calcFinal();
            }
        }
        int maxColumns = this.m_columnWidth > 0 ? Math.min(numItems, this.m_width / this.m_columnWidth) : 0;
        int numRows = (int)Math.ceil((double)numItems / (double)this.m_columnCount);
        while (this.m_columnCount < maxColumns) {
            ++this.m_columnCount;
            numRows = (int)Math.ceil((double)numItems / (double)this.m_columnCount);
            int newHeight = numRows * (this.m_rowHeight + ITEM_GAP);
            if (newHeight > boundHeight || this.m_columnCount * newHeight < this.m_initHeight) continue;
            this.m_width = this.calcWidth(this.m_columnCount * this.m_columnWidth);
            this.m_height = newHeight + titleHeight - ITEM_GAP;
            return;
        }
        for (int i = numRows - 1; i >= 1; --i) {
            int newHeight = i * (this.m_rowHeight + ITEM_GAP);
            if (newHeight > boundHeight) continue;
            int lastRowCount = this.m_columnCount == 1 ? 0 : this.m_items.size() % this.m_columnCount;
            int removeCount = lastRowCount > 0 ? this.m_columnCount * (numRows - i - 1) + lastRowCount : this.m_columnCount * (numRows - i);
            for (int j = 0; j < removeCount; ++j) {
                this.m_items.remove(this.m_items.size() - 1);
            }
            for (LegendItem item : this.m_items) {
                this.m_columnWidth = Math.max(this.m_columnWidth, item.getWidth());
            }
            this.m_width = this.calcWidth(this.m_columnCount * this.m_columnWidth);
            this.m_height = newHeight + titleHeight - ITEM_GAP;
            return;
        }
        this.m_items.clear();
    }

    private int calcWidth(int width) {
        return this.m_title != null ? Math.max(this.m_title.getWidth(), width + SECTION_INDENT) : width;
    }

    @Override
    public List<DrawableObject> render() {
        ArrayList<DrawableObject> section = new ArrayList<DrawableObject>();
        int curr_x = this.m_x;
        int curr_y = this.m_y;
        if (this.m_title != null) {
            this.m_title.setPosition(curr_x, curr_y);
            section.addAll(this.m_title.render());
            curr_y += this.m_title.getHeight() + ITEM_GAP;
            curr_x += SECTION_INDENT;
        }
        if (this.m_columnCount == 1) {
            for (int i = 0; i < this.m_items.size(); ++i) {
                LegendItem item = (LegendItem)this.m_items.get(i);
                item.setHeight(this.m_rowHeight);
                int itemX = curr_x;
                if (this.isBiDiLocale()) {
                    int offset = curr_x - this.m_x;
                    itemX = this.m_x + this.m_width - offset - item.getWidth();
                }
                item.setPosition(itemX, curr_y);
                section.addAll(item.render());
                curr_y += this.m_rowHeight + ITEM_GAP;
            }
        } else if (this.isBiDiLocale()) {
            int curr_col = 1;
            int init_x = curr_x;
            boolean colHeight = false;
            for (int i = 0; i < this.m_items.size(); i += this.m_columnCount) {
                for (int j = i + this.m_columnCount - 1; j >= i; --j) {
                    if (j >= this.m_items.size()) {
                        curr_x += this.m_columnWidth;
                        continue;
                    }
                    LegendItem item = (LegendItem)this.m_items.get(j);
                    item.setHeight(this.m_rowHeight);
                    item.setPosition(curr_x, curr_y);
                    section.addAll(item.render());
                    if (++curr_col % this.m_columnCount == 1) {
                        curr_y += this.m_rowHeight + ITEM_GAP;
                        curr_x = init_x;
                        continue;
                    }
                    curr_x += this.m_columnWidth;
                }
            }
        } else {
            int curr_col = 1;
            int init_x = curr_x;
            boolean colHeight = false;
            for (int i = 0; i < this.m_items.size(); ++i) {
                LegendItem item = (LegendItem)this.m_items.get(i);
                item.setHeight(this.m_rowHeight);
                item.setPosition(curr_x, curr_y);
                section.addAll(item.render());
                if (++curr_col % this.m_columnCount == 1) {
                    curr_y += this.m_rowHeight + ITEM_GAP;
                    curr_x = init_x;
                    continue;
                }
                curr_x += this.m_columnWidth;
            }
        }
        return section;
    }

    public ListLegendItem createShapeItem(LegendMarker.MarkerShape shape, Color color, String label) {
        FillColor fill = new FillColor();
        fill.setColor(color);
        ListLegendItem item = new ListLegendItem(shape, (Fill)fill, label);
        item.setLocale(this.getLocale());
        this.addItem(item);
        return item;
    }

    public ListLegendItem createCustomItem(Shape shape, Color color, String label) {
        FillColor fill = new FillColor();
        fill.setColor(color);
        ListLegendItem item = new ListLegendItem(shape, (Fill)fill, label);
        item.setLocale(this.getLocale());
        this.addItem(item);
        return item;
    }

    public ListLegendItem createImageItem(String imageUrl, String label) {
        ListLegendItem item = new ListLegendItem(imageUrl, label);
        item.setLocale(this.getLocale());
        this.addItem(item);
        return item;
    }
}

