/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.model3d;

import oracle.dss.graph.pfj.JChart_3D;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.model3d.Model3DFlatFace;
import oracle.dss.graph.pfj.model3d.Point3d;

public class Model3DRectSolid
extends Model3DFlatFace {
    private static final long serialVersionUID = 1L;
    public static final int FRONT = 0;
    public static final int LEFT = 1;
    public static final int TOP = 2;
    public static final int BACK = 3;
    public static final int RIGHT = 4;
    public static final int BOTTOM = 5;
    protected Point3d m_origin;
    protected Point3d m_size;
    protected int m_nPtsPerFace = 4;
    private static int[][] m_myfaces = new int[][]{{0, 1, 2, 3}, {0, 3, 7, 4}, {3, 2, 6, 7}, {4, 7, 6, 5}, {1, 5, 6, 2}, {0, 4, 5, 1}};

    public Model3DRectSolid(JChart_3D chart, IdentObj id, BlackBoxIF bb, Point3d origin, Point3d size, boolean[][] bGridStatus, boolean bAutoshading, boolean bCanUseSimpleVisibility) {
        super(chart, id, bb, 6, 8, bGridStatus, bAutoshading);
        this.m_origin = new Point3d(origin);
        this.m_size = new Point3d(size);
        this.m_faces = m_myfaces;
        for (int i = 0; i < this.m_nVertices; ++i) {
            this.m_vertices[i] = new Point3d(origin);
        }
        this.m_vertices[0].z += this.m_size.z;
        this.m_vertices[1].x += this.m_size.x;
        this.m_vertices[1].z += this.m_size.z;
        this.m_vertices[2].x += this.m_size.x;
        this.m_vertices[2].y += this.m_size.y;
        this.m_vertices[2].z += this.m_size.z;
        this.m_vertices[3].y += this.m_size.y;
        this.m_vertices[3].z += this.m_size.z;
        this.m_vertices[5].x += this.m_size.x;
        this.m_vertices[6].x += this.m_size.x;
        this.m_vertices[6].y += this.m_size.y;
        this.m_vertices[7].y += this.m_size.y;
        this.m_bCanUseSimpleVisibility = bCanUseSimpleVisibility;
    }

    public Model3DRectSolid(Model3DRectSolid model) {
        this(model.m_chart, model.m_id, model.m_bb, model.m_origin, model.m_size, model.m_bGridStatus, model.m_bAutoshading, model.m_bCanUseSimpleVisibility);
        this.m_distance = model.m_distance;
    }

    @Override
    protected Point3d getCenter() {
        return new Point3d(this.m_origin.x + this.m_size.x / 2.0, this.m_origin.y, this.m_origin.z + this.m_size.z / 2.0);
    }

    @Override
    protected Point3d getGridLineEnd(int nAxis, int nFace, double d) {
        switch (nAxis) {
            case 0: {
                switch (nFace) {
                    case 0: {
                        return new Point3d(d, this.m_vertices[3].y, this.m_vertices[0].z);
                    }
                    case 1: {
                        return null;
                    }
                    case 2: {
                        return new Point3d(d, this.m_vertices[3].y, this.m_vertices[3].z);
                    }
                    case 3: {
                        return new Point3d(d, this.m_vertices[3].y, this.m_vertices[4].z);
                    }
                    case 4: {
                        return null;
                    }
                    case 5: {
                        return new Point3d(d, this.m_vertices[0].y, this.m_vertices[0].z);
                    }
                }
                break;
            }
            case 1: {
                switch (nFace) {
                    case 0: {
                        return new Point3d(this.m_vertices[1].x, d, this.m_vertices[0].z);
                    }
                    case 1: {
                        return new Point3d(this.m_vertices[0].x, d, this.m_vertices[0].z);
                    }
                    case 2: {
                        return null;
                    }
                    case 3: {
                        return new Point3d(this.m_vertices[1].x, d, this.m_vertices[4].z);
                    }
                    case 4: {
                        return new Point3d(this.m_vertices[1].x, d, this.m_vertices[1].z);
                    }
                    case 5: {
                        return null;
                    }
                }
                break;
            }
            case 2: {
                switch (nFace) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return new Point3d(this.m_vertices[0].x, this.m_vertices[3].y, d);
                    }
                    case 2: {
                        return new Point3d(this.m_vertices[2].x, this.m_vertices[3].y, d);
                    }
                    case 3: {
                        return null;
                    }
                    case 4: {
                        return new Point3d(this.m_vertices[1].x, this.m_vertices[3].y, d);
                    }
                    case 5: {
                        return new Point3d(this.m_vertices[1].x, this.m_vertices[0].y, d);
                    }
                }
            }
        }
        return null;
    }

    @Override
    protected Point3d getGridLineStart(int nAxis, int nFace, double d) {
        switch (nAxis) {
            case 0: {
                switch (nFace) {
                    case 0: {
                        return new Point3d(d, this.m_vertices[0].y, this.m_vertices[0].z);
                    }
                    case 1: {
                        return null;
                    }
                    case 2: {
                        return new Point3d(d, this.m_vertices[3].y, this.m_vertices[4].z);
                    }
                    case 3: {
                        return new Point3d(d, this.m_vertices[0].y, this.m_vertices[4].z);
                    }
                    case 4: {
                        return null;
                    }
                    case 5: {
                        return new Point3d(d, this.m_vertices[0].y, this.m_vertices[4].z);
                    }
                }
                break;
            }
            case 1: {
                switch (nFace) {
                    case 0: {
                        return new Point3d(this.m_vertices[0].x, d, this.m_vertices[0].z);
                    }
                    case 1: {
                        return new Point3d(this.m_vertices[0].x, d, this.m_vertices[4].z);
                    }
                    case 2: {
                        return null;
                    }
                    case 3: {
                        return new Point3d(this.m_vertices[0].x, d, this.m_vertices[4].z);
                    }
                    case 4: {
                        return new Point3d(this.m_vertices[1].x, d, this.m_vertices[4].z);
                    }
                    case 5: {
                        return null;
                    }
                }
                break;
            }
            case 2: {
                switch (nFace) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return new Point3d(this.m_vertices[0].x, this.m_vertices[0].y, d);
                    }
                    case 2: {
                        return new Point3d(this.m_vertices[0].x, this.m_vertices[3].y, d);
                    }
                    case 3: {
                        return null;
                    }
                    case 4: {
                        return new Point3d(this.m_vertices[1].x, this.m_vertices[0].y, d);
                    }
                    case 5: {
                        return new Point3d(this.m_vertices[0].x, this.m_vertices[0].y, d);
                    }
                }
            }
        }
        return null;
    }

    public double getMinZ() {
        double fMinZ = -1.7976931348623157E308;
        this.transformVertices();
        for (int i = 0; i < this.m_nVertices; ++i) {
            if (!(this.m_xVertices[i].z > fMinZ)) continue;
            fMinZ = this.m_xVertices[i].z;
        }
        return fMinZ;
    }

    @Override
    public int getNumPtsPerFace(int f) {
        return 4;
    }

    @Override
    public boolean isVisibleIpsoFacto(int f) {
        PfjAssert.pfjAssert(this.m_bCanUseSimpleVisibility);
        return f == 0 || f == 2 || f == 4;
    }
}

