/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.math;

import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.math.CurveFitIF;
import oracle.dss.graph.pfj.math.FP;

public class FitHyperbolic
implements CurveFitIF {
    private static int NUM_COEFFS = 2;

    @Override
    public double compute(double x, double[] a) throws AssertionException {
        PfjAssert.pfjAssert(a.length >= NUM_COEFFS + 1);
        PfjAssert.pfjAssert(FP.nonzero(x));
        double y = a[1] + a[2] / x;
        return y;
    }

    @Override
    public void eval(double x, double[] a) throws AssertionException {
        PfjAssert.pfjAssert(a.length >= NUM_COEFFS + 1);
        PfjAssert.pfjAssert(FP.nonzero(x));
        a[1] = 1.0;
        a[2] = 1.0 / x;
    }

    @Override
    public int numCoeffs() {
        return NUM_COEFFS;
    }

    @Override
    public double transformY(double y) {
        return y;
    }

    @Override
    public double invTransformCoeff(int ia, double a) {
        return a;
    }

    @Override
    public String createEquation(String[] strCoeffs, boolean bHighOrderFirst) throws AssertionException {
        PfjAssert.pfjAssert(strCoeffs.length >= NUM_COEFFS + 1);
        String strTerm1 = strCoeffs[1];
        String strTerm2 = strCoeffs[2] + " / x";
        if (bHighOrderFirst) {
            return "y = " + strTerm2 + " + " + strTerm1;
        }
        return "y = " + strTerm1 + " + " + strTerm2;
    }
}

