/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Point;
import java.awt.Rectangle;
import oracle.dss.graph.pfj.AxisHistObj;
import oracle.dss.graph.pfj.AxisTemplate;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;

public class JChart_2D_Hist
extends JChart_2D_Standard {
    private static final long serialVersionUID = 1L;
    private int[] m_buckets;

    @Override
    public void calc() {
        super.calc();
        this.drawRisers();
    }

    private void calcBuckets() {
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        DataFormat df = this.m_Access.getDataFormat();
        double fValue = 0.0;
        int nBuckets = this.m_X1Axis.getNumIntervals();
        this.m_buckets = new int[nBuckets];
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            gEnum.reset();
            block1: while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                boolean bDataOK = true;
                DatumObj dObj = this.getDataValue(s, g);
                fValue = dObj.m_fValue;
                bDataOK = dObj.m_bOK;
                if (!bDataOK) continue;
                for (int nInterval = 0; nInterval < this.m_X1Axis.getNumIntervals(); ++nInterval) {
                    if (!(fValue >= this.m_X1Axis.getIntervalStart(nInterval)) || !(fValue <= this.m_X1Axis.getIntervalStop(nInterval))) continue;
                    int n = nInterval;
                    this.m_buckets[n] = this.m_buckets[n] + 1;
                    continue block1;
                }
            }
        }
    }

    @Override
    protected Point getCoords(int s, int g) {
        Point center = this.m_bHorz ? new Point(this.m_numYCoords[s][g], this.m_numXCoords[s][g]) : new Point(this.m_numXCoords[s][g], this.m_numYCoords[s][g]);
        return center;
    }

    @Override
    protected void createX1Axis(boolean bVerticalAxis, boolean bAscending) {
        MinMaxObj x1MinMaxObj = this.findLimits(7, this.m_scaling, false, null);
        this.m_X1Axis = new AxisHistObj(this.m_Perspective, this.m_Access, AxisTemplate.X1_AXIS, x1MinMaxObj, bVerticalAxis, bAscending, 0, 100);
    }

    @Override
    protected void createY1Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        this.calcBuckets();
        MinMaxObj y1MinMaxObj = this.findHistLimits();
        this.m_Y1Axis = new AxisHistObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize);
    }

    private void drawRisers() {
        int nBuckets = this.m_X1Axis.getNumIntervals();
        IdentObj id = new IdentObj(311);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        boolean bDescendingX1 = this.m_X1Axis.isDescending();
        boolean bDescendingY1 = this.m_Y1Axis.isDescending();
        for (int bucket = 0; bucket < nBuckets; ++bucket) {
            int top;
            int bottom;
            int right;
            int left;
            int low = ((AxisHistObj)this.m_X1Axis).getLowIntervalCoord(bucket);
            int high = ((AxisHistObj)this.m_X1Axis).getHighIntervalCoord(bucket);
            if (this.m_gt.isOrientHorz()) {
                left = (int)this.m_Y1Axis.getValueCoord(bDescendingY1 ? (double)this.m_buckets[bucket] : 0.0);
                right = (int)this.m_Y1Axis.getValueCoord(bDescendingY1 ? 0.0 : (double)this.m_buckets[bucket]);
                bottom = bDescendingX1 ? high : low;
                top = bDescendingX1 ? low : high;
            } else {
                bottom = (int)this.m_Y1Axis.getValueCoord(bDescendingY1 ? (double)this.m_buckets[bucket] : 0.0);
                top = (int)this.m_Y1Axis.getValueCoord(bDescendingY1 ? 0.0 : (double)this.m_buckets[bucket]);
                left = bDescendingX1 ? high : low;
                right = bDescendingX1 ? low : high;
            }
            Rectangle rVirt = new Rectangle(left, bottom, Math.abs(right - left), Math.abs(top - bottom));
            new DetRect(this.m_Detectiv, new IdentObj(311, -3, -3, -3, bucket), rVirt, (BlackBoxIF)blackBox, this.m_rClip);
        }
    }

    private MinMaxObj findHistLimits() {
        int max = 0;
        for (int i = 0; i < this.m_X1Axis.getNumIntervals(); ++i) {
            if (this.m_buckets[i] <= max) continue;
            max = this.m_buckets[i];
        }
        return new MinMaxObj(0.0, max);
    }

    @Override
    public boolean wantLegend() {
        return false;
    }

    @Override
    protected String processDataTextTemplate(String[] dataItems, String dataTextTemplate) {
        String ResultString = dataTextTemplate;
        return ResultString;
    }
}

