/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.dss.graph.gui.GraphStandardStyles;
import oracle.dss.graph.gui.StyleListEntry;

public class StyleList
extends ArrayList {
    private static final long serialVersionUID = 1L;
    private ResourceBundle _bundle;
    private int defaultIndex = -1;
    private int customIndex = -1;

    public StyleList(int size) {
        super(size);
    }

    public StyleList(StyleList list) {
        super(list);
    }

    public void setLocale(Locale locale) {
        for (int i = 0; i < this.size(); ++i) {
            StyleListEntry entry = this.getStyleListEntry(i);
            if (entry == null) continue;
            entry.setLocale(locale);
        }
    }

    public StyleListEntry getStyleListEntry(int index) {
        return (StyleListEntry)this.get(index);
    }

    public int getStyleIndex(String stylePath) {
        if (stylePath == null) {
            return this.getDefaultStyleIndex();
        }
        StyleListEntry entry = new StyleListEntry(stylePath, "", null);
        return this.indexOf(entry);
    }

    public int getDefaultStyleIndex() {
        if (this.defaultIndex == -1) {
            this.addRequiredStyles();
        }
        return this.defaultIndex;
    }

    public int getCustomStyleIndex() {
        if (this.customIndex == -1) {
            this.setRequiredStyleIndices();
        }
        return this.customIndex;
    }

    public int addCustomStyle() {
        if (this.customIndex == -1) {
            this.setRequiredStyleIndices();
            if (this.customIndex == -1) {
                StyleListEntry customEntry = GraphStandardStyles.CUSTOM_STYLE;
                this.customIndex = this.size();
                this.add(this.customIndex, customEntry);
            }
        }
        return this.customIndex;
    }

    public void addRequiredStyles() {
        this.setRequiredStyleIndices();
        if (this.defaultIndex == -1) {
            StyleListEntry defaultEntry = GraphStandardStyles.DEFAULT_STYLE;
            this.add(0, defaultEntry);
        }
    }

    private void setRequiredStyleIndices() {
        StyleListEntry defaultEntry = GraphStandardStyles.DEFAULT_STYLE;
        StyleListEntry customEntry = GraphStandardStyles.CUSTOM_STYLE;
        for (int i = 0; i < this.size(); ++i) {
            StyleListEntry entry = this.getStyleListEntry(i);
            if (entry == null) continue;
            if (entry == defaultEntry) {
                this.defaultIndex = i;
                continue;
            }
            if (entry != customEntry) continue;
            this.customIndex = i;
        }
    }
}

