/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.Line;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class Y3DMarkerGrid
extends BaseGraphComponent
implements Line {
    public Y3DMarkerGrid(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getCubeRiserGridY();
    }

    @Override
    public boolean selectObject(int series, int group) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    @Override
    public Color getLineColor() {
        return this.m_pfj.getBorderColor(this.m_identObj);
    }

    @Override
    public void setLineColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setLineColor( Color newColor )");
            return;
        }
        this.m_pfj.setBorderColor(this.m_identObj, newColor);
    }

    @Override
    public int getLineWidth() {
        return this.m_pfj.getLineWidth(this.m_identObj);
    }

    @Override
    public void setLineWidth(int width) {
        if (width < 0) {
            this.m_commonGraph.getErrorHandler().log("invalid line width", this.getClass().getName(), "setLineWidth (int width)");
        } else {
            this.m_pfj.setLineWidth(this.m_identObj, width);
        }
    }

    @Override
    protected String getComponentName() {
        return "Y3DMarkerGrid";
    }

    @Override
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = false;
        Object val = this.getLineColor();
        if (val != null) {
            node.addProperty("lineColor", BaseGraphComponent.toHexString(((Color)val).getRGB()));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getLineWidthObj(this.m_identObj)) != null) {
            node.addProperty("lineWidth", ((Integer)val).intValue());
            nodeExists = true;
        }
        return nodeExists;
    }

    @Override
    public void setStyleXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty("lineColor");
        if (pNode != null) {
            this.setLineColor(new Color(BaseGraphComponent.hexStringToInt(pNode.getValueAsString()), true));
        }
        if ((pNode = node.getProperty("lineWidth")) != null) {
            this.setLineWidth(pNode.getValueAsInteger());
        }
    }

    protected void resetStyle() {
        this.setLineColor(Color.black);
        this.setLineWidth(1);
    }
}

