/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.util.Vector;
import oracle.dss.graph.Subtype;

public class Type {
    public int id;
    public String fileName;
    public String sFileName;
    public String name;
    public Vector subtypes;
    public boolean is3D = true;
    public boolean supports3D;
    public boolean supportsNon3D;

    public Type(int id, String name, String fileName, Vector subtypes, boolean supports3D, boolean supportsNon3D) {
        this.id = id;
        this.fileName = fileName;
        this.name = name;
        this.subtypes = subtypes;
        this.supports3D = supports3D;
        this.supportsNon3D = supportsNon3D;
    }

    public Type(int id, String name, String fileName, String sfilename, Vector subtypes, boolean supports3D, boolean supportsNon3D) {
        this.id = id;
        this.fileName = fileName;
        this.sFileName = sfilename;
        this.name = name;
        this.subtypes = subtypes;
        this.supports3D = supports3D;
        this.supportsNon3D = supportsNon3D;
    }

    public void addSubtype(Subtype subtype, int afterSubtype) {
        int index = 0;
        if (afterSubtype > -1) {
            index = this.getSubtypeIndex(afterSubtype) + 1;
        }
        if (index == -1) {
            this.subtypes.addElement(subtype);
        } else {
            this.subtypes.insertElementAt(subtype, index);
        }
    }

    public void addSubtype(Subtype subtype) {
        this.subtypes.addElement(subtype);
    }

    public void removeSubtype(int subtypeID) {
        int index = this.getSubtypeIndex(subtypeID);
        if (index > -1) {
            this.subtypes.removeElementAt(index);
        }
    }

    protected int getSubtypeIndex(int subtypeID) {
        int length = this.subtypes.size();
        for (int i = 0; i < length; ++i) {
            Subtype subtype = (Subtype)this.subtypes.elementAt(i);
            if (subtypeID != subtype.id) continue;
            return i;
        }
        return -1;
    }
}

