/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseBorderLine;
import oracle.dss.graph.CommonGraph;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public abstract class BaseMinorTick
extends BaseBorderLine {
    public BaseMinorTick(CommonGraph graph) {
        super(graph);
    }

    @Override
    public boolean selectObject(int series, int group) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    public int getTickStyle() {
        return this.m_pfj.getGridStyle(this.m_identObj);
    }

    public void setTickStyle(int style) {
        if (style < 0 || style > 6) {
            this.m_commonGraph.getErrorHandler().log("invalid style", "oracle.dss.graph.BaseMinorTick", "setTickStyle(int style)");
        } else {
            this.m_pfj.setGridStyle(this.m_identObj, style);
        }
    }

    @Override
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getGridStyleObj(this.m_identObj);
        if (val != null) {
            int tmp = (Integer)val;
            if (tmp == 0) {
                node.addProperty("tickStyle", "GS_GRID");
            } else if (tmp == 1) {
                node.addProperty("tickStyle", "GS_EXTENDED");
            } else if (tmp == 2) {
                node.addProperty("tickStyle", "GS_IN");
            } else if (tmp == 3) {
                node.addProperty("tickStyle", "GS_OUT");
            } else if (tmp == 4) {
                node.addProperty("tickStyle", "GS_SPAN");
            } else if (tmp == 5) {
                node.addProperty("tickStyle", "GS_AUTOMATIC");
            } else {
                node.addProperty("tickStyle", "GS_NONE");
            }
            nodeExists = true;
        }
        return nodeExists;
    }

    @Override
    public void setStyleXML(ObjectNode node) {
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty("tickStyle");
        if (pNode != null) {
            String tmp = pNode.getValueAsString();
            int tickStyle = 0;
            tickStyle = tmp.equals("GS_GRID") ? 0 : (tmp.equals("GS_EXTENDED") ? 1 : (tmp.equals("GS_IN") ? 2 : (tmp.equals("GS_OUT") ? 3 : (tmp.equals("GS_SPAN") ? 4 : (tmp.equals("GS_AUTOMATIC") ? 5 : 6)))));
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("tickStyle", new Integer(tickStyle));
            } else {
                this.setTickStyle(tickStyle);
            }
        }
    }

    @Override
    @Deprecated
    public boolean isVisible() {
        return false;
    }

    @Override
    @Deprecated
    public void setVisible(boolean visible) {
    }

    @Override
    boolean isVisibleInXML() {
        return false;
    }
}

