/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.dss.gauge.CommonGauge;
import oracle.dss.gauge.CustomShapesParser;
import oracle.dss.gauge.SVGShapesHandler;
import oracle.dss.util.ErrorHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SVGParser
extends CustomShapesParser {
    public SVGParser(ErrorHandler eh) {
        super(eh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseFile(String path) {
        InputStream stream = null;
        try {
            stream = CommonGauge.class.getResourceAsStream(path);
            this.parseFile(stream);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                System.err.println("Caught IOException: " + e.getMessage());
            }
        }
    }

    @Override
    public void parseFile(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            SVGShapesHandler myHandler = new SVGShapesHandler(this);
            saxParser.parse(stream, (DefaultHandler)myHandler);
        }
        catch (Exception e) {
            this.m_eh.log("Problem parsing SVG Custom Shapes File: " + e.getStackTrace(), this.getClass().getName(), "parseFile");
        }
    }
}

