/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.util.Utils;

public class PKCS12SafeContentsBag
extends PKCS12Bag {
    private PKCS12Safe parent;
    private Vector bags;
    private ASN1Sequence contents;

    public PKCS12SafeContentsBag() {
    }

    public PKCS12SafeContentsBag(PKCS12Safe parent) {
        this.parent = parent;
    }

    public PKCS12SafeContentsBag(PKCS12Safe parent, Vector bags) {
        this(parent);
        this.bags = bags;
    }

    public PKCS12SafeContentsBag(PKCS12Safe parent, InputStream is) throws IOException {
        this(parent);
        this.input(is);
    }

    public PKCS12SafeContentsBag(PKCS12Safe parent, ASN1Sequence s) throws IOException {
        this(parent);
        this.input(s);
    }

    void reset() {
        this.contents = null;
        if (this.parent != null) {
            this.parent.reset();
        }
    }

    public void input(InputStream is) throws IOException {
        this.input(new ASN1Sequence(is));
    }

    public void input(ASN1Sequence s) throws IOException {
        this.reset();
        try {
            ASN1GenericConstructed bc = (ASN1GenericConstructed)s.elementAt(1);
            ASN1Sequence cb = (ASN1Sequence)bc.elementAt(0);
            this.bags = new Vector();
            int n = cb.size();
            for (int i = 0; i < n; ++i) {
                this.bags.addElement(PKCS12Bag.inputBag(null, (ASN1Sequence)cb.elementAt(i)));
            }
        }
        catch (ClassCastException ex) {
            throw new ASN1FormatException(ex.toString());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ASN1FormatException(ex.toString());
        }
    }

    public void output(OutputStream os) throws IOException {
        this.outputASN1().output(os);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence s = new ASN1Sequence();
        s.addElement((ASN1Object)new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 6));
        ASN1Sequence cb = new ASN1Sequence(this.bags);
        s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)cb, 0));
        ASN1Set attr = this.outputAttrsASN1();
        if (attr != null) {
            s.addElement((ASN1Object)attr);
        }
        this.contents = s;
        return s;
    }

    public int length() {
        return this.outputASN1().length();
    }

    public Vector getBags() {
        return this.bags;
    }

    public void setBags(Vector bags) {
        this.bags = bags;
        this.reset();
    }

    public void addBag(PKCS12Bag b) {
        if (this.bags == null) {
            this.bags = new Vector();
        }
        this.bags.addElement(b);
        this.reset();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        if (this.friendlyName != null) {
            s.append("friendlyName = \"" + this.friendlyName + "\", ");
        }
        if (this.localKeyID != null) {
            s.append("localKeyID = " + Utils.toHexString((byte[])this.localKeyID) + ", ");
        }
        s.append("bags = {");
        int n = this.bags.size();
        for (int i = 0; i < n; ++i) {
            s.append(this.bags.elementAt(i).toString());
            if (i == n - 1) continue;
            s.append(", ");
        }
        s.append('}');
        return s.toString();
    }
}

