/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.AttributeTypeAndValue;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class AttributeTypeAndValueList
implements ASN1Object,
Cloneable,
Externalizable {
    private Vector attributes = new Vector();
    private Hashtable attrMap = new Hashtable();
    private transient ASN1Sequence contents;

    public AttributeTypeAndValueList() {
    }

    public AttributeTypeAndValueList(InputStream is) throws IOException {
        this.input(is);
    }

    public AttributeTypeAndValue addAttribute(AttributeTypeAndValue attr) {
        AttributeTypeAndValue a = (AttributeTypeAndValue)this.attrMap.get(attr.getType());
        if (a != null) {
            this.attributes.removeElement(a);
        }
        this.attributes.addElement(attr);
        this.attrMap.put(attr.getType(), attr);
        this.update();
        return a;
    }

    public AttributeTypeAndValue addAttribute(ASN1ObjectID type, ASN1Object value) {
        return this.addAttribute(new AttributeTypeAndValue(type, value));
    }

    public AttributeTypeAndValue getAttribute(ASN1ObjectID type) {
        if (this.hasAttribute(type)) {
            return (AttributeTypeAndValue)this.attrMap.get(type);
        }
        return null;
    }

    public ASN1Object getAttributeValue(ASN1ObjectID type) {
        AttributeTypeAndValue a = this.getAttribute(type);
        return a != null ? a.getValue() : null;
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public boolean hasAttribute(ASN1ObjectID type) {
        return this.attrMap.containsKey(type);
    }

    public Enumeration types() {
        return this.attrMap.keys();
    }

    public Object clone() {
        try {
            AttributeTypeAndValueList a = (AttributeTypeAndValueList)super.clone();
            a.attributes = (Vector)this.attributes.clone();
            a.attrMap = (Hashtable)this.attrMap.clone();
            return a;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.toString());
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("{ ");
        int n = this.attributes.size();
        for (int i = 0; i < n; ++i) {
            s.append(this.attributes.elementAt(i));
            if (i >= n - 1) continue;
            s.append(", ");
        }
        s.append(" }");
        return s.toString();
    }

    public Vector elements() {
        return this.attributes;
    }

    public int size() {
        return this.attributes.size();
    }

    public AttributeTypeAndValue elementAt(int n) {
        return (AttributeTypeAndValue)this.attributes.elementAt(n);
    }

    public void input(InputStream is) throws IOException {
        this.attributes.removeAllElements();
        this.attrMap.clear();
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        while (sis.hasMoreData()) {
            AttributeTypeAndValue attr = new AttributeTypeAndValue((InputStream)sis);
            this.attributes.addElement(attr);
            this.attrMap.put(attr.getType(), attr);
        }
        sis.terminate();
        this.update();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    public int length() {
        return this.toASN1().length();
    }

    ASN1Sequence toASN1() {
        if (this.contents == null) {
            this.contents = new ASN1Sequence(this.attributes);
        }
        return this.contents;
    }

    private void update() {
        this.contents = null;
    }

    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

