/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1SetInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class Attribute
implements ASN1Object,
Externalizable {
    private ASN1ObjectID type;
    private Vector values;
    private ASN1Sequence seq = null;

    public Attribute() {
    }

    public Attribute(ASN1ObjectID type) {
        this.type = type;
        this.values = new Vector();
    }

    public Attribute(ASN1ObjectID type, ASN1Object value) {
        this(type);
        this.addValue(value);
    }

    public Attribute(ASN1ObjectID type, Vector values) {
        this(type);
        this.setValues(values);
    }

    public Attribute(InputStream is) throws IOException {
        this.input(is);
    }

    public ASN1ObjectID getType() {
        return this.type;
    }

    public void addValue(ASN1Object value) {
        this.values.addElement(value);
        this.reset();
    }

    public void setValues(Vector values) {
        if (values.size() == 0) {
            throw new IllegalArgumentException("Attribute value set may not be empty");
        }
        this.values.removeAllElements();
        this.reset();
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            this.values.addElement((ASN1Object)values.elementAt(i));
        }
    }

    public Enumeration values() {
        return this.values.elements();
    }

    public Vector getValues() {
        return this.values;
    }

    public int size() {
        return this.values.size();
    }

    public String toString() {
        String s = this.type + " : {";
        Enumeration e = this.values();
        while (e.hasMoreElements()) {
            s = s + " " + e.nextElement();
            if (!e.hasMoreElements()) continue;
            s = s + ",";
        }
        s = s + " }";
        return s;
    }

    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
        this.type = new ASN1ObjectID((InputStream)seq);
        this.values = new Vector();
        ASN1SetInputStream set = new ASN1SetInputStream((InputStream)seq);
        do {
            this.values.addElement(ASN1Utils.inputASN1Object((InputStream)set));
        } while (seq.hasMoreData());
        set.terminate();
        seq.terminate();
        this.reset();
    }

    private void reset() {
        this.seq = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.seq == null) {
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)this.type);
            s.addElement((ASN1Object)new ASN1Set(this.values()));
            this.seq = s;
        }
        return this.seq;
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

