/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.dialogs.newjob;

import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobCreateActionDialogTab_AdvancedProperties;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobCreateActionDialogTab_Destination;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobCreateActionDialogTab_EditProperties;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobCreateActionDialogTab_JobArguments;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobCreateActionDialogTab_Notification;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobModel;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.common.ActionDialogBase;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;

public abstract class NewJobCreateBase2
extends ActionDialogBase {
    protected NewJobModel model;
    protected NewJobCreateActionDialogTab_EditProperties editTab = null;
    protected NewJobCreateActionDialogTab_Destination destinationTab = null;
    protected NewJobCreateActionDialogTab_JobArguments jobArgumentsTab = null;
    protected NewJobCreateActionDialogTab_Notification notificationTab = null;
    protected NewJobCreateActionDialogTab_AdvancedProperties advancedPropertiesTab = null;
    protected List<ActionDialogTab> additionalTabsList = null;
    protected String classArgs = null;
    List<String> deleted;
    List<String> added;
    List<ActionControl> controls = null;
    JEWTDialog dialog;

    protected NewJobModel getJobModel() {
        return this.model;
    }

    @Override
    protected DatabaseQueryTask<List<String>> getListTask() {
        return new ListTask();
    }

    @Override
    protected String getObjectType() {
        return "SCHNEWJOB";
    }

    protected void onCommandComplete() {
    }

    public boolean isEnabled(Context context) {
        Version version = new Version("10");
        return DBUtil.checkVersion((Connection)this.getDBObject().getConnection(), null, (Version)version) && super.isEnabled(context);
    }

    @Override
    public void launch() {
        this.model = new NewJobModel(this.getDBObject(), this.getOperation());
        super.launch();
    }

    protected ActionDialogTab createEditPaneTab() {
        NewJobModel.Operation operation = this.model.getOperation();
        if (operation != NewJobModel.Operation.CREATE_NEW) {
            this.model.setPreviousJobInformation();
            this.model.setPreviousJobParallelInstanceData();
            this.model.setPreviousJobJobArgsData();
            this.model.setPreviousJobNotificationInformation();
            this.model.setPreviousJobDestinationInformation();
        } else {
            this.model.setNewJobInformation();
        }
        this.editTab = new NewJobCreateActionDialogTab_EditProperties(null, this.defaultEditPaneTabTitle(), this.model);
        return this.editTab;
    }

    protected List<ActionDialogTab> createAdditionalTabs() {
        this.additionalTabsList = new ArrayList<ActionDialogTab>();
        if (this.model.FeatureMin111() && !this.model.FeatureisXE()) {
            this.destinationTab = new NewJobCreateActionDialogTab_Destination("job_destination_panel", SchedulerArb.getString("JOB_CREATE_TAB_DESTINATION"), this.model);
            this.additionalTabsList.add(this.destinationTab);
        }
        this.jobArgumentsTab = new NewJobCreateActionDialogTab_JobArguments("job_arguments_panel", SchedulerArb.getString("JOB_CREATE_TAB_JOB_ARGUMENTS"), this.model);
        this.additionalTabsList.add(this.jobArgumentsTab);
        if (this.model.FeatureMin112()) {
            this.notificationTab = new NewJobCreateActionDialogTab_Notification("job_email_notification_panel", SchedulerArb.getString("JOB_CREATE_TAB_EMAIL_NOTIFICATION"), this.model);
            this.additionalTabsList.add(this.notificationTab);
        }
        this.advancedPropertiesTab = new NewJobCreateActionDialogTab_AdvancedProperties("job_advanced_properties_panel", SchedulerArb.getString("JOB_CREATE_TAB_ADVANCED_PROPERTIES"), this.model);
        this.additionalTabsList.add(this.advancedPropertiesTab);
        for (ActionDialogTab actionDialogTab : this.additionalTabsList) {
            this.editTab.addListener(actionDialogTab);
        }
        return this.additionalTabsList;
    }

    protected List<ActionControl> createControls(Connection connection) {
        return this.controls;
    }

    protected NewJobModel.Operation getOperation() {
        return NewJobModel.Operation.valueOf(this.getArgs());
    }

    public abstract String getArgs();

    protected void initializeValues(JEWTDialog jEWTDialog) {
        this.dialog = jEWTDialog;
        this.editTab.setEditOptions();
        int n = jEWTDialog.getButtonMask();
        jEWTDialog.setButtonMask(n |= 4);
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "f1_job_details_html");
    }

    protected boolean allowApplyScript() {
        boolean bl = true;
        ActionDialog.Values values = this.getValues();
        String string = values.get("JOB_NAME");
        String string2 = values.get("WHAT_WHEN/WHEN_JOB_TYPE_PANEL_NAME/schedule_type");
        String string3 = values.get("WHAT_WHEN/WHEN_JOB_TYPE_PANEL_NAME/queue_spec");
        if (string2.equals("EVENT") && (string3 == null || string3.trim().length() == 0)) {
            MessageDialog.error((Component)this.dialog, (Object)SchedulerArb.get("JOB_CREATE_EVENT_QUEUE_NAME_LENGTH_ZERO"), (String)UiResources.getString((String)"ERROR_TITLE"), null);
            bl = false;
        } else if (string == null || string.trim().length() == 0) {
            MessageDialog.error((Component)this.dialog, (Object)SchedulerArb.get("JOB_CREATE_NAME_LENGTH_ZERO"), (String)UiResources.getString((String)"ERROR_TITLE"), null);
            bl = false;
        }
        return bl;
    }

    protected boolean isCloseOnError() {
        return false;
    }

    private class ListTask
    extends DatabaseQueryTask<List<String>> {
        public ListTask() {
            super("ListTask", IRaptorTaskRunMode.NO_GUI, false, false);
        }

        public String getConnectionName() {
            return NewJobCreateBase2.this.getDBObject().getConnectionName();
        }

        public String getQuery() {
            DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
            String string = dBMSSchedulerCodeGenerator.generate(NewJobCreateBase2.this.getDBObject().getDBVersion(), "JOB_LIST", null);
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<String> doWork() throws TaskException {
            Vector<String> vector = new Vector<String>();
            Connection connection = NewJobCreateBase2.this.getDBObject().getConnection();
            DBUtil.getConnectionResolver().lock(connection);
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                ResultSet resultSet = dBUtil.executeOracleQuery(this.getQuery(), null);
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString("OWNER") + "." + resultSet.getString("JOB_NAME");
                        vector.add(string);
                    }
                }
                finally {
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
            }
            catch (Exception exception) {
                throw new TaskException((Throwable)exception);
            }
            finally {
                DBUtil.getConnectionResolver().unlock(connection);
            }
            return vector;
        }
    }
}

