/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.metadata.mdm.MdmDimensionLevel;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.syntax.BaseMetadataObjectReference;
import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.MetadataObjectReference;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.ExpParser;

public final class SymmetricConditionElement
extends SyntaxObject {
    public static final String ALL = "ALL";
    public static final String NONE = "NONE";
    static final String[] SIMPLE_QUALIFIERS = new String[]{"ALL", "NONE"};
    private BaseMetadataObjectReference m_Dimension;
    private String m_Qualifier;
    private Condition m_Condition;
    private BaseMetadataObjectReference[] m_Levels;

    BaseMetadataObjectReference getDimensionReference() {
        return this.m_Dimension;
    }

    private BaseMetadataObjectReference[] getLevelsInternal() {
        return this.m_Levels;
    }

    private SymmetricConditionElement(MdmPrimaryDimension mdmPrimaryDimension, String string, Condition condition, MdmDimensionLevel[] mdmDimensionLevelArray, boolean bl) {
        SymmetricConditionElement.validateValue(mdmPrimaryDimension);
        this.m_Dimension = new MetadataObjectReference(mdmPrimaryDimension, MdmPrimaryDimension.class);
        if (null != string) {
            this.m_Qualifier = SymmetricConditionElement.validateEnum(string, SIMPLE_QUALIFIERS);
        } else if (null != condition) {
            SymmetricConditionElement.validateValue(condition);
            this.m_Condition = condition;
        } else {
            SymmetricConditionElement.validateValues(mdmDimensionLevelArray);
            this.m_Levels = new BaseMetadataObjectReference[mdmDimensionLevelArray.length];
            for (int i = 0; i < mdmDimensionLevelArray.length; ++i) {
                this.m_Levels[i] = new MetadataObjectReference(mdmDimensionLevelArray[i], MdmDimensionLevel.class);
            }
        }
        this.initialize();
    }

    private SymmetricConditionElement(ExpParser expParser, BaseMetadataObjectReference baseMetadataObjectReference, String string, Condition condition, BaseMetadataObjectReference[] baseMetadataObjectReferenceArray, boolean bl) {
        SymmetricConditionElement.validateValue(baseMetadataObjectReference);
        this.m_Dimension = baseMetadataObjectReference;
        if (null != string) {
            this.m_Qualifier = SymmetricConditionElement.validateEnum(string, SIMPLE_QUALIFIERS);
        } else if (null != condition) {
            SymmetricConditionElement.validateValue(condition);
            this.m_Condition = condition;
        } else {
            SymmetricConditionElement.validateValues(baseMetadataObjectReferenceArray);
            this.m_Levels = bl ? (BaseMetadataObjectReference[])baseMetadataObjectReferenceArray.clone() : baseMetadataObjectReferenceArray;
        }
        this.initialize();
    }

    private static MdmDimensionLevel[] createMdmDimLevelArray(List<MdmDimensionLevel> list) {
        if (null == list) {
            return null;
        }
        MdmDimensionLevel[] mdmDimensionLevelArray = new MdmDimensionLevel[list.size()];
        list.toArray(mdmDimensionLevelArray);
        return mdmDimensionLevelArray;
    }

    private static BaseMetadataObjectReference[] createMdmDimLevelArray(ExpParser expParser, List<BaseMetadataObjectReference> list) {
        if (null == list) {
            return null;
        }
        BaseMetadataObjectReference[] baseMetadataObjectReferenceArray = new BaseMetadataObjectReference[list.size()];
        list.toArray(baseMetadataObjectReferenceArray);
        return baseMetadataObjectReferenceArray;
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        super.validate(validationContext);
        validationContext.pop();
        this.m_Dimension = (BaseMetadataObjectReference)validationContext.validate(this.m_Dimension);
        if (null != this.getLevelsInternal()) {
            for (int i = 0; i < this.getLevelsInternal().length; ++i) {
                this.getLevelsInternal()[i] = (BaseMetadataObjectReference)validationContext.validate(this.getLevelsInternal()[i]);
            }
        }
        if (null != this.m_Condition) {
            validationContext.validate(this.m_Condition);
        }
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (!this.m_Dimension.isDefinitionComplete()) {
            return false;
        }
        if (null != this.getLevelsInternal()) {
            for (int i = 0; i < this.getLevelsInternal().length; ++i) {
                if (this.getLevelsInternal()[i].isDefinitionComplete()) continue;
                return false;
            }
        }
        if (null != this.m_Condition) {
            return this.m_Condition.isDefinitionComplete();
        }
        return super.checkIfDefinitionIsComplete();
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        boolean bl = null == syntaxPrintingContext.getXMLWriter() || syntaxPrintingContext.getXMLWriter().isMetadataXMLVersionSameOrLaterThan("1.2");
        this.getDimensionReference().toSyntax(syntaxPrintingContext);
        if (null != this.m_Qualifier) {
            if (this.m_Qualifier.equalsIgnoreCase(ALL)) {
                if (bl) {
                    syntaxPrintingContext.append(" ALL");
                } else {
                    syntaxPrintingContext.append(" WHERE (1 = 1)");
                }
            } else if (bl) {
                syntaxPrintingContext.append(" NONE");
            } else {
                syntaxPrintingContext.append(" WHERE (1 != 1)");
            }
        } else if (null != this.m_Condition) {
            syntaxPrintingContext.append(" WHERE ");
            syntaxPrintingContext.print(this.m_Condition);
        } else if (bl) {
            syntaxPrintingContext.append(" LEVELS (");
            for (int i = 0; i < this.getLevelsInternal().length; ++i) {
                if (0 != i) {
                    syntaxPrintingContext.append(",");
                    syntaxPrintingContext.newLineAndIndent();
                }
                this.getLevelsInternal()[i].toSyntax(syntaxPrintingContext);
            }
            syntaxPrintingContext.append(")");
        } else {
            syntaxPrintingContext.append(" WHERE ");
            this.getDimensionReference().toSyntax(syntaxPrintingContext);
            syntaxPrintingContext.append(".LEVEL_NAME ");
            if (1 == this.getLevelsInternal().length) {
                syntaxPrintingContext.append("= ");
                syntaxPrintingContext.appendQuotedString(this.getLevelsInternal()[0].getName());
            } else {
                syntaxPrintingContext.append("IN (");
                for (int i = 0; i < this.getLevelsInternal().length; ++i) {
                    if (0 != i) {
                        syntaxPrintingContext.append(",");
                        syntaxPrintingContext.newLineAndIndent();
                    }
                    syntaxPrintingContext.appendQuotedString(this.getLevelsInternal()[i].getName());
                }
                syntaxPrintingContext.append(")");
            }
        }
    }

    public SymmetricConditionElement(MdmPrimaryDimension mdmPrimaryDimension, String string) {
        this(mdmPrimaryDimension, string, null, null, false);
    }

    public SymmetricConditionElement(MdmPrimaryDimension mdmPrimaryDimension, Condition condition) {
        this(mdmPrimaryDimension, null, condition, null, false);
    }

    public SymmetricConditionElement(MdmPrimaryDimension mdmPrimaryDimension, MdmDimensionLevel[] mdmDimensionLevelArray) {
        this(mdmPrimaryDimension, null, null, mdmDimensionLevelArray, true);
    }

    public SymmetricConditionElement(MdmPrimaryDimension mdmPrimaryDimension, List<MdmDimensionLevel> list) {
        this(mdmPrimaryDimension, null, null, SymmetricConditionElement.createMdmDimLevelArray(list), false);
    }

    public SymmetricConditionElement(ExpParser expParser, BaseMetadataObjectReference baseMetadataObjectReference, String string) {
        this(expParser, baseMetadataObjectReference, string, null, null, false);
    }

    public SymmetricConditionElement(ExpParser expParser, BaseMetadataObjectReference baseMetadataObjectReference, Condition condition) {
        this(expParser, baseMetadataObjectReference, null, condition, null, false);
    }

    public SymmetricConditionElement(ExpParser expParser, BaseMetadataObjectReference baseMetadataObjectReference, BaseMetadataObjectReference[] baseMetadataObjectReferenceArray) {
        this(expParser, baseMetadataObjectReference, null, null, baseMetadataObjectReferenceArray, true);
    }

    public SymmetricConditionElement(ExpParser expParser, BaseMetadataObjectReference baseMetadataObjectReference, List<BaseMetadataObjectReference> list) {
        this(expParser, baseMetadataObjectReference, null, null, SymmetricConditionElement.createMdmDimLevelArray(expParser, list), false);
    }

    public MdmPrimaryDimension getDimension() {
        return (MdmPrimaryDimension)this.m_Dimension.getBaseMetadataObject();
    }

    public String getDimensionID() {
        return this.m_Dimension.getIdentifier().toString();
    }

    public Condition getCondition() {
        return this.m_Condition;
    }

    public String[] getLevelIDs() {
        if (null != this.getLevelsInternal()) {
            String[] stringArray = new String[this.getLevelsInternal().length];
            for (int i = 0; i < this.getLevelsInternal().length; ++i) {
                stringArray[i] = this.getLevelsInternal()[i].getIdentifier().toString();
            }
            return stringArray;
        }
        return null;
    }

    public MdmDimensionLevel[] getLevels() {
        if (null != this.getLevelsInternal()) {
            MdmDimensionLevel[] mdmDimensionLevelArray = new MdmDimensionLevel[this.getLevelsInternal().length];
            for (int i = 0; i < this.getLevelsInternal().length; ++i) {
                mdmDimensionLevelArray[i] = (MdmDimensionLevel)this.getLevelsInternal()[i].getBaseMetadataObject();
            }
            return mdmDimensionLevelArray;
        }
        return null;
    }

    public String getQualifier() {
        if (null != this.m_Qualifier) {
            if (this.m_Qualifier.equalsIgnoreCase(ALL)) {
                return ALL;
            }
            return NONE;
        }
        return null;
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitSymmetricConditionElement(this, object);
    }
}

