/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.metadata.mdm.MdmBaseMeasure;
import oracle.olapi.syntax.BaseMetadataObjectReference;
import oracle.olapi.syntax.BuildCommand;
import oracle.olapi.syntax.MetadataObjectReference;
import oracle.olapi.syntax.SimpleCommand;
import oracle.olapi.syntax.SymmetricCondition;
import oracle.olapi.syntax.SyntaxException;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.ExpParser;

public final class GroupCommand
extends BuildCommand {
    private SimpleCommand[] m_Commands;
    private SymmetricCondition m_SymmetricCondition;
    private BaseMetadataObjectReference[] m_Measures;

    private BaseMetadataObjectReference[] getMeasuresInternal() {
        return this.m_Measures;
    }

    private SimpleCommand[] getCommandsInternal() {
        return this.m_Commands;
    }

    private GroupCommand(SimpleCommand[] simpleCommandArray, SymmetricCondition symmetricCondition, MdmBaseMeasure[] mdmBaseMeasureArray, boolean bl) {
        if (null == symmetricCondition && null == mdmBaseMeasureArray) {
            throw new SyntaxException("List of WhereConditions and/or Measures expected");
        }
        this.m_SymmetricCondition = symmetricCondition;
        if (null != mdmBaseMeasureArray) {
            GroupCommand.validateValues(mdmBaseMeasureArray);
            this.m_Measures = new BaseMetadataObjectReference[mdmBaseMeasureArray.length];
            for (int i = 0; i < mdmBaseMeasureArray.length; ++i) {
                this.m_Measures[i] = new MetadataObjectReference(mdmBaseMeasureArray[i], MdmBaseMeasure.class);
            }
        }
        GroupCommand.validateValues(simpleCommandArray);
        this.m_Commands = bl ? (SimpleCommand[])simpleCommandArray.clone() : simpleCommandArray;
        this.initialize();
    }

    private GroupCommand(ExpParser expParser, SimpleCommand[] simpleCommandArray, SymmetricCondition symmetricCondition, BaseMetadataObjectReference[] baseMetadataObjectReferenceArray, boolean bl) {
        if (null == symmetricCondition && null == baseMetadataObjectReferenceArray) {
            throw new SyntaxException("List of WhereConditions and/or Measures expected");
        }
        this.m_SymmetricCondition = symmetricCondition;
        if (null != baseMetadataObjectReferenceArray) {
            GroupCommand.validateValues(baseMetadataObjectReferenceArray);
            this.m_Measures = bl ? (BaseMetadataObjectReference[])baseMetadataObjectReferenceArray.clone() : baseMetadataObjectReferenceArray;
        }
        GroupCommand.validateValues(simpleCommandArray);
        this.m_Commands = bl ? (SimpleCommand[])simpleCommandArray.clone() : simpleCommandArray;
        this.initialize();
    }

    private static SimpleCommand[] createSimpleCommandArray(List<SimpleCommand> list) {
        if (null == list) {
            return null;
        }
        SimpleCommand[] simpleCommandArray = new SimpleCommand[list.size()];
        list.toArray(simpleCommandArray);
        return simpleCommandArray;
    }

    private static MdmBaseMeasure[] createMdmBaseMeasureArray(List<MdmBaseMeasure> list) {
        if (null == list) {
            return null;
        }
        MdmBaseMeasure[] mdmBaseMeasureArray = new MdmBaseMeasure[list.size()];
        list.toArray(mdmBaseMeasureArray);
        return mdmBaseMeasureArray;
    }

    private static BaseMetadataObjectReference[] createMdmBaseMeasureArray(ExpParser expParser, List<BaseMetadataObjectReference> list) {
        if (null == list) {
            return null;
        }
        BaseMetadataObjectReference[] baseMetadataObjectReferenceArray = new BaseMetadataObjectReference[list.size()];
        list.toArray(baseMetadataObjectReferenceArray);
        return baseMetadataObjectReferenceArray;
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        super.validate(validationContext);
        validationContext.pop();
        validationContext.validateComponents(this, this.getCommandsInternal());
        if (null != this.getWhereCondition()) {
            validationContext.validateSymmetricCond(this.getWhereCondition());
        }
        if (null != this.getMeasuresInternal()) {
            for (int i = 0; i < this.getMeasuresInternal().length; ++i) {
                this.getMeasuresInternal()[i] = (BaseMetadataObjectReference)validationContext.validate(this.getMeasuresInternal()[i]);
            }
        }
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (null != this.getWhereCondition() && !this.getWhereCondition().isDefinitionComplete()) {
            return false;
        }
        if (null != this.getMeasuresInternal()) {
            for (int i = 0; i < this.getMeasuresInternal().length; ++i) {
                if (this.getMeasuresInternal()[i].isDefinitionComplete()) continue;
                return false;
            }
        }
        if (!this.areComponentsComplete(this.getCommandsInternal())) {
            return false;
        }
        return super.checkIfDefinitionIsComplete();
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        int n;
        syntaxPrintingContext.append("FOR");
        syntaxPrintingContext.incrementIndent();
        if (null != this.getWhereCondition()) {
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.print(this.getWhereCondition());
        }
        if (null != this.getMeasuresInternal()) {
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.append("MEASURES");
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.append("(");
            syntaxPrintingContext.newLineAndIndent();
            for (n = 0; n < this.getMeasuresInternal().length; ++n) {
                if (0 != n) {
                    syntaxPrintingContext.append(", ");
                }
                this.getMeasuresInternal()[n].toSyntax(syntaxPrintingContext);
            }
            syntaxPrintingContext.append(")");
        }
        syntaxPrintingContext.decrementIndent();
        syntaxPrintingContext.newLineAndIndent();
        syntaxPrintingContext.append("BUILD");
        syntaxPrintingContext.newLineAndIndent();
        syntaxPrintingContext.append("(");
        for (n = 0; n < this.getCommandsInternal().length; ++n) {
            if (0 != n) {
                syntaxPrintingContext.append(", ");
            }
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.print(this.getCommandsInternal()[n]);
        }
        syntaxPrintingContext.newLineAndIndent();
        syntaxPrintingContext.append(")");
    }

    public GroupCommand(SimpleCommand[] simpleCommandArray, SymmetricCondition symmetricCondition) {
        this(simpleCommandArray, symmetricCondition, null, true);
    }

    public GroupCommand(SimpleCommand[] simpleCommandArray, MdmBaseMeasure[] mdmBaseMeasureArray) {
        this(simpleCommandArray, null, mdmBaseMeasureArray, true);
    }

    public GroupCommand(SimpleCommand[] simpleCommandArray, SymmetricCondition symmetricCondition, MdmBaseMeasure[] mdmBaseMeasureArray) {
        this(simpleCommandArray, symmetricCondition, mdmBaseMeasureArray, true);
    }

    public GroupCommand(List<SimpleCommand> list, SymmetricCondition symmetricCondition, List<MdmBaseMeasure> list2) {
        this(GroupCommand.createSimpleCommandArray(list), symmetricCondition, GroupCommand.createMdmBaseMeasureArray(list2), false);
    }

    public GroupCommand(ExpParser expParser, List<SimpleCommand> list, SymmetricCondition symmetricCondition, List<BaseMetadataObjectReference> list2) {
        this(expParser, GroupCommand.createSimpleCommandArray(list), symmetricCondition, GroupCommand.createMdmBaseMeasureArray(expParser, list2), false);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitGroupCommand(this, object);
    }

    public MdmBaseMeasure[] getMeasures() {
        if (null != this.getMeasuresInternal()) {
            MdmBaseMeasure[] mdmBaseMeasureArray = new MdmBaseMeasure[this.getMeasuresInternal().length];
            for (int i = 0; i < this.getMeasuresInternal().length; ++i) {
                mdmBaseMeasureArray[i] = (MdmBaseMeasure)this.getMeasuresInternal()[i].getBaseMetadataObject();
            }
            return mdmBaseMeasureArray;
        }
        return null;
    }

    public String[] getMeasureIDs() {
        if (null != this.getMeasuresInternal()) {
            String[] stringArray = new String[this.getMeasuresInternal().length];
            for (int i = 0; i < this.getMeasuresInternal().length; ++i) {
                stringArray[i] = this.getMeasuresInternal()[i].getIdentifier().toString();
            }
            return stringArray;
        }
        return null;
    }

    public SymmetricCondition getWhereCondition() {
        return this.m_SymmetricCondition;
    }

    public SimpleCommand[] getCommands() {
        return (SimpleCommand[])this.getCommandsInternal().clone();
    }
}

