/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.List;
import oracle.express.mdm.MetadataNotFoundException;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.DuplicateMetadataIDException;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mapping.SolvedLevelHierarchyMap;
import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmDimensionLevel;
import oracle.olapi.metadata.mdm.MdmDimensionMemberInfo;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmHierarchyLevel;
import oracle.olapi.metadata.mdm.MdmInvalidValueException;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObjectVisitor;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmQueryColumn;
import oracle.olapi.metadata.mdm.MdmXMLTags;
import oracle.olapi.metadata.mtm.MtmExpression;
import oracle.olapi.metadata.mtm.MtmLevelHierarchyMap;
import oracle.olapi.metadata.mtm.MtmLevelMap;
import oracle.olapi.metadata.mtm.MtmSourceMap;
import oracle.olapi.metadata.mtm.MtmValueExpression;

public final class MdmLevelHierarchy
extends MdmHierarchy {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{MdmXMLTags.HIERARCHY_LEVELS, MdmXMLTags.DEFAULT_MEMBER_LEVEL, MdmXMLTags.SOLVED_LEVEL_HIERARCHY_MAP, MdmXMLTags.IS_SKIP_LEVEL, MdmXMLTags.IS_RAGGED};

    protected MdmLevelHierarchy(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    MdmLevelHierarchy(String string, short s, MdmPrimaryDimension mdmPrimaryDimension) {
        super(string, s, mdmPrimaryDimension);
    }

    @Override
    public Object acceptVisitor(MdmObjectVisitor mdmObjectVisitor, Object object) {
        return mdmObjectVisitor.visitMdmLevelHierarchy(this, object);
    }

    public MdmLevel addLevel(String string, MtmExpression mtmExpression) {
        String string2 = this.getMetadataProvider().getMdmNamingConvention().generateLevelID(this, string);
        MdmLevel mdmLevel = this.getMetadataProvider().getMdmObjectFactory().createLevel(string2);
        mdmLevel.setName(string);
        MtmLevelMap mtmLevelMap = this.getMetadataProvider().getMtmObjectFactory().createLevelMap();
        mtmLevelMap.setLevelExpression(mtmExpression);
        mdmLevel.setSourceMap(mtmLevelMap);
        this.addToListProperty(MdmXMLTags.HIERARCHY_LEVELS, mdmLevel);
        return mdmLevel;
    }

    public final MdmAttribute getLevelAttribute() {
        return this.getPrimaryDimension().getLevelAttribute();
    }

    public final MdmAttribute getLevelDepthAttribute() {
        return this.getPrimaryDimension().getLevelDepthAttribute();
    }

    public MtmLevelHierarchyMap getLevelHierarchyMap() throws MetadataNotFoundException {
        return (MtmLevelHierarchyMap)this.getSourceMap();
    }

    public final List getLevels() {
        return this.getPropertyListValues(MdmXMLTags.HIERARCHY_LEVELS);
    }

    public final List<MdmHierarchyLevel> getHierarchyLevels() {
        return this.getLevels();
    }

    @Override
    public MdmDimensionMemberInfo getDefaultMember() throws MetadataNotFoundException {
        String string = this.getPropertyStringValue(MdmXMLTags.DEFAULT_MEMBER);
        MdmLevel mdmLevel = (MdmLevel)this.getPropertyObjectValue(MdmXMLTags.DEFAULT_MEMBER_LEVEL);
        if (string != null && mdmLevel != null) {
            return new MdmDimensionMemberInfo(mdmLevel, (Object)string);
        }
        throw new MetadataNotFoundException();
    }

    @Override
    public void setDefaultMember(MdmDimensionMemberInfo mdmDimensionMemberInfo) throws MetadataNotFoundException, MdmInvalidValueException {
        if (mdmDimensionMemberInfo.getHierarchy() != this || mdmDimensionMemberInfo.getLevel() == null || mdmDimensionMemberInfo.getLevel().getLevelHierarchy() != this) {
            throw new MdmInvalidValueException("Default member must be a member of this hierarchy.");
        }
        this.setPropertyStringValue(MdmXMLTags.DEFAULT_MEMBER, mdmDimensionMemberInfo.getLocalValue().toString());
        this.setPropertyObjectValue(MdmXMLTags.DEFAULT_MEMBER_LEVEL, mdmDimensionMemberInfo.getLevel());
    }

    @Override
    protected XMLTag getXMLTag() {
        return MdmXMLTags.LEVEL_HIERARCHY_TAG;
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    private void regenerate() {
        BaseMetadataObject baseMetadataObject2;
        this.getPrimaryDimension().setDescription(this.getPrimaryDimension().getDescription());
        for (Object object : this.getPrimaryDimension().getAttributes()) {
            baseMetadataObject2 = ((MdmAttribute)object).getAttributeMap();
            ((MtmSourceMap)baseMetadataObject2).setMdmSource(((MtmSourceMap)baseMetadataObject2).getMdmSource());
        }
        for (BaseMetadataObject baseMetadataObject2 : this.getLevels()) {
            MtmLevelMap mtmLevelMap = ((MdmLevel)baseMetadataObject2).getLevelMap();
            mtmLevelMap.setLevelExpression(mtmLevelMap.getLevelExpression());
        }
        baseMetadataObject2 = this.getLevelHierarchyMap();
        ((MtmLevelHierarchyMap)baseMetadataObject2).setTable(((MtmLevelHierarchyMap)baseMetadataObject2).getTable());
    }

    void addLevel(MdmLevel mdmLevel, int n) {
        this.addToListProperty(MdmXMLTags.HIERARCHY_LEVELS, mdmLevel, n);
        this.regenerate();
    }

    public void addHierarchyLevel(MdmHierarchyLevel mdmHierarchyLevel, int n) {
        this.addToListProperty(MdmXMLTags.HIERARCHY_LEVELS, mdmHierarchyLevel, n);
        if (null == mdmHierarchyLevel.getLevelHierarchy()) {
            mdmHierarchyLevel.setLevelHierarchy(this);
        }
    }

    public void addHierarchyLevel(MdmHierarchyLevel mdmHierarchyLevel) {
        this.addHierarchyLevel(mdmHierarchyLevel, this.getHierarchyLevels().size());
    }

    public void removeLevel(MdmLevel mdmLevel) {
        this.removeFromListProperty(MdmXMLTags.HIERARCHY_LEVELS, mdmLevel);
        this.regenerate();
    }

    public void removeHierarchyLevel(MdmHierarchyLevel mdmHierarchyLevel) {
        this.removeFromListProperty(MdmXMLTags.HIERARCHY_LEVELS, mdmHierarchyLevel);
    }

    public MdmLevel createNumericLevel(String string, MtmValueExpression mtmValueExpression, int n) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createNumericLevel(string, this, mtmValueExpression, n);
    }

    public MdmLevel createNumericLevel(String string, String string2, int n) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createNumericLevel(string, this, string2, n);
    }

    public MdmLevel createNumericLevel(String string, MtmValueExpression mtmValueExpression, MdmLevel mdmLevel) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createNumericLevel(string, this, mtmValueExpression, mdmLevel);
    }

    public MdmLevel createNumericLevel(String string, String string2, MdmLevel mdmLevel) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createNumericLevel(string, this, string2, mdmLevel);
    }

    public MdmLevel createStringLevel(String string, MtmValueExpression mtmValueExpression, int n) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createStringLevel(string, this, mtmValueExpression, n);
    }

    public MdmLevel createStringLevel(String string, String string2, int n) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createStringLevel(string, this, string2, n);
    }

    public MdmLevel createStringLevel(String string, MtmValueExpression mtmValueExpression, MdmLevel mdmLevel) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createStringLevel(string, this, mtmValueExpression, mdmLevel);
    }

    public MdmLevel createStringLevel(String string, String string2, MdmLevel mdmLevel) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createStringLevel(string, this, string2, mdmLevel);
    }

    public MdmLevel createDateLevel(String string, MtmValueExpression mtmValueExpression, int n) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createDateLevel(string, this, mtmValueExpression, n);
    }

    public MdmLevel createDateLevel(String string, String string2, int n) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createDateLevel(string, this, string2, n);
    }

    public MdmLevel createDateLevel(String string, MtmValueExpression mtmValueExpression, MdmLevel mdmLevel) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createDateLevel(string, this, mtmValueExpression, mdmLevel);
    }

    public MdmLevel createDateLevel(String string, String string2, MdmLevel mdmLevel) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createDateLevel(string, this, string2, mdmLevel);
    }

    public MdmLevel createBooleanLevel(String string, MtmValueExpression mtmValueExpression, int n) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createBooleanLevel(string, this, mtmValueExpression, n);
    }

    public MdmLevel createBooleanLevel(String string, String string2, int n) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createBooleanLevel(string, this, string2, n);
    }

    public MdmLevel createBooleanLevel(String string, MtmValueExpression mtmValueExpression, MdmLevel mdmLevel) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createBooleanLevel(string, this, mtmValueExpression, mdmLevel);
    }

    public MdmLevel createBooleanLevel(String string, String string2, MdmLevel mdmLevel) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createBooleanLevel(string, this, string2, mdmLevel);
    }

    public final SolvedLevelHierarchyMap getSolvedHierarchyMap() {
        return (SolvedLevelHierarchyMap)this.getPropertyObjectValue(MdmXMLTags.SOLVED_LEVEL_HIERARCHY_MAP);
    }

    public final void setSolvedHierarchyMap(SolvedLevelHierarchyMap solvedLevelHierarchyMap) {
        this.setPropertyObjectValue(MdmXMLTags.SOLVED_LEVEL_HIERARCHY_MAP, solvedLevelHierarchyMap);
    }

    public final boolean isSkipLevel() {
        return this.getPropertyBooleanValue(MdmXMLTags.IS_SKIP_LEVEL);
    }

    public final void setIsSkipLevel(boolean bl) {
        this.setPropertyBooleanValue(MdmXMLTags.IS_SKIP_LEVEL, bl);
    }

    public final boolean isRagged() {
        return this.getPropertyBooleanValue(MdmXMLTags.IS_RAGGED);
    }

    public final void setIsRagged(boolean bl) {
        this.setPropertyBooleanValue(MdmXMLTags.IS_RAGGED, bl);
    }

    @Override
    public final List<MdmQueryColumn> getQueryColumns() {
        List<MdmQueryColumn> list = super.getQueryColumns();
        List list2 = this.getLevels();
        for (MdmHierarchyLevel mdmHierarchyLevel : list2) {
            MdmDimensionLevel mdmDimensionLevel = mdmHierarchyLevel.getDimensionLevel();
            if (null == mdmDimensionLevel) continue;
            mdmDimensionLevel.populateQueryColumns(list);
        }
        return list;
    }

    @Override
    public MdmQueryColumn getQueryColumn(String string) {
        if (null == string) {
            return null;
        }
        MdmQueryColumn mdmQueryColumn = super.getQueryColumn(string);
        if (null != mdmQueryColumn) {
            return mdmQueryColumn;
        }
        List list = this.getLevels();
        for (MdmHierarchyLevel mdmHierarchyLevel : list) {
            MdmDimensionLevel mdmDimensionLevel = mdmHierarchyLevel.getDimensionLevel();
            if (null == mdmDimensionLevel || null == (mdmQueryColumn = mdmDimensionLevel.getQueryColumn(string))) continue;
            return mdmQueryColumn;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdmHierarchyLevel findOrCreateHierarchyLevel(MdmDimensionLevel mdmDimensionLevel) {
        MdmHierarchyLevel mdmHierarchyLevel = null;
        String string = MdmLevelHierarchy.generateID(new String[]{this.getInternalID(), mdmDimensionLevel.getName()});
        MetadataObject metadataObject = this.getMetadataProvider().fetchMetadataObject(string);
        if (null == metadataObject) {
            MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
            synchronized (mdmMetadataProvider) {
                metadataObject = this.getMetadataProvider().fetchMetadataObject(string);
                if (null == metadataObject) {
                    MdmLevel mdmLevel = new MdmLevel(string, 0, this);
                    mdmLevel.setDimensionLevel(mdmDimensionLevel);
                    this.addHierarchyLevel(mdmLevel);
                    return mdmLevel;
                }
            }
        }
        if (metadataObject instanceof MdmHierarchyLevel) {
            mdmHierarchyLevel = (MdmHierarchyLevel)metadataObject;
            this.addHierarchyLevel(mdmHierarchyLevel);
        } else if (null != metadataObject) {
            throw new DuplicateMetadataIDException(metadataObject.getID());
        }
        return mdmHierarchyLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolvedLevelHierarchyMap findOrCreateSolvedLevelHierarchyMap() {
        SolvedLevelHierarchyMap solvedLevelHierarchyMap = null;
        String string = MdmLevelHierarchy.generateID(new String[]{this.getInternalID(), "MAP"});
        MetadataObject metadataObject = this.getMetadataProvider().fetchMetadataObject(string);
        if (null == metadataObject) {
            MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
            synchronized (mdmMetadataProvider) {
                metadataObject = this.getMetadataProvider().fetchMetadataObject(string);
                if (null == metadataObject) {
                    solvedLevelHierarchyMap = new SolvedLevelHierarchyMap(string, 0, this);
                    this.setSolvedHierarchyMap(solvedLevelHierarchyMap);
                    return solvedLevelHierarchyMap;
                }
            }
        }
        if (metadataObject instanceof SolvedLevelHierarchyMap) {
            solvedLevelHierarchyMap = (SolvedLevelHierarchyMap)metadataObject;
            this.setSolvedHierarchyMap(solvedLevelHierarchyMap);
        } else if (null != metadataObject) {
            throw new DuplicateMetadataIDException(metadataObject.getID());
        }
        return solvedLevelHierarchyMap;
    }
}

