/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.idl.util;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.express.idl.util.OlapiTracer;
import oracle.express.idl.util.RpcProperties;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.sql.NUMBER;

public class InterfaceStub {
    protected static Map currentStmtMap = new HashMap();
    private OracleConnection _olapiConnection;
    private NUMBER _remoteObjectPointer;
    private String _realInterfaceName;
    private String _vsnnum;
    private RpcProperties _rpcProps;
    private Locale _locale;

    public InterfaceStub(OracleConnection oracleConnection, String string, NUMBER nUMBER, String string2, RpcProperties rpcProperties, Locale locale) {
        OlapiTracer.enter("InterfaceStub.constructor");
        this._olapiConnection = oracleConnection;
        this._vsnnum = string;
        this._remoteObjectPointer = nUMBER;
        this._realInterfaceName = string2;
        this._rpcProps = rpcProperties;
        this._locale = locale;
        OlapiTracer.log("server version = " + this._vsnnum);
        OlapiTracer.log("client version = 12.1.0.0.0");
        OlapiTracer.log("interface name = " + this._realInterfaceName);
        OlapiTracer.leave("InterfaceStub.constructor");
    }

    public OracleConnection getOlapiConnection() {
        return this._olapiConnection;
    }

    public String getServerVsnnum() {
        return this._vsnnum;
    }

    public NUMBER getRemoteObjectPointer() {
        return this._remoteObjectPointer;
    }

    public String getRealInterfaceName() {
        return this._realInterfaceName;
    }

    public String getPlsqlPackageName() {
        if (null == this._realInterfaceName || this._realInterfaceName.equals("")) {
            return "";
        }
        int n = this._realInterfaceName.indexOf("::");
        String string = this._realInterfaceName.substring(0, n);
        String string2 = this._realInterfaceName.substring(n + 2);
        return "Gen" + string2;
    }

    public RpcProperties getRpcProperties() {
        return this._rpcProps;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public OracleCallableStatement prepareCall(String string, String string2) {
        try {
            String string3 = this.getPlsqlPackageName();
            if (null == string3 || string3.equals("")) {
                string3 = "";
            } else if (this._vsnnum.equals("ORAOLAP9.2.0.1.0")) {
                string3 = string3.substring(3);
            }
            String string4 = string + string3 + string2;
            return (OracleCallableStatement)this._olapiConnection.prepareCall(string4);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void interruptCurrentStmtExecution() throws SQLException {
        OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)currentStmtMap.get(this._olapiConnection);
        if (null != oracleCallableStatement) {
            oracleCallableStatement.cancel();
            oracleCallableStatement = null;
            currentStmtMap.remove(this._olapiConnection);
        }
    }

    public boolean isPostServerVsnnum(String string) {
        return this.isPostServerVsnnum((short)0, string);
    }

    public boolean isPostServerVsnnum(short s, String string) {
        String string2;
        String string3;
        String string4 = string;
        if (-1 != string4.indexOf("ORAOLAP")) {
            string4 = string4.substring(7);
        }
        if (-1 != (string3 = this._vsnnum).indexOf("ORAOLAP")) {
            string3 = string3.substring(7);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ".");
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            string2 = stringTokenizer.nextToken();
            String string5 = stringTokenizer2.nextToken();
            if (Integer.parseInt(string2) == Integer.parseInt(string5)) continue;
            return false;
        }
        while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens()) {
            String string6 = stringTokenizer.nextToken();
            string2 = stringTokenizer2.nextToken();
            if (Integer.parseInt(string6) > Integer.parseInt(string2)) {
                return false;
            }
            if (Integer.parseInt(string6) >= Integer.parseInt(string2)) continue;
            return true;
        }
        return true;
    }
}

