/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Null;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.CBCAlgorithmIdentifier;
import oracle.security.crypto.core.DESKey;
import oracle.security.crypto.core.DHParams;
import oracle.security.crypto.core.DHPublicKey;
import oracle.security.crypto.core.DSA;
import oracle.security.crypto.core.DSAParams;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.KeyPair;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SHA;
import oracle.security.crypto.core.Signature;
import oracle.security.crypto.core.SignatureException;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.OIDManager;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public class CryptoUtils {
    public static oracle.security.crypto.core.PublicKey inputSPKI(byte[] byArray) throws IOException {
        return CryptoUtils.inputSPKI(new UnsyncByteArrayInputStream(byArray));
    }

    public static oracle.security.crypto.core.PublicKey inputSPKI(InputStream inputStream) throws IOException {
        oracle.security.crypto.core.PublicKey publicKey;
        FIPS_140_2.assertReadyState();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(aSN1SequenceInputStream);
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "publicKey");
        if (clazz == null) {
            throw new IOException("Unrecognized algorithm identifier.");
        }
        try {
            publicKey = (oracle.security.crypto.core.PublicKey)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Class does not implement PublicKey.");
        }
        ASN1Object aSN1Object = ASN1Utils.inputASN1Object(new UnsyncByteArrayInputStream(ASN1BitString.inputValue(aSN1SequenceInputStream)));
        try {
            publicKey.initialize(algorithmIdentifier, aSN1Object);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IOException(algorithmIdentifierException.toString());
        }
        return publicKey;
    }

    public static oracle.security.crypto.core.PublicKey inputSPKI(ASN1Sequence aSN1Sequence) throws IOException {
        return CryptoUtils.inputSPKI(new UnsyncByteArrayInputStream(Utils.toBytes(aSN1Sequence)));
    }

    public static oracle.security.crypto.core.PrivateKey inputPrivateKey(File file) throws IOException {
        return CryptoUtils.inputPrivateKey(new FileInputStream(file));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static oracle.security.crypto.core.PrivateKey inputPrivateKey(InputStream inputStream) throws IOException {
        oracle.security.crypto.core.PrivateKey privateKey;
        FIPS_140_2.assertReadyState();
        ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
        Object object = null;
        try {
            Object object2;
            ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.elementAt(0);
            if (!aSN1Integer.equals(0)) {
                throw new VersionException(aSN1Integer.getValue(), 0);
            }
            AlgorithmIdentifier algorithmIdentifier = null;
            if (aSN1Sequence.size() == 9) {
                algorithmIdentifier = AlgID.rsaEncryption;
                object = aSN1Sequence;
            } else if (aSN1Sequence.size() == 5) {
                algorithmIdentifier = AlgID.dsaWithSHA1;
                object = aSN1Sequence;
            } else {
                algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(1));
                object2 = aSN1Sequence.elementAt(2);
                if (object2 instanceof ASN1OctetString) {
                    object = ASN1Utils.inputASN1Object(new UnsyncByteArrayInputStream(((ASN1OctetString)object2).getValue()));
                } else {
                    if (!(object2 instanceof ASN1Sequence)) throw new IOException("Invalid private key contents");
                    object = object2;
                }
            }
            object2 = OIDManager.getOIDManager();
            Class clazz = ((OIDManager)object2).getMapping(algorithmIdentifier.getOID(), "privateKey");
            if (clazz == null) {
                throw new IOException("Unrecognized algorithm identifier");
            }
            try {
                oracle.security.crypto.core.PrivateKey privateKey2 = (oracle.security.crypto.core.PrivateKey)clazz.newInstance();
                privateKey2.initialize(algorithmIdentifier, (ASN1Object)object);
                privateKey = privateKey2;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
            }
            catch (InstantiationException instantiationException) {
                throw new IOException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
            }
            catch (ClassCastException classCastException) {
                throw new IOException("Class does not implement PrivateKey");
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IOException(algorithmIdentifierException.toString());
            }
            Object var10_13 = null;
            if (aSN1Sequence.size() == 9) {
                ((ASN1Integer)aSN1Sequence.elementAt(3)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(4)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(5)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(6)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(7)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(8)).erase();
                return privateKey;
            }
            if (aSN1Sequence.size() == 5) {
                ((ASN1Integer)aSN1Sequence.elementAt(3)).erase();
                return privateKey;
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (aSN1Sequence.size() == 9) {
                ((ASN1Integer)aSN1Sequence.elementAt(3)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(4)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(5)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(6)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(7)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(8)).erase();
                throw throwable;
            }
            if (aSN1Sequence.size() == 5) {
                ((ASN1Integer)aSN1Sequence.elementAt(3)).erase();
                throw throwable;
            }
            if (aSN1Sequence.elementAt(2) instanceof ASN1OctetString) {
                Utils.setArray(((ASN1OctetString)aSN1Sequence.elementAt(2)).getValue(), (byte)0);
            }
            if (object == null) throw throwable;
            if (!(object instanceof ASN1Sequence)) {
                if (!(object instanceof ASN1Integer)) throw throwable;
                ((ASN1Integer)object).erase();
                throw throwable;
            }
            Object object3 = object;
            if (((ASN1Sequence)object3).size() == 9) {
                ((ASN1Integer)((ASN1Sequence)object3).elementAt(3)).erase();
                ((ASN1Integer)((ASN1Sequence)object3).elementAt(4)).erase();
                ((ASN1Integer)((ASN1Sequence)object3).elementAt(5)).erase();
                ((ASN1Integer)((ASN1Sequence)object3).elementAt(6)).erase();
                ((ASN1Integer)((ASN1Sequence)object3).elementAt(7)).erase();
                ((ASN1Integer)((ASN1Sequence)object3).elementAt(8)).erase();
                throw throwable;
            }
            if (((ASN1Sequence)object3).size() != 5) throw throwable;
            ((ASN1Integer)((ASN1Sequence)object3).elementAt(3)).erase();
            throw throwable;
        }
        if (aSN1Sequence.elementAt(2) instanceof ASN1OctetString) {
            Utils.setArray(((ASN1OctetString)aSN1Sequence.elementAt(2)).getValue(), (byte)0);
        }
        if (object == null) return privateKey;
        if (object instanceof ASN1Sequence) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)object;
            if (aSN1Sequence2.size() == 9) {
                ((ASN1Integer)aSN1Sequence2.elementAt(3)).erase();
                ((ASN1Integer)aSN1Sequence2.elementAt(4)).erase();
                ((ASN1Integer)aSN1Sequence2.elementAt(5)).erase();
                ((ASN1Integer)aSN1Sequence2.elementAt(6)).erase();
                ((ASN1Integer)aSN1Sequence2.elementAt(7)).erase();
                ((ASN1Integer)aSN1Sequence2.elementAt(8)).erase();
                return privateKey;
            }
            if (aSN1Sequence2.size() != 5) return privateKey;
            ((ASN1Integer)aSN1Sequence2.elementAt(3)).erase();
            return privateKey;
        }
        if (!(object instanceof ASN1Integer)) return privateKey;
        ((ASN1Integer)object).erase();
        return privateKey;
    }

    public static KeyPair inputKeyPair(InputStream inputStream) throws IOException {
        FIPS_140_2.assertReadyState();
        ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
        if (aSN1Sequence.size() == 9) {
            oracle.security.crypto.core.RSAPrivateKey rSAPrivateKey = new oracle.security.crypto.core.RSAPrivateKey();
            try {
                rSAPrivateKey.initialize(AlgID.rsaEncryption, aSN1Sequence);
                ((ASN1Integer)aSN1Sequence.elementAt(3)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(4)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(5)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(6)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(7)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(8)).erase();
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IOException(algorithmIdentifierException.toString());
            }
            return new KeyPair(rSAPrivateKey.getPublicKey(), rSAPrivateKey);
        }
        if (aSN1Sequence.size() == 6) {
            if (((ASN1Integer)aSN1Sequence.elementAt(0)).getValue().intValue() != 0) {
                throw new ASN1FormatException("Invalid key pair format");
            }
            DSAParams dSAParams = new DSAParams(((ASN1Integer)aSN1Sequence.elementAt(1)).getValue(), ((ASN1Integer)aSN1Sequence.elementAt(2)).getValue(), ((ASN1Integer)aSN1Sequence.elementAt(3)).getValue());
            oracle.security.crypto.core.DSAPublicKey dSAPublicKey = new oracle.security.crypto.core.DSAPublicKey(((ASN1Integer)aSN1Sequence.elementAt(4)).getValue(), dSAParams);
            oracle.security.crypto.core.DSAPrivateKey dSAPrivateKey = new oracle.security.crypto.core.DSAPrivateKey(((ASN1Integer)aSN1Sequence.elementAt(5)).getValue(), dSAParams);
            ((ASN1Integer)aSN1Sequence.elementAt(5)).erase();
            return new KeyPair(dSAPublicKey, dSAPrivateKey);
        }
        throw new ASN1FormatException("Unknown key pair format");
    }

    public static byte[] generateKeyID(oracle.security.crypto.core.PublicKey publicKey) {
        FIPS_140_2.assertReadyState();
        SHA sHA = new SHA();
        sHA.update(Utils.toBytes(publicKey.getContents()));
        sHA.computeCurrent();
        return sHA.getDigestBits();
    }

    public static void setKeyParity(SymmetricKey symmetricKey, int n) {
        DESKey.setParity(symmetricKey, n);
    }

    public static boolean checkKeyParity(SymmetricKey symmetricKey, int n) {
        return DESKey.checkParity(symmetricKey, n);
    }

    public static boolean isDesWeakKey(SymmetricKey symmetricKey) {
        return DESKey.isWeak(symmetricKey);
    }

    public static boolean isDesSemiWeakKey(SymmetricKey symmetricKey) {
        return DESKey.isSemiWeak(symmetricKey);
    }

    public static boolean isDesPossiblyWeakKey(SymmetricKey symmetricKey) {
        return DESKey.isPossiblyWeak(symmetricKey);
    }

    public static ASN1Sequence subjectPublicKeyInfo(oracle.security.crypto.core.PublicKey publicKey) {
        FIPS_140_2.assertReadyState();
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(publicKey.getAlgID());
        aSN1Sequence.addElement(new ASN1BitString(Utils.toBytes(publicKey.getContents())));
        return aSN1Sequence;
    }

    public static ASN1Sequence privateKeyInfo(oracle.security.crypto.core.PrivateKey privateKey) {
        byte[] byArray = privateKey.getEncoded();
        try {
            return new ASN1Sequence(new UnsyncByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            throw new StreamableInputException(iOException.toString());
        }
    }

    public static ASN1Sequence makeAlgID(ASN1ObjectID aSN1ObjectID) {
        FIPS_140_2.assertReadyState();
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(aSN1ObjectID);
        if (!aSN1ObjectID.equals(DSA.dsaSigOID)) {
            aSN1Sequence.addElement(new ASN1Null());
        }
        return aSN1Sequence;
    }

    public static Signature makeSignature(oracle.security.crypto.core.PrivateKey privateKey) throws SignatureException {
        Signature signature;
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(privateKey.getAlgID().getOID(), "useSignature");
        if (clazz == null) {
            throw new SignatureException("Can not find a signature algorithm for this key.");
        }
        try {
            signature = (Signature)clazz.newInstance();
            signature.setPrivateKey(privateKey);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SignatureException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new SignatureException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new SignatureException(classCastException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException.toString());
        }
        return signature;
    }

    public static Signature makeSignature(oracle.security.crypto.core.PublicKey publicKey) throws AuthenticationException {
        Signature signature;
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(publicKey.getAlgID().getOID(), "useSignature");
        if (clazz == null) {
            throw new AuthenticationException("Can not find a signature algorithm for this key.");
        }
        try {
            signature = (Signature)clazz.newInstance();
            signature.setPublicKey(publicKey);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AuthenticationException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AuthenticationException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AuthenticationException(classCastException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthenticationException(invalidKeyException.toString());
        }
        return signature;
    }

    public static byte[] sign(byte[] byArray, oracle.security.crypto.core.PrivateKey privateKey) throws SignatureException {
        return CryptoUtils.sign(byArray, privateKey, RandomBitsSource.getDefault());
    }

    public static byte[] sign(byte[] byArray, oracle.security.crypto.core.PrivateKey privateKey, RandomBitsSource randomBitsSource) throws SignatureException {
        FIPS_140_2.assertReadyState();
        Signature signature = Signature.getInstance(privateKey);
        signature.setDocument(byArray);
        signature.setRandomBitsSource(randomBitsSource);
        signature.sign();
        return signature.getSigBytes();
    }

    public static ASN1Sequence signASN1(ASN1Object aSN1Object, oracle.security.crypto.core.PrivateKey privateKey) throws SignatureException {
        return CryptoUtils.signASN1(aSN1Object, privateKey, RandomBitsSource.getDefault());
    }

    public static ASN1Sequence signASN1(ASN1Object aSN1Object, oracle.security.crypto.core.PrivateKey privateKey, RandomBitsSource randomBitsSource) throws SignatureException {
        FIPS_140_2.assertReadyState();
        Signature signature = Signature.getInstance(privateKey);
        signature.setDocument(Utils.toBytes(aSN1Object));
        signature.setRandomBitsSource(randomBitsSource);
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(aSN1Object);
        aSN1Sequence.addElement(signature.getAlgID());
        aSN1Sequence.addElement(new ASN1BitString(signature.sign()));
        return aSN1Sequence;
    }

    public static boolean verifySignature(oracle.security.crypto.core.PublicKey publicKey, byte[] byArray, byte[] byArray2) throws AuthenticationException {
        FIPS_140_2.assertReadyState();
        Signature signature = Signature.getInstance(publicKey);
        signature.setDocument(byArray);
        signature.setSigBytes(byArray2);
        return signature.verify();
    }

    public static boolean verifySignedASN1(ASN1Sequence aSN1Sequence, oracle.security.crypto.core.PublicKey publicKey) {
        FIPS_140_2.assertReadyState();
        try {
            byte[] byArray = Utils.toBytes(aSN1Sequence.elementAt(0));
            byte[] byArray2 = ((ASN1BitString)aSN1Sequence.elementAt(2)).getValue();
            Signature signature = Signature.getInstance(new AlgorithmIdentifier(Utils.toStream(aSN1Sequence.elementAt(1))));
            signature.setPublicKey(publicKey);
            signature.setDocument(byArray);
            signature.setSigBytes(byArray2);
            return signature.verify();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            return false;
        }
        catch (AuthenticationException authenticationException) {
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static byte[] getIV(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        if (algorithmIdentifier instanceof CBCAlgorithmIdentifier) {
            return ((CBCAlgorithmIdentifier)algorithmIdentifier).getIV();
        }
        CBCAlgorithmIdentifier cBCAlgorithmIdentifier = new CBCAlgorithmIdentifier(algorithmIdentifier.getOID(), algorithmIdentifier.getParameters());
        return cBCAlgorithmIdentifier.getIV();
    }

    public static PrivateKey toJCEPrivateKey(oracle.security.crypto.core.PrivateKey privateKey) {
        try {
            if (privateKey instanceof oracle.security.crypto.core.RSAPrivateKey && ((oracle.security.crypto.core.RSAPrivateKey)privateKey).getPrimeP() != null) {
                oracle.security.crypto.core.RSAPrivateKey rSAPrivateKey = (oracle.security.crypto.core.RSAPrivateKey)privateKey;
                RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPublicExponent(), rSAPrivateKey.getExponent(), rSAPrivateKey.getPrimeP(), rSAPrivateKey.getPrimeQ(), rSAPrivateKey.getPrimeExponentP(), rSAPrivateKey.getPrimeExponentQ(), rSAPrivateKey.getCrtCoefficient());
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                return keyFactory.generatePrivate(rSAPrivateCrtKeySpec);
            }
            if (privateKey instanceof oracle.security.crypto.core.RSAPrivateKey) {
                oracle.security.crypto.core.RSAPrivateKey rSAPrivateKey = (oracle.security.crypto.core.RSAPrivateKey)privateKey;
                RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getExponent());
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                return keyFactory.generatePrivate(rSAPrivateKeySpec);
            }
            if (privateKey instanceof oracle.security.crypto.core.DSAPrivateKey) {
                oracle.security.crypto.core.DSAPrivateKey dSAPrivateKey = (oracle.security.crypto.core.DSAPrivateKey)privateKey;
                DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(dSAPrivateKey.getX(), dSAPrivateKey.getParams().getP(), dSAPrivateKey.getParams().getQ(), dSAPrivateKey.getParams().getG());
                KeyFactory keyFactory = KeyFactory.getInstance("DSA");
                return keyFactory.generatePrivate(dSAPrivateKeySpec);
            }
            if (privateKey instanceof oracle.security.crypto.core.DHPrivateKey) {
                oracle.security.crypto.core.DHPrivateKey dHPrivateKey = (oracle.security.crypto.core.DHPrivateKey)privateKey;
                DHPrivateKeySpec dHPrivateKeySpec = new DHPrivateKeySpec(dHPrivateKey.getX(), dHPrivateKey.getParams().getP(), dHPrivateKey.getParams().getG());
                KeyFactory keyFactory = KeyFactory.getInstance("DiffieHellman");
                return keyFactory.generatePrivate(dHPrivateKeySpec);
            }
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new IllegalArgumentException(invalidKeySpecException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException(noSuchAlgorithmException);
        }
        throw new IllegalArgumentException("PrivateKey must be one of RSAPrivateKey, DSAPrivateKey or DHPrivateKey");
    }

    public static oracle.security.crypto.core.PrivateKey fromJCEPrivateKey(PrivateKey privateKey) {
        if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
            oracle.security.crypto.core.RSAPrivateKey rSAPrivateKey = new oracle.security.crypto.core.RSAPrivateKey(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
            return rSAPrivateKey;
        }
        if (privateKey instanceof RSAPrivateKey) {
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)privateKey;
            oracle.security.crypto.core.RSAPrivateKey rSAPrivateKey2 = new oracle.security.crypto.core.RSAPrivateKey(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
            return rSAPrivateKey2;
        }
        if (privateKey instanceof DSAPrivateKey) {
            DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
            oracle.security.crypto.core.DSAPrivateKey dSAPrivateKey2 = new oracle.security.crypto.core.DSAPrivateKey(dSAPrivateKey.getX(), new DSAParams(dSAPrivateKey.getParams().getP(), dSAPrivateKey.getParams().getQ(), dSAPrivateKey.getParams().getG()));
            return dSAPrivateKey2;
        }
        if (privateKey instanceof DHPrivateKey) {
            DHPrivateKey dHPrivateKey = (DHPrivateKey)privateKey;
            oracle.security.crypto.core.DHPrivateKey dHPrivateKey2 = new oracle.security.crypto.core.DHPrivateKey(dHPrivateKey.getX(), new DHParams(dHPrivateKey.getParams().getP(), dHPrivateKey.getParams().getG(), dHPrivateKey.getParams().getP().subtract(new BigInteger("1")).divide(new BigInteger("2"))));
            return dHPrivateKey2;
        }
        throw new IllegalArgumentException("PrivateKey must be one of RSAPrivateKey, DSAPrivateKey or DHPrivateKey");
    }

    public static PublicKey toJCEPublicKey(oracle.security.crypto.core.PublicKey publicKey) {
        try {
            if (publicKey instanceof RSAPublicKey) {
                RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
                RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getExponent());
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                return keyFactory.generatePublic(rSAPublicKeySpec);
            }
            if (publicKey instanceof oracle.security.crypto.core.DSAPublicKey) {
                oracle.security.crypto.core.DSAPublicKey dSAPublicKey = (oracle.security.crypto.core.DSAPublicKey)publicKey;
                DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(dSAPublicKey.getY(), dSAPublicKey.getParams().getP(), dSAPublicKey.getParams().getQ(), dSAPublicKey.getParams().getG());
                KeyFactory keyFactory = KeyFactory.getInstance("DSA");
                return keyFactory.generatePublic(dSAPublicKeySpec);
            }
            if (publicKey instanceof DHPublicKey) {
                DHPublicKey dHPublicKey = (DHPublicKey)publicKey;
                DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(dHPublicKey.getY(), dHPublicKey.getParams().getP(), dHPublicKey.getParams().getG());
                KeyFactory keyFactory = KeyFactory.getInstance("DiffieHellman");
                return keyFactory.generatePublic(dHPublicKeySpec);
            }
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new IllegalArgumentException(invalidKeySpecException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException(noSuchAlgorithmException);
        }
        throw new IllegalArgumentException("PublicKey must be one of RSAPublicKey, DSAPublicKey or DHPublicKey");
    }

    public static oracle.security.crypto.core.PublicKey fromJCEPublicKey(PublicKey publicKey) {
        if (publicKey instanceof java.security.interfaces.RSAPublicKey) {
            java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)publicKey;
            RSAPublicKey rSAPublicKey2 = new RSAPublicKey(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            return rSAPublicKey2;
        }
        if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
            oracle.security.crypto.core.DSAPublicKey dSAPublicKey2 = new oracle.security.crypto.core.DSAPublicKey(dSAPublicKey.getY(), new DSAParams(dSAPublicKey.getParams().getP(), dSAPublicKey.getParams().getQ(), dSAPublicKey.getParams().getG()));
            return dSAPublicKey2;
        }
        if (publicKey instanceof javax.crypto.interfaces.DHPublicKey) {
            javax.crypto.interfaces.DHPublicKey dHPublicKey = (javax.crypto.interfaces.DHPublicKey)publicKey;
            DHPublicKey dHPublicKey2 = new DHPublicKey(dHPublicKey.getY(), new DHParams(dHPublicKey.getParams().getP(), dHPublicKey.getParams().getG(), dHPublicKey.getParams().getP().subtract(new BigInteger("1")).divide(new BigInteger("2"))));
            return dHPublicKey2;
        }
        throw new IllegalArgumentException("PublicKey must be one of RSAPublicKey, DSAPublicKey or DHPublicKey");
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

