/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.format.ReportFormatOptions;
import oracle.ide.net.URLPath;
import oracle.javatools.util.PlatformUtils;

public class PDFFormatOptions
extends ReportFormatOptions {
    public static final String DEFAULT_FONT_DIRECTORY_LINUX = "/usr/share/X11/fonts" + File.pathSeparator + "/usr/share/fonts";
    public static final String DEFAULT_FONT_DIRECTORY_WINDOWS = "c:/windows/fonts";
    public static final String DEFAULT_FONT_DIRECTORY_WINNT = "c:/winnt/fonts";
    public static final String DEFAULT_FONT_DIRECTORY_MAC = "/Library/Fonts" + File.pathSeparator + "/System/Library/Fonts";
    public static final int MAX_HEADER_FOOTER_HEIGHT = 216;
    private String _author = "";
    private String _keywords = "";
    private String _subject = "";
    private String _title = "";
    private PDF_COMPATIBILITY _supportedVersion = PDF_COMPATIBILITY.VERSION_1_7;
    private COMPRESSION_LEVEL _compressionLevel = COMPRESSION_LEVEL.CONTENT;
    private BLOB_ACTION _blobAction = BLOB_ACTION.NONE;
    private String _openPassword = null;
    private String _permissionPassword = null;
    private boolean _securityAllowed = false;
    private boolean _openPasswordRequired = false;
    private boolean _permissionsAllowed = false;
    private boolean _printingAllowed = true;
    private boolean _copyingAllowed = true;
    private boolean _updatingAllowed = false;
    private boolean _accessibleDevicesCopyingAllowed = false;
    private String _fontLocations = null;
    private String _externalLibrary = null;
    private ENCRYPTION_LEVEL _encryptionLevel = ENCRYPTION_LEVEL.ENTIRE_CONTENT;
    private boolean _embedFonts = false;

    public void setAuthor(String string) {
        this._author = string;
    }

    public String getAuthor() {
        return this._author;
    }

    public void setKeywords(String string) {
        this._keywords = string;
    }

    public String getKeywords() {
        return this._keywords;
    }

    public void setSubject(String string) {
        this._subject = string;
    }

    public String getSubject() {
        return this._subject;
    }

    public void setTitle(String string) {
        this._title = string;
    }

    public String getTitle() {
        return this._title;
    }

    public void setSupportedVersion(PDF_COMPATIBILITY pDF_COMPATIBILITY) {
        this._supportedVersion = pDF_COMPATIBILITY;
    }

    public PDF_COMPATIBILITY getSupportedVersion() {
        return this._supportedVersion;
    }

    public void setCompressionLevel(COMPRESSION_LEVEL cOMPRESSION_LEVEL) {
        this._compressionLevel = cOMPRESSION_LEVEL;
    }

    public COMPRESSION_LEVEL getCompressionLevel() {
        return this._compressionLevel;
    }

    public void setBlobAction(BLOB_ACTION bLOB_ACTION) {
        this._blobAction = bLOB_ACTION;
    }

    public BLOB_ACTION getBlobAction() {
        return this._blobAction;
    }

    public void setOpenPassword(String string) {
        this._openPassword = string;
    }

    public String getOpenPassword() {
        return this._openPassword;
    }

    public void setPermissionPassword(String string) {
        this._permissionPassword = string;
    }

    public String getPermissionPassword() {
        return this._permissionPassword;
    }

    public void setSecurityAllowed(boolean bl) {
        this._securityAllowed = bl;
    }

    public boolean isSecurityAllowed() {
        return this._securityAllowed;
    }

    public void setOpenPasswordRequired(boolean bl) {
        this._openPasswordRequired = bl;
    }

    public boolean isOpenPasswordRequired() {
        return this._openPasswordRequired;
    }

    public void setPermissionsAllowed(boolean bl) {
        this._permissionsAllowed = bl;
    }

    public boolean isPermissionsAllowed() {
        return this._permissionsAllowed;
    }

    public void setPrintingAllowed(boolean bl) {
        this._printingAllowed = bl;
    }

    public boolean isPrintingAllowed() {
        return this._printingAllowed;
    }

    public void setCopyingAllowed(boolean bl) {
        this._copyingAllowed = bl;
    }

    public boolean isCopyingAllowed() {
        return this._copyingAllowed;
    }

    public void setUpdatingAllowed(boolean bl) {
        this._updatingAllowed = bl;
    }

    public boolean isUpdatingAllowed() {
        return this._updatingAllowed;
    }

    public void setAccessibleDevicesCopyingAllowed(boolean bl) {
        this._accessibleDevicesCopyingAllowed = bl;
    }

    public boolean isAccessibleDevicesCopyingAllowed() {
        return this._accessibleDevicesCopyingAllowed;
    }

    public void setEncryptionLevel(ENCRYPTION_LEVEL eNCRYPTION_LEVEL) {
        this._encryptionLevel = eNCRYPTION_LEVEL;
    }

    public ENCRYPTION_LEVEL getEncryptionLevel() {
        return this._encryptionLevel;
    }

    public void setFontLocations(String string) {
        this._fontLocations = string;
    }

    public String getFontLocations() {
        return this._fontLocations;
    }

    public static ArrayList<String> getDefaultFontLocations() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        if (PlatformUtils.isWindowsNT()) {
            string = DEFAULT_FONT_DIRECTORY_WINNT;
        } else if (PlatformUtils.isWindows()) {
            string = DEFAULT_FONT_DIRECTORY_WINDOWS;
        } else if (PlatformUtils.isLinux()) {
            string = DEFAULT_FONT_DIRECTORY_LINUX;
        } else if (PlatformUtils.isMac()) {
            string = DEFAULT_FONT_DIRECTORY_MAC;
        }
        if (string != null) {
            for (String string2 : string.split(File.pathSeparator)) {
                File file = new File(string2);
                if (!file.isDirectory()) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    public ArrayList<String> getFontDirectories() {
        return PDFFormatOptions.getFontDirectories(this.getFontLocations());
    }

    public static ArrayList<String> getFontDirectories(String string) {
        ArrayList<String> arrayList = new ArrayList();
        if (string == null || string.isEmpty()) {
            arrayList = PDFFormatOptions.getDefaultFontLocations();
        } else {
            URLPath uRLPath = URLPath.newURLPathFromString((String)string);
            if (uRLPath != null) {
                List list = uRLPath.asList();
                for (URL uRL : list) {
                    arrayList.add(uRL.getPath());
                }
            }
            if (arrayList.isEmpty()) {
                arrayList = PDFFormatOptions.getDefaultFontLocations();
            }
        }
        return arrayList;
    }

    public void setExternalLibrary(String string) {
        this._externalLibrary = string;
    }

    public String getExternalLibrary() {
        return this._externalLibrary;
    }

    public void setEmbedFonts(boolean bl) {
        this._embedFonts = bl;
    }

    public boolean isEmbedFonts() {
        return this._embedFonts;
    }

    public static enum ENCRYPTION_LEVEL {
        ENTIRE_CONTENT,
        EXCLUDE_METADATA;

    }

    public static enum BLOB_ACTION {
        EMBED,
        LINK,
        NONE;

    }

    public static enum COMPRESSION_LEVEL {
        NONE,
        CONTENT,
        ENTIRE_FILE;

    }

    public static enum PDF_COMPATIBILITY {
        VERSION_1_5,
        VERSION_1_6,
        VERSION_1_7;

    }
}

