/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid.contextmenu;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.grid.AbstractRaptorGridModel;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.controls.grid.contextmenu.Messages;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.controls.ToggleAction;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.icons.OracleIcons;

public class CountRows
extends GridContextMenuItem {
    private static CountRows _instance = null;
    public static final String _cmdGridCountRows = "cmdGridCountRows";
    public static final int _cmdIdGridCountRows = Ide.findOrCreateCmdID((String)"cmdGridCountRows");
    private IdeAction _actionGridCountRows;
    private String total_Rows_Message = "<html><font color={0} size=+{1}><b>{2}</b></font>{3}</html>";
    private String total_Rows_Message_Selected = "<html><u><font color={0} size=+{1}><b>{2}</b></font>{3}</u></html>";
    private SmallSquareButton copyBtn = new SmallSquareButton(OracleIcons.getIcon((String)"copy.png"), "Copy");
    private JEWTDialog dialog = null;

    private CountRows() {
        this.initAction();
    }

    public static CountRows getInstance() {
        if (_instance == null) {
            _instance = new CountRows();
        }
        return _instance;
    }

    private void initAction() {
        if (this._actionGridCountRows == null) {
            this._actionGridCountRows = this.createAction(_cmdIdGridCountRows, Messages.getString("CountRows.1"), null);
        }
    }

    @Override
    protected boolean canShow(ContextMenu contextMenu) {
        return true;
    }

    @Override
    protected void createAndShowMenu(ContextMenu contextMenu) {
        JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)this._actionGridCountRows);
        contextMenu.add((Component)jMenuItem);
    }

    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        AbstractRaptorGridModel abstractRaptorGridModel;
        if (ideAction.getCommandId() == _cmdIdGridCountRows && this._table != null && (abstractRaptorGridModel = this._table.getGridModel()) != null) {
            final int n = abstractRaptorGridModel.getTotalRows(false);
            final JPanel jPanel = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel.setLayout(gridBagLayout);
            jPanel.setBorder(BorderFactory.createEtchedBorder());
            String string = MessageFormat.format(this.total_Rows_Message, "black", 1.5, n, Messages.getString("CountRows.2"));
            final JLabel jLabel = new JLabel(string);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            final boolean bl = this._table.isFilterApplied();
            final int n2 = abstractRaptorGridModel.getTotalRows(true);
            final JLabel jLabel2 = new JLabel();
            if (bl) {
                String string2 = MessageFormat.format(this.total_Rows_Message, "black", 1.5, n2, Messages.getString("CountRows.3"));
                jLabel2.setText(string2);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
                jPanel.add(jLabel2);
            }
            this.copyBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = n + " " + Messages.getString("CountRows.2");
                    if (bl) {
                        string = string + "\n" + n2 + " " + Messages.getString("CountRows.3");
                    }
                    StringSelection stringSelection = new StringSelection(string);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    ClipboardStack.pushCurrentClipboard();
                    clipboard.setContents(stringSelection, stringSelection);
                    CountRows.this.copyBtn.setSelected(false);
                    jPanel.setBorder(null);
                    jLabel.setText(MessageFormat.format(CountRows.this.total_Rows_Message_Selected, "green", 1.5, n, Messages.getString("CountRows.2")));
                    if (bl) {
                        jLabel2.setText(MessageFormat.format(CountRows.this.total_Rows_Message_Selected, "green", 1.5, n2, Messages.getString("CountRows.3")));
                    }
                    CountRows.this.copyBtn.removeActionListener((ActionListener)this);
                }
            });
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.ipadx = 5;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints((Component)this.copyBtn, gridBagConstraints);
            jPanel.add((Component)this.copyBtn);
            this.dialog = UIUtils.createPanelDialog(jPanel, Messages.getString("CountRows.4"), null, 1);
            this.dialog.runDialog();
            return true;
        }
        return false;
    }

    @Override
    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }
}

