/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.controls.CompletionTextFieldWithDrop;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.grid.GridFilterField;
import oracle.dbtools.raptor.controls.grid.GridFilterInsightProvider;
import oracle.dbtools.raptor.controls.grid.Messages;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridSorter;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.controls.completionfield.FieldInsightProvider;

public class RaptorGridController<T extends RaptorGridTable>
implements Controller {
    public static final String NO_REFRESH_CMD = "EditableGridControl.NO_REFRESH_CMD";
    private static final String FILTER_DATA_CMD = "raptor.dataeditor.filter.data";
    private static final String REFRESH_CMD = "raptor.dataeditor.refresh";
    private static final String SORT_CMD = "raptor.dataeditor.sort";
    private static final int SORT_CMD_ID = Ide.findOrCreateCmdID((String)"raptor.dataeditor.sort");
    private static final int REFRESH_CMD_ID = Ide.findOrCreateCmdID((String)"raptor.dataeditor.refresh");
    private static final int FILTER_DATA_CMD_ID = Ide.findOrCreateCmdID((String)"raptor.dataeditor.filter.data");
    private IdeAction m_REFRESH_ACTION;
    private IdeAction m_SORT_ACTION;
    private IdeAction m_FILTER_ACTION;
    protected T _grid = null;
    protected View _view = null;
    private Controller _superController = null;
    private JButton _sortButton = null;
    private GridSorter sorter;
    private JLabel filterLabel = null;
    private GridFilterField filterField = null;
    private CompletionTextFieldWithDrop filterPanel = null;
    private GridContextMenu _cm = new GridContextMenu();
    private static final List<Integer> _handledCommandIds = new ArrayList<Integer>();
    private static final String BUTTON = "BUTTON";

    public IdeAction getRefreshAction() {
        if (null == this.m_REFRESH_ACTION) {
            this.m_REFRESH_ACTION = IdeAction.find((int)REFRESH_CMD_ID).newLocalAction(this._view);
            this.setupAccelaratorToolTip(this.m_REFRESH_ACTION);
            this.m_REFRESH_ACTION.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    try {
                        ((RaptorGridTable)RaptorGridController.this._grid).refresh();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return true;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    ideAction.setEnabled(RaptorGridController.this.isGridReady());
                    return true;
                }
            });
        }
        return this.m_REFRESH_ACTION;
    }

    private IdeAction getSortAction() {
        if (null == this.m_SORT_ACTION) {
            this.m_SORT_ACTION = IdeAction.find((int)SORT_CMD_ID).newLocalAction(this._view);
            this.setupAccelaratorToolTip(this.m_SORT_ACTION);
            this.m_SORT_ACTION.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    RaptorGridController.this.sorter.setGrid((RaptorGridTable)RaptorGridController.this._grid);
                    RaptorGridController.this.sorter.sort();
                    return true;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    ideAction.setEnabled(RaptorGridController.this.isGridReady());
                    return true;
                }
            });
        }
        return this.m_SORT_ACTION;
    }

    private IdeAction getFilterAction() {
        if (null == this.m_FILTER_ACTION) {
            this.m_FILTER_ACTION = IdeAction.find((int)FILTER_DATA_CMD_ID).newLocalAction(this._view);
            this.setupAccelaratorToolTip(this.m_FILTER_ACTION);
            this.m_FILTER_ACTION.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    RaptorGridController.this.filterField.requestFocusInWindow();
                    return true;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    ideAction.setEnabled(RaptorGridController.this.isGridReady() && ((RaptorGridTable)RaptorGridController.this._grid).isFilterFieldAllowed());
                    return true;
                }
            });
        }
        return this.m_FILTER_ACTION;
    }

    protected void setupAccelaratorToolTip(IdeAction ideAction) {
        UIUtils.setupAccelerator(ideAction);
        if (null == this._grid) {
            Logger.severe(this.getClass(), (String)"Internal Error: Attempt to set up accelerators before _grid initialized.");
        } else {
            ((JComponent)this._grid).getActionMap().put(ideAction.getCommandId(), (Action)ideAction);
        }
    }

    public RaptorGridController() {
        this.sorter = (GridSorter)GridSorter.getInstance();
    }

    public boolean isGridReady() {
        if (this._grid == null) {
            return false;
        }
        if (((RaptorGridTable)this._grid).getGridModel() == null) {
            return false;
        }
        return ((RaptorGridTable)this._grid).getGridModel().getGridColumns() != null;
    }

    protected static void addHandledCommandId(Integer n) {
        _handledCommandIds.add(n);
    }

    protected static boolean isHandledCommandId(Integer n) {
        return _handledCommandIds.contains(n);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (!RaptorGridController.isHandledCommandId(n)) {
            if (this._superController != null) {
                return this._superController.handleEvent(ideAction, context);
            }
            return false;
        }
        if (null == this._grid) {
            Logger.warn(this.getClass(), (String)("Internal Error: Null grid when trying to handle " + ideAction));
        }
        try {
            if (n == 17) {
                if (((RaptorGridTable)this._grid).getGridCopyAdapter().canCut()) {
                    ((RaptorGridTable)this._grid).getGridCopyAdapter().copyToClipboard(true);
                }
            } else if (n == 18) {
                if (((RaptorGridTable)this._grid).getGridCopyAdapter().canCopy()) {
                    ((RaptorGridTable)this._grid).getGridCopyAdapter().copyToClipboard();
                }
            } else if (n == 19) {
                if (this.filterField.hasFocus()) {
                    this.filterField.paste();
                } else {
                    ((RaptorGridTable)this._grid).getGridCopyAdapter().pasteToJTable();
                }
            } else if (n == 78) {
                boolean bl = ClipboardStack.adjustCurrentClipboard();
                if (bl) {
                    if (this.filterField.hasFocus()) {
                        this.filterField.paste();
                    } else {
                        ((RaptorGridTable)this._grid).getGridCopyAdapter().pasteToJTable();
                    }
                }
            } else if (n == 22) {
                ((RaptorGridTable)this._grid).selectAll();
            } else {
                Logger.severe(this.getClass(), (String)("Internal Error: No handler implementation for " + ideAction));
            }
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (!RaptorGridController.isHandledCommandId(n)) {
            if (this._superController != null) {
                return this._superController.update(ideAction, context);
            }
            return false;
        }
        if (!this.isGridReady()) {
            ideAction.setEnabled(false);
            return true;
        }
        try {
            if (n == 17) {
                ideAction.setEnabled(((RaptorGridTable)this._grid).getGridCopyAdapter().canCut());
            } else if (n == 18) {
                ideAction.setEnabled(((RaptorGridTable)this._grid).getGridCopyAdapter().canCopy());
            } else if (n == 19 || n == 78) {
                ideAction.setEnabled(((RaptorGridTable)this._grid).getGridCopyAdapter().canPaste());
            } else if (n == 22) {
                ideAction.setEnabled(((JTable)this._grid).getColumnCount() > 0 && ((JTable)this._grid).getRowCount() > 0);
            } else {
                Logger.severe(this.getClass(), (String)("Internal Error: No update implementation for " + ideAction));
            }
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
        return true;
    }

    protected void setGrid(T t) {
        this.clearLocalActions();
        this._grid = t;
        if (t == null) {
            this._superController = null;
            this.setView(null);
            return;
        }
        RaptorGridTable.addGridContextMenu(this._cm);
        this.filterField = this.getGridFilterField(this._grid);
        this.filterPanel = new CompletionTextFieldWithDrop(this.filterField);
    }

    protected GridFilterField getGridFilterField(T t) {
        return new GridFilterField((RaptorGridTable)t){

            @Override
            protected List<String> getColumnNames() {
                List<String> list = super.getColumnNames();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string : list) {
                    arrayList.add(RaptorGridController.this.decorateFilterColumnID(string));
                }
                return arrayList;
            }
        };
    }

    protected String decorateFilterColumnID(String string) {
        return string;
    }

    protected boolean caseMatters(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (Character.isUpperCase(c.charValue()) || Character.isDigit(c.charValue())) continue;
            if (i == 0) {
                return true;
            }
            if (c.charValue() == '_' || c.charValue() == '$' || c.charValue() == '#') continue;
            return true;
        }
        return false;
    }

    protected void clearLocalActions() {
        this.m_REFRESH_ACTION = null;
        this.m_SORT_ACTION = null;
        this.m_FILTER_ACTION = null;
    }

    public void setView(View view) {
        this.clearLocalActions();
        this._view = view;
    }

    public void setSuperController(Controller controller) {
        this._superController = controller;
    }

    protected static boolean addToToolbar(IdeAction ideAction, Toolbar toolbar) {
        JComponent jComponent;
        boolean bl = false;
        if (null != ideAction && ((jComponent = (JComponent)ideAction.getValue(BUTTON)) == null || toolbar.getComponentIndex((Component)jComponent) == -1)) {
            jComponent = toolbar.add((ToggleAction)ideAction);
            jComponent.setName(ideAction.getValue("Name").toString());
            ideAction.putValue(BUTTON, (Object)jComponent);
            bl = true;
        }
        return bl;
    }

    protected static void removeFromToolbar(IdeAction ideAction, Toolbar toolbar) {
        JComponent jComponent;
        if (null != ideAction && (jComponent = (JComponent)ideAction.getValue(BUTTON)) != null && toolbar.getComponentIndex((Component)jComponent) != -1) {
            toolbar.remove((Component)jComponent);
        }
    }

    public void addToolBarActions(Toolbar toolbar) {
        if (this._grid != null && toolbar != null) {
            boolean bl = this.addFirstToolbarActions(toolbar);
            if (bl) {
                toolbar.addSeparator();
                bl = false;
            }
            bl = this.addMiddleToolbarActions(toolbar);
        }
    }

    protected boolean addFirstToolbarActions(Toolbar toolbar) {
        if (this._grid != null && toolbar != null && ((RaptorGridTable)this._grid).isRefreshAllowed() && !Boolean.parseBoolean((String)toolbar.getClientProperty((Object)NO_REFRESH_CMD))) {
            RaptorGridController.addToToolbar(this.getRefreshAction(), toolbar);
        }
        return false;
    }

    protected boolean addMiddleToolbarActions(final Toolbar toolbar) {
        final int n = toolbar.getComponentCount();
        this.maybeAddSort(toolbar, n);
        ((Container)this._grid).addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RaptorGridController.this.maybeAddSort(toolbar, n);
                    }
                });
            }
        });
        this.maybeAddFilter(toolbar);
        return false;
    }

    private void maybeAddFilter(Toolbar toolbar) {
        if (((RaptorGridTable)this._grid).isFilterFieldAllowed()) {
            if (this.filterLabel == null) {
                this.filterLabel = new JLabel(Messages.getString("RaptorGridController.3"));
            }
            if (toolbar.getComponentIndex((Component)this.filterLabel) == -1) {
                this.filterField.getPopupHandler().registerInsightProvider((FieldInsightProvider)new GridFilterInsightProvider(this.filterField));
                this.filterLabel.setLabelFor((Component)((Object)this.filterField));
                this.filterField.setEditable(true);
                this.filterPanel.setSize(200, 0);
                toolbar.add((Component)this.filterLabel);
                toolbar.add((Component)this.filterPanel);
            }
        } else {
            toolbar.remove((Component)this.filterPanel);
            if (this.filterLabel != null) {
                toolbar.remove((Component)this.filterLabel);
            }
        }
    }

    private void maybeAddSort(Toolbar toolbar, int n) {
        if (((RaptorGridTable)this._grid).isMultiColSort()) {
            if (this._sortButton == null) {
                IdeAction ideAction = this.getSortAction();
                this._sortButton = new JButton((Action)ideAction);
                this._sortButton.setText(Messages.getString("RaptorGridController.0"));
                this._sortButton.setIcon(null);
                this._sortButton.setToolTipText(Messages.getString("RaptorGridController.1"));
                ideAction.putValue(BUTTON, (Object)this._sortButton);
            }
            if (toolbar.getComponentIndex((Component)this._sortButton) == -1) {
                toolbar.add((Component)this._sortButton, n);
                toolbar.add((Component)toolbar.newSeparator(), n + 1);
            }
        } else {
            RaptorGridController.removeFromToolbar(this.m_SORT_ACTION, toolbar);
        }
    }

    public void addContextMenuActions(ContextMenu contextMenu) {
        if (this._grid != null && contextMenu != null && ((RaptorGridTable)this._grid).isRefreshAllowed()) {
            JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)this.getRefreshAction());
            contextMenu.add((Component)jMenuItem);
        }
    }

    public GridFilterField getGridFilterField() {
        return this.filterField;
    }

    GridContextMenuItem getGridContextMenu() {
        return this._cm;
    }

    public T getGrid() {
        return this._grid;
    }

    public void updateControllerActions(boolean bl) {
        this.filterPanel.setEnabled(bl);
        if (this._sortButton != null) {
            this._sortButton.setEnabled(bl);
        }
    }

    protected static void setEnabled(IdeAction ideAction, boolean bl) {
        if (null == ideAction) {
            return;
        }
        ideAction.setEnabled(bl);
    }

    static {
        RaptorGridController.addHandledCommandId(17);
        RaptorGridController.addHandledCommandId(18);
        RaptorGridController.addHandledCommandId(19);
        RaptorGridController.addHandledCommandId(78);
        RaptorGridController.addHandledCommandId(22);
    }

    private class GridContextMenu
    extends GridContextMenuItem {
        private GridContextMenu() {
        }

        @Override
        protected boolean canShow(ContextMenu contextMenu) {
            return RaptorGridController.this._grid != null && this._table == RaptorGridController.this._grid;
        }

        @Override
        protected void createAndShowMenu(ContextMenu contextMenu) {
            RaptorGridController.this.addContextMenuActions(contextMenu);
        }

        @Override
        public boolean handleEvent(IdeAction ideAction, Context context) {
            return RaptorGridController.this.handleEvent(ideAction, context);
        }

        @Override
        public boolean update(IdeAction ideAction, Context context) {
            return RaptorGridController.this.update(ideAction, context);
        }
    }
}

