/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.TreeMap;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.util.Service;
import oracle.javatools.buffer.TextBuffer;

public class Replacements {
    private String input;
    private TreeMap<Long, String> substitutions = new TreeMap();

    public Replacements(String string) {
        this.input = string;
    }

    public void put(int n, int n2, String string) {
        this.substitutions.put(Service.lPair((int)n, (int)n2), string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (long l : this.substitutions.keySet()) {
            int n2 = Service.lX((long)l);
            int n3 = Service.lY((long)l);
            if (n < n2) {
                stringBuilder.append(this.input.substring(n, n2));
            }
            stringBuilder.append("\n---\n");
            stringBuilder.append(this.input.substring(n2, n3));
            stringBuilder.append("\n--->>>\n");
            stringBuilder.append(this.substitutions.get(l));
            stringBuilder.append("\n---\n");
            n = n3;
        }
        stringBuilder.append(this.input.substring(n));
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        String string;
        Replacements replacements = (Replacements)object;
        for (Long l : this.substitutions.keySet()) {
            string = replacements.substitutions.get(l);
            if (string == null) {
                return false;
            }
            if (!string.equals(this.substitutions.get(l))) continue;
            return false;
        }
        for (Long l : replacements.substitutions.keySet()) {
            string = this.substitutions.get(l);
            if (string != null) continue;
            return false;
        }
        return true;
    }

    public String diff(Object object) {
        String string;
        Replacements replacements = (Replacements)object;
        for (Long l : this.substitutions.keySet()) {
            string = replacements.substitutions.get(l);
            if (string == null) {
                return "no match for " + Service.lX((long)l) + "," + Service.lY((long)l) + " `" + this.substitutions.get(l) + "`";
            }
            if (!string.equals(this.substitutions.get(l))) continue;
            return "" + Service.lX((long)l) + "," + Service.lY((long)l) + " `" + this.substitutions.get(l) + "` != `" + string + "`";
        }
        for (Long l : replacements.substitutions.keySet()) {
            string = this.substitutions.get(l);
            if (string != null) continue;
            return "no match for " + Service.lX((long)l) + "," + Service.lY((long)l) + " `" + replacements.substitutions.get(l) + "`";
        }
        return "=";
    }

    public String[] lines() {
        String[] stringArray = new String[this.substitutions.size()];
        int n = -1;
        for (long l : this.substitutions.keySet()) {
            stringArray[++n] = "" + Service.lX((long)l) + "," + Service.lY((long)l) + " `" + this.substitutions.get(l) + "`";
        }
        return stringArray;
    }

    public UndoableEdit modify(TextBuffer textBuffer) {
        textBuffer.beginEdit();
        int n = 0;
        for (long l : this.substitutions.keySet()) {
            int n2 = Service.lX((long)l);
            int n3 = Service.lY((long)l);
            String string = this.substitutions.get(l);
            textBuffer.remove(n2 + n, n3 - n2);
            textBuffer.insert(n2 + n, string.toCharArray());
            int n4 = string.length() - n3 + n2;
            n += n4;
        }
        return textBuffer.endEdit();
    }

    public static void main(String[] stringArray) {
        Replacements replacements = new Replacements("0123456789012345");
        replacements.put(1, 2, "[1,2)");
        replacements.put(11, 12, "[11,12)");
        System.out.println(replacements.toString());
    }
}

