/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.vm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.text.Collator;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.xml.parsers.FactoryFinderReadOnly;
import javax.xml.validation.SchemaFactoryReadOnly;
import oracle.OracleString;
import oracle.aurora.security.JServerPermission;
import oracle.aurora.vm.CachedLocaleData;
import oracle.aurora.vm.EnvironmentSpecific;
import oracle.gss.util.NLSLocale;
import oracle.i18n.text.OraMapTable;
import oracle.i18n.util.LocaleMapper;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import sun.misc.Launcher;
import sun.util.calendar.ZoneInfoFile;

public class HotLoader {
    private static boolean saving;
    private static boolean inited;
    private static boolean initing;

    private HotLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean save(OracleString className, boolean flushSROs) {
        try {
            saving = true;
            HotLoader.initSystem(flushSROs);
            String name = className.toString().replace('/', '.').replace(File.separatorChar, '.');
            try {
                Class<?> c = Class.forName(name);
                boolean bl = HotLoader.save(c);
                return bl;
            }
            catch (Exception e) {
                e.printStackTrace();
                boolean bl = false;
                saving = false;
                return bl;
            }
        }
        finally {
            saving = false;
        }
    }

    public static boolean save(Class clazz) {
        JServerPermission.check((String)"HotLoader");
        return HotLoader.save0(clazz);
    }

    private static native boolean save0(Class var0);

    public static boolean isIniting() {
        return initing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initSystem(boolean flushSROs) {
        if (inited) {
            return;
        }
        try {
            initing = true;
            Launcher.getLauncher();
            CharacterSet x = CHAR.DEFAULT_CHARSET;
            HotLoader.class.getProtectionDomain();
            Package.getPackages();
            new Date().toString();
            Locale.getISOCountries();
            Locale.getISOLanguages();
            SchemaFactoryReadOnly.initcacheProps();
            FactoryFinderReadOnly.initcacheProps();
            javax.xml.transform.FactoryFinderReadOnly.initcacheProps();
            if (flushSROs) {
                Locale[] allLocales = Locale.getAvailableLocales();
                for (int i = 0; i < allLocales.length; ++i) {
                    Locale aLocale = allLocales[i];
                    Calendar.getInstance(aLocale);
                    Collator acoll = Collator.getInstance(aLocale);
                    new DecimalFormatSymbols(aLocale);
                    NumberFormat.getInstance(aLocale);
                    DateFormat.getDateTimeInstance(3, 3, aLocale);
                    CachedLocaleData.saveAll(aLocale);
                }
            }
            HotLoader.initNLSLocale();
            HotLoader.initObjectStreamField();
            ZoneInfoFile.prepareForHotLoading();
            EnvironmentSpecific.initForHotLoading();
            inited = true;
        }
        finally {
            initing = false;
        }
    }

    private static void initNLSLocale() {
        NLSLocale nlsloc = NLSLocale.getInstance();
        nlsloc.getJavaLanguage("");
        nlsloc.getJavaTerritory("");
        nlsloc.enumNLSLocales();
        nlsloc.enumJavaLocales();
        nlsloc.enumNLSCharsets();
        nlsloc.enumJavaCharsets();
        nlsloc.getNLSLanguage(Locale.getDefault());
        nlsloc.getNLSLanguage("");
        nlsloc.getNLSTerritory("");
        nlsloc.enumIANACharsets();
        for (int i = 1; i < 20; ++i) {
            OraMapTable.getInstance((int)i);
        }
        LocaleMapper.isSupersetOf((int)1, (int)1);
        OraLocaleInfo.getAvailableCurrencies();
    }

    public static void initObjectStreamField() {
        Loser loser = new Loser();
        try {
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            ObjectOutputStream objos = new ObjectOutputStream(ostream);
            objos.writeObject(loser);
            objos.flush();
            ByteArrayInputStream istream = new ByteArrayInputStream(ostream.toByteArray());
            ObjectInputStream objis = new ObjectInputStream(istream);
            objis.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean inSave() {
        return saving;
    }

    static {
        inited = false;
        initing = false;
    }

    private static class Loser
    implements Serializable {
        String loserString = "loser string";
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("loserString", String.class)};

        private Loser() {
        }

        private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
            is.readFields().get("loserString", null);
        }
    }
}

