/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import oracle.aurora.util.Alarm;
import oracle.aurora.util.AlarmHandler;

public class AlarmManager
implements Runnable {
    private Alarm alarms;

    public synchronized void cancel(Alarm alarm) {
        Alarm curr = this.alarms;
        if (alarm == curr) {
            this.alarms = curr.next;
            this.notify();
        } else if (curr != null) {
            Alarm next;
            while ((next = curr.next) != null && alarm != next) {
                curr = next;
            }
            if (next != null) {
                curr.next = next.next;
            }
        }
    }

    public synchronized void cancelAll() {
        this.alarms = null;
        this.notify();
    }

    public synchronized Alarm getNextActiveAlarm() {
        if (this.alarms == null) {
            return null;
        }
        if (this.alarms.time - System.currentTimeMillis() > 0L) {
            return null;
        }
        Alarm a = this.alarms;
        this.alarms = this.alarms.next;
        return a;
    }

    private synchronized Alarm getNextAlarm() {
        while (true) {
            if (this.alarms == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
                continue;
            }
            long time = this.alarms.time - System.currentTimeMillis();
            if (time <= 0L) {
                Alarm a = this.alarms;
                this.alarms = this.alarms.next;
                return a;
            }
            try {
                this.wait(time);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public synchronized long getNextAlarmTime() {
        if (this.alarms == null) {
            return 0L;
        }
        return this.alarms.time;
    }

    public synchronized boolean isEmpty() {
        return this.alarms == null;
    }

    public void run() {
        Alarm alarm;
        while ((alarm = this.getNextAlarm()) != null) {
            alarm.fire();
        }
    }

    public void schedule(long delta, AlarmHandler handler) {
        this.schedule(new Alarm(System.currentTimeMillis() + delta, handler));
    }

    public void schedule(long delta, AlarmHandler handler, Object data) {
        this.schedule(new Alarm(System.currentTimeMillis() + delta, handler, data));
    }

    public synchronized void schedule(Alarm alarm) {
        Alarm curr = this.alarms;
        if (curr == null || alarm.time < curr.time) {
            alarm.next = curr;
            this.alarms = alarm;
            this.notify();
        } else {
            Alarm next;
            while ((next = curr.next) != null && alarm.time >= next.time) {
                curr = next;
            }
            curr.next = alarm;
            alarm.next = next;
        }
    }
}

