/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.transformer;

import ilog.views.IlvTransformer;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public abstract class TransformerUtil {
    public static final IlvTransformer IDENTITY_TRANSFORMER = new IlvTransformer();
    public static final AffineTransform JAVA2D_IDENTITY_TRANSFORMER = new AffineTransform();

    private TransformerUtil() {
    }

    public static AffineTransform getAffineTransform(IlvTransformer t) {
        if (t == null) {
            return new AffineTransform();
        }
        AffineTransform at = new AffineTransform(t.getx11(), t.getx21(), t.getx12(), t.getx22(), t.getx0(), t.gety0());
        return at;
    }

    public static IlvTransformer getTransformer(AffineTransform t) {
        if (t == null) {
            return new IlvTransformer();
        }
        IlvTransformer at = new IlvTransformer(t.getScaleX(), t.getShearX(), t.getShearY(), t.getScaleY(), t.getTranslateX(), t.getTranslateY());
        return at;
    }

    public static AffineTransform applyTransformer(Graphics2D graphics, IlvTransformer t, boolean replace) {
        AffineTransform current = graphics.getTransform();
        AffineTransform at = TransformerUtil.getAffineTransform(t);
        if (replace) {
            graphics.setTransform(at);
        } else {
            AffineTransform copy = new AffineTransform(graphics.getTransform());
            copy.concatenate(at);
            graphics.setTransform(copy);
        }
        return current;
    }

    public static float getApplied(IlvTransformer t, float dimension) {
        Dimension dim = new Dimension();
        ((Dimension2D)dim).setSize(dimension, 0.0);
        TransformerUtil.apply(t, dim);
        return (float)((Dimension2D)dim).getWidth();
    }

    public static float getInverse(IlvTransformer t, float dimension) {
        Dimension dim = new Dimension();
        ((Dimension2D)dim).setSize(dimension, 0.0);
        TransformerUtil.inverse(t, dim);
        return (float)((Dimension2D)dim).getWidth();
    }

    public static Area getApplied(IlvTransformer t, Shape shape) {
        Area area = new Area(shape);
        return area.createTransformedArea(TransformerUtil.getAffineTransform(t));
    }

    public static void apply(IlvTransformer t, Dimension2D dimension) {
        if (t == null || t.isTranslation() || t.isIdentity()) {
            return;
        }
        if (t.isScale()) {
            double w = t.getx11() * dimension.getWidth();
            double h = t.getx22() * dimension.getHeight();
            dimension.setSize(w, h);
        } else {
            double w = t.getx11() * dimension.getWidth() + t.getx12() * dimension.getHeight();
            double h = t.getx21() * dimension.getWidth() + t.getx22() * dimension.getHeight();
            dimension.setSize(w, h);
        }
    }

    public static boolean inverse(IlvTransformer t, Dimension2D dimension) {
        if (t == null || t.isBad()) {
            return false;
        }
        IlvTransformer inv = new IlvTransformer();
        t.computeInverse(inv);
        TransformerUtil.apply(inv, dimension);
        return true;
    }

    public static void apply(IlvTransformer t, Point2D point) {
        if (t == null || t.isIdentity()) {
            return;
        }
        if (t.isTranslation()) {
            double x = t.getx0() + point.getX();
            double y = t.gety0() + point.getY();
            point.setLocation(x, y);
        } else if (t.isScale()) {
            double x = t.getx11() * point.getX() + t.getx0();
            double y = t.getx22() * point.getY() + t.gety0();
            point.setLocation(x, y);
        } else {
            double x = t.getx11() * point.getX() + t.getx12() * point.getY() + t.getx0();
            double y = t.getx21() * point.getX() + t.getx22() * point.getY() + t.gety0();
            point.setLocation(x, y);
        }
    }

    public static boolean inverse(IlvTransformer t, Point2D point) {
        if (t == null || t.isBad()) {
            return false;
        }
        IlvTransformer inv = new IlvTransformer();
        t.computeInverse(inv);
        TransformerUtil.apply(inv, point);
        return true;
    }

    public static void apply(IlvTransformer t, Rectangle2D rect) {
        if (t == null || t.isIdentity()) {
            return;
        }
        if (t.isTranslation()) {
            double x = rect.getX() + t.getx0();
            double y = rect.getY() + t.gety0();
            rect.setRect(x, y, rect.getWidth(), rect.getHeight());
        } else if (t.isScale()) {
            double x = t.getx11() * rect.getX() + t.getx0();
            double y = t.getx22() * rect.getY() + t.gety0();
            double w = t.getx11() * rect.getWidth();
            double h = t.getx22() * rect.getHeight();
            rect.setRect(x, y, w, h);
        } else {
            double x = t.getx11() * rect.getX() + t.getx12() * rect.getY() + t.getx0();
            double y = t.getx21() * rect.getX() + t.getx22() * rect.getY() + t.gety0();
            double w = t.getx11() * rect.getWidth() + t.getx12() * rect.getHeight();
            double h = t.getx21() * rect.getWidth() + t.getx22() * rect.getHeight();
            rect.setRect(x, y, w, h);
        }
    }

    public static boolean inverse(IlvTransformer t, Rectangle2D rect) {
        if (t == null || t.isBad()) {
            return false;
        }
        IlvTransformer inv = new IlvTransformer();
        t.computeInverse(inv);
        TransformerUtil.apply(inv, rect);
        return true;
    }

    public static void apply(IlvTransformer t, RoundRectangle2D roundRect) {
        if (t == null || t.isIdentity()) {
            return;
        }
        if (t.isTranslation()) {
            double x = roundRect.getX() + t.getx0();
            double y = roundRect.getY() + t.gety0();
            roundRect.setRoundRect(x, y, roundRect.getWidth(), roundRect.getHeight(), roundRect.getArcWidth(), roundRect.getArcHeight());
        } else if (t.isScale()) {
            double x = t.getx11() * roundRect.getX() + t.getx0();
            double y = t.getx22() * roundRect.getY() + t.gety0();
            double w = t.getx11() * roundRect.getWidth();
            double h = t.getx22() * roundRect.getHeight();
            double aw = t.getx11() * roundRect.getArcWidth();
            double ah = t.getx22() * roundRect.getArcHeight();
            roundRect.setRoundRect(x, y, w, h, aw, ah);
        } else {
            double x = t.getx11() * roundRect.getX() + t.getx12() * roundRect.getY() + t.getx0();
            double y = t.getx21() * roundRect.getX() + t.getx22() * roundRect.getY() + t.gety0();
            double w = t.getx11() * roundRect.getWidth() + t.getx12() * roundRect.getHeight();
            double h = t.getx21() * roundRect.getWidth() + t.getx22() * roundRect.getHeight();
            double aw = t.getx11() * roundRect.getArcWidth() + t.getx12() * roundRect.getArcHeight();
            double ah = t.getx21() * roundRect.getArcWidth() + t.getx22() * roundRect.getArcHeight();
            roundRect.setRoundRect(x, y, w, h, aw, ah);
        }
    }

    public static boolean inverse(IlvTransformer t, RoundRectangle2D roundRect) {
        if (t == null || t.isBad()) {
            return false;
        }
        IlvTransformer inv = new IlvTransformer();
        t.computeInverse(inv);
        TransformerUtil.apply(inv, roundRect);
        return true;
    }

    public static void apply(IlvTransformer t, Line2D line) {
        if (t == null || t.isIdentity()) {
            return;
        }
        if (t.isTranslation()) {
            double x1 = line.getX1() + t.getx0();
            double y1 = line.getY1() + t.gety0();
            double x2 = line.getX2() + t.getx0();
            double y2 = line.getY2() + t.gety0();
            line.setLine(x1, y1, x2, y2);
        } else if (t.isScale()) {
            double x1 = t.getx11() * line.getX1() + t.getx0();
            double y1 = t.getx22() * line.getY1() + t.gety0();
            double x2 = t.getx11() * line.getX2() + t.getx0();
            double y2 = t.getx22() * line.getY2() + t.gety0();
            line.setLine(x1, y1, x2, y2);
        } else {
            double x1 = t.getx11() * line.getX1() + t.getx12() * line.getY1() + t.getx0();
            double y1 = t.getx21() * line.getX1() + t.getx22() * line.getY1() + t.gety0();
            double x2 = t.getx11() * line.getX2() + t.getx12() * line.getY2() + t.getx0();
            double y2 = t.getx21() * line.getX2() + t.getx22() * line.getY2() + t.gety0();
            line.setLine(x1, y1, x2, y2);
        }
    }

    public static boolean inverse(IlvTransformer t, Line2D line) {
        if (t == null || t.isBad()) {
            return false;
        }
        IlvTransformer inv = new IlvTransformer();
        t.computeInverse(inv);
        TransformerUtil.apply(inv, line);
        return true;
    }

    public static void apply(IlvTransformer t, Ellipse2D ellipse) {
        if (t == null || t.isIdentity()) {
            return;
        }
        if (t.isTranslation()) {
            double x = ellipse.getX() + t.getx0();
            double y = ellipse.getY() + t.gety0();
            ellipse.setFrame(x, y, ellipse.getWidth(), ellipse.getHeight());
        } else if (t.isScale()) {
            double x = t.getx11() * ellipse.getX() + t.getx0();
            double y = t.getx22() * ellipse.getY() + t.gety0();
            double w = t.getx11() * ellipse.getWidth();
            double h = t.getx22() * ellipse.getHeight();
            ellipse.setFrame(x, y, w, h);
        } else {
            double x = t.getx11() * ellipse.getX() + t.getx12() * ellipse.getY() + t.getx0();
            double y = t.getx21() * ellipse.getX() + t.getx22() * ellipse.getY() + t.gety0();
            double w = t.getx11() * ellipse.getWidth() + t.getx12() * ellipse.getHeight();
            double h = t.getx21() * ellipse.getWidth() + t.getx22() * ellipse.getHeight();
            ellipse.setFrame(x, y, w, h);
        }
    }

    public static boolean inverse(IlvTransformer t, Ellipse2D ellipse) {
        if (t == null || t.isBad()) {
            return false;
        }
        IlvTransformer inv = new IlvTransformer();
        t.computeInverse(inv);
        TransformerUtil.apply(inv, ellipse);
        return true;
    }
}

