/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.bm.javatools.util.MultivaluedMap;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.framework.swimlanes.SwimlanesGraphicManager;
import oracle.diagram.framework.swimlanes.SwimlanesPermissions;
import oracle.diagram.framework.swimlanes.SwimlanesPlugin;
import oracle.diagram.framework.swimlanes.graphic.ExtendedSwimlaneGraphic;
import oracle.diagram.framework.swimlanes.graphic.PoolGraphic;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphic;

public class DefaultSwimlanesPlugin
extends AbstractPlugin
implements SwimlanesPlugin,
SwimlanesPermissions {
    private HashMap<IlvManager, SwimlaneGraphic> _topSwimlanes = new HashMap();
    private HashMap<IlvGraphic, SwimlaneGraphic> _graphicToSwimlaneMap = new HashMap();
    private MultivaluedMap<SwimlaneGraphic, IlvGraphic> _swimlaneToGraphicsMap = new MultivaluedMap();
    private SwimlanesGraphicManager _graphicsManager = new SwimlanesGraphicManager(){

        @Override
        protected Collection<IlvGraphic> getGraphicsInSwimlane(SwimlaneGraphic sg) {
            return DefaultSwimlanesPlugin.this.getGraphicsInSwimlane(sg);
        }

        @Override
        protected SwimlaneGraphic getSwimlaneForGraphic(IlvGraphic g) {
            return DefaultSwimlanesPlugin.this.getSwimlaneForGraphic(g);
        }
    };

    public void setTopSwimlane(IlvManager mgr, SwimlaneGraphic sg) {
        this._topSwimlanes.put(mgr, sg);
        this._graphicsManager.setTopSwimlane(mgr, sg);
        sg.setPermissions(this);
        sg.setContentsProvider(this);
    }

    @Override
    public SwimlaneGraphic getTopSwimlane(IlvManager topManager) {
        return this._topSwimlanes.get(topManager);
    }

    public void addGraphicToSwimlane(IlvGraphic g, SwimlaneGraphic sg) {
        this._graphicToSwimlaneMap.put(g, sg);
        this._swimlaneToGraphicsMap.put((Object)sg, (Object)g);
        this._graphicsManager.addGraphicToSwimlane(g, sg);
    }

    @Override
    public SwimlaneGraphic getSwimlaneForGraphic(IlvGraphic g) {
        return this._graphicToSwimlaneMap.get(g);
    }

    public void removeGraphicFromSwimlane(IlvGraphic g, SwimlaneGraphic sg) {
        this._graphicToSwimlaneMap.remove(g);
        this._swimlaneToGraphicsMap.remove((Object)sg, (Object)g);
    }

    @Override
    public Collection<IlvGraphic> getGraphicsInSwimlane(SwimlaneGraphic sg) {
        Collection graphics = this._swimlaneToGraphicsMap.get((Object)sg);
        if (graphics == null) {
            Set emptySet = Collections.emptySet();
            return Collections.unmodifiableCollection(emptySet);
        }
        return Collections.unmodifiableCollection(graphics);
    }

    public Collection<IlvGraphic> removeSwimlane(SwimlaneGraphic sg) {
        Collection<IlvGraphic> graphics = this.getGraphicsInSwimlane(sg);
        HashSet<IlvGraphic> allGraphics = new HashSet<IlvGraphic>(graphics);
        if (sg instanceof ExtendedSwimlaneGraphic) {
            ExtendedSwimlaneGraphic ext = (ExtendedSwimlaneGraphic)sg;
            SwimlaneGraphic pool = ext.getPool();
            if (pool != null) {
                allGraphics.addAll(this.removeSwimlane(pool));
            }
        } else if (sg instanceof PoolGraphic) {
            PoolGraphic poolGraphic = (PoolGraphic)sg;
            List<SwimlaneGraphic> lanes = poolGraphic.getLanes();
            for (SwimlaneGraphic lane : lanes) {
                allGraphics.addAll(this.removeSwimlane(lane));
            }
        }
        this._swimlaneToGraphicsMap.remove((Object)sg);
        if (graphics != null && !graphics.isEmpty()) {
            for (IlvGraphic g : graphics) {
                this._graphicToSwimlaneMap.remove(g);
            }
        }
        return allGraphics;
    }

    @Override
    public boolean canResizeSwimlanes(PoolGraphic pool) {
        return true;
    }

    @Override
    public boolean canMoveSwimlane(PoolGraphic pool, int index) {
        return true;
    }

    @Override
    public boolean acceptNodeType(IlvManager topManager, SwimlaneGraphic sg, String nodeType) {
        return sg != null;
    }

    @Override
    public boolean acceptNodeGraphic(IlvManager topManager, SwimlaneGraphic sg, IlvGraphic nodeGraphic) {
        return sg != null;
    }

    @Override
    public boolean canMoveSwimlane(PoolGraphic pool, int fromIndex, int toIndex) {
        return true;
    }
}

