/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.print;

import ilog.views.IlvRect;
import java.awt.print.PageFormat;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.framework.print.DefaultPageFormat;
import oracle.diagram.framework.print.PrintPlugin;

public abstract class AbstractPrintPlugin
extends AbstractPlugin
implements PrintPlugin {
    private final DiagramContext _context;
    private PageFormat _pageFormat = null;
    private IlvRect _printArea = null;

    protected AbstractPrintPlugin(DiagramContext context) {
        this._context = context;
    }

    @Override
    public synchronized PageFormat getPageFormat() {
        if (this._pageFormat == null) {
            this._pageFormat = DefaultPageFormat.getInstance().getPageFormat(1);
        }
        return (PageFormat)this._pageFormat.clone();
    }

    @Override
    public void setPageFormat(PageFormat format) {
        this._pageFormat = (PageFormat)format.clone();
        this.pageFormatChanged();
    }

    @Override
    public void setPrintArea(IlvRect area) {
        this._printArea = area == null ? null : new IlvRect(area);
        this.printAreaChanged();
    }

    @Override
    public IlvRect getPrintArea() {
        return this._printArea == null ? null : new IlvRect(this._printArea);
    }

    protected final DiagramContext getDiagramContext() {
        return this._context;
    }

    protected void pageFormatChanged() {
    }

    protected void printAreaChanged() {
    }
}

