/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic.layout;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.graphic.IlvLine;
import ilog.views.graphic.composite.layout.IlvAttachable;
import ilog.views.graphic.composite.layout.IlvAttachableGraphic;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.ExtendedGraphic;
import oracle.diagram.framework.graphic.layout.AbstractLayout;
import oracle.diagram.framework.graphic.layout.ExtendedLayoutManager;

public class GraphicBorderLayout
extends AbstractLayout
implements ExtendedLayoutManager {
    public void layoutGroup(IlvAttachable parent) {
        IlvRect r;
        IlvGraphic borderGraphic;
        IlvRect bounds = new IlvRect(((IlvAttachableGraphic)parent).getGraphic().boundingBox(null));
        IlvAttachable center = this.getAttachable("Center");
        float leftInset = this.getInset("West");
        float rightInset = this.getInset("East");
        float topInset = this.getInset("North");
        float bottomInset = this.getInset("South");
        bounds.x += leftInset;
        bounds.width -= leftInset + rightInset;
        bounds.y += topInset;
        bounds.height -= topInset + bottomInset;
        if (center instanceof IlvAttachableGraphic) {
            IlvGraphic centerGraphic = ((IlvAttachableGraphic)center).getGraphic();
            IlvRect centerBBox = new IlvRect(centerGraphic.boundingBox(null));
            if (centerBBox.width != bounds.width || centerBBox.height != bounds.height || centerBBox.x != bounds.x || centerBBox.y != bounds.y) {
                centerGraphic.moveResize(bounds);
                IlvRect newBounds = centerGraphic.boundingBox(null);
                if (!newBounds.equals((Object)bounds)) {
                    centerGraphic.resize(bounds.width, bounds.height);
                    centerGraphic.move(bounds.x, bounds.y);
                }
            }
        } else if (center != null) {
            center.resize(new IlvPoint(bounds.width, bounds.height));
            center.move(bounds.x, bounds.y);
        }
        bounds = new IlvRect(((IlvAttachableGraphic)parent).getGraphic().boundingBox(null));
        float leftX = bounds.x + leftInset;
        float topY = bounds.y + topInset;
        float bottomY = bounds.y + bounds.height - bottomInset;
        float rightX = bounds.x + bounds.width - rightInset;
        IlvAttachable attachable = this.getAttachable("West");
        if (attachable != null) {
            borderGraphic = ((IlvAttachableGraphic)attachable).getGraphic();
            if (borderGraphic instanceof IlvLine) {
                IlvLine left = (IlvLine)borderGraphic;
                left.setFrom(new IlvPoint(leftX, topY));
                left.setTo(new IlvPoint(leftX, bottomY));
            } else {
                attachable.move(bounds.x, bounds.y);
                attachable.resize(new IlvPoint(leftInset, bounds.height));
            }
        }
        if ((attachable = this.getAttachable("East")) != null) {
            borderGraphic = ((IlvAttachableGraphic)attachable).getGraphic();
            if (borderGraphic instanceof IlvLine) {
                IlvLine right = (IlvLine)borderGraphic;
                right.setFrom(new IlvPoint(rightX, topY));
                right.setTo(new IlvPoint(rightX, bottomY));
            } else {
                attachable.move(rightX, bounds.y);
                attachable.resize(new IlvPoint(rightInset, bounds.height));
            }
        }
        if ((attachable = this.getAttachable("North")) != null) {
            borderGraphic = ((IlvAttachableGraphic)attachable).getGraphic();
            if (borderGraphic instanceof IlvLine) {
                IlvLine top = (IlvLine)borderGraphic;
                top.setFrom(new IlvPoint(leftX, topY));
                top.setTo(new IlvPoint(rightX, topY));
            } else {
                r = new IlvRect(leftX, bounds.y, rightX - leftX, this.getInset("North"));
                borderGraphic.moveResize(r);
            }
        }
        if ((attachable = this.getAttachable("South")) != null) {
            borderGraphic = ((IlvAttachableGraphic)attachable).getGraphic();
            if (borderGraphic instanceof IlvLine) {
                IlvLine bottom = (IlvLine)borderGraphic;
                bottom.setFrom(new IlvPoint(leftX, bottomY));
                bottom.setTo(new IlvPoint(rightX, bottomY));
            } else {
                r = new IlvRect(leftX, bottomY, rightX - leftX, this.getInset("South"));
                borderGraphic.moveResize(r);
            }
        }
        this.fireLayoutPerformed(((IlvAttachableGraphic)parent).getGraphic());
    }

    private float getInset(Object constraint) {
        IlvAttachable item = this.getAttachable(constraint);
        if (item != null) {
            ExtendedGraphic eg = (ExtendedGraphic)((IlvAttachableGraphic)item).getGraphic();
            DimensionFloat minimum = eg.getMinimumSize(new DimensionFloat());
            if (constraint == "East" || constraint == "West") {
                return minimum.width;
            }
            if (constraint == "North" || constraint == "South") {
                return minimum.height;
            }
            throw new UnsupportedOperationException("Only support NEWS");
        }
        return 0.0f;
    }

    @Override
    public DimensionFloat getMinimumSize(DimensionFloat minimum, IlvAttachable[] children) {
        return this.getXSize(minimum, true);
    }

    @Override
    public DimensionFloat getPreferedSize(DimensionFloat prefered, IlvAttachable[] children) {
        return this.getXSize(prefered, false);
    }

    private DimensionFloat getXSize(DimensionFloat dimension, boolean isMinimum) {
        ExtendedGraphic center;
        IlvAttachableGraphic attachableGraphic = (IlvAttachableGraphic)this.getAttachable("Center");
        if (attachableGraphic != null && (center = (ExtendedGraphic)attachableGraphic.getGraphic()) != null) {
            dimension = isMinimum ? center.getMinimumSize(dimension) : center.getPreferedSize(dimension);
        }
        float left = this.getInset("West");
        float right = this.getInset("East");
        float top = this.getInset("North");
        float bottom = this.getInset("South");
        dimension.width += (left + right) * 2.0f;
        dimension.height += (top + bottom) * 2.0f;
        return dimension;
    }
}

