/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.controller.modular;

import java.util.HashMap;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;

public class ModularController
implements Controller {
    private final Map<Integer, Controller> m_handlerMap = new HashMap<Integer, Controller>(85);

    public final void register(int cmdId, Controller handler) {
        this.m_handlerMap.put(cmdId, handler);
    }

    public final void unregister(int cmdId) {
        this.m_handlerMap.remove(cmdId);
    }

    public final Controller get(int cmdId) {
        return this.m_handlerMap.get(cmdId);
    }

    public final boolean handleEvent(IdeAction action, Context context) {
        Controller c = this.m_handlerMap.get(action.getCommandId());
        if (c != null) {
            return c.handleEvent(action, context);
        }
        return false;
    }

    public final boolean update(IdeAction action, Context context) {
        Controller c = this.m_handlerMap.get(action.getCommandId());
        if (c != null) {
            return c.update(action, context);
        }
        return false;
    }
}

