/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.util;

import java.util.HashMap;
import java.util.Map;

public class GenericContext {
    private final Map<String, Object> _map = new HashMap<String, Object>();

    public Object getProperty(String key) {
        return this._map.get(key);
    }

    public boolean hasProperty(String key) {
        return this._map.containsKey(key);
    }

    public Object setProperty(String key, Object value) {
        Object oldValue = this.getProperty(key);
        this._map.put(key, value);
        return oldValue;
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        Boolean value = (Boolean)this.getProperty(key);
        return value != null ? value : defaultValue;
    }

    public int getIntegerProperty(String key, int defaultValue) {
        Integer value = (Integer)this.getProperty(key);
        return value != null ? value : defaultValue;
    }

    public float getFloatProperty(String key, float defaultValue) {
        Float value = (Float)this.getProperty(key);
        return value != null ? value.floatValue() : defaultValue;
    }

    public double getDoubleProperty(String key, double defaultValue) {
        Double value = (Double)this.getProperty(key);
        return value != null ? value : defaultValue;
    }

    public long getLongProperty(String key, long defaultValue) {
        Long value = (Long)this.getProperty(key);
        return value != null ? value : defaultValue;
    }
}

