/*
 * Decompiled with CFR 0.152.
 */
package oracle.annotation.logging.processor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.annotation.logging.processor.BundleDescriptor;
import oracle.annotation.logging.processor.Util;

public class ClassAnnotator {
    private static final String ANNOTATION_SUFFIX = ".anno";
    private static String fileName;
    private static List<String> lines;
    private static List<String> appends;
    private static int lastImportLine;
    private static int lastPublicLine;
    private static int countPublicSinceAnnotation;
    private static int annotationsSeen;
    private static boolean importMessageInfoSeen;
    private static boolean importSeveritySeen;
    private static String level;

    public static void main(String[] args) {
        if (args.length == 0) {
            ClassAnnotator.explain(null);
        }
        Util.setSrchome("./");
        Util.setSrcdirs(new String[]{"."});
        try {
            ClassAnnotator.processFiles(args, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            ClassAnnotator.explain("while adding method-level annotation to source file: " + e);
        }
    }

    public static List<String> processFiles(String[] fileNames, HashMap<String, BundleDescriptor> bundles) throws IOException {
        ArrayList<String> toDo = new ArrayList<String>();
        for (int i = 0; i < fileNames.length; ++i) {
            int count;
            fileName = fileNames[i];
            String outFileName = fileName + ANNOTATION_SUFFIX;
            File inFile = new File(fileName);
            File outFile = new File(outFileName);
            BundleDescriptor bd = null;
            if (bundles != null && (bd = bundles.get(fileName)) == null) {
                System.out.println("WARNING: unable to determine bundle associated with " + Util.getShortFileName(fileName));
            }
            if ((count = ClassAnnotator.annotateFile(inFile, bd)) > 0) {
                ClassAnnotator.writeFile(outFile);
                System.out.println("INFO: generated " + Util.getShortFileName(outFileName) + " with " + count + (annotationsSeen == 0 ? "" : " additional") + " annotation" + (count == 1 ? "" : "s") + ".");
                if (!inFile.canWrite()) {
                    toDo.add("ade co -c \"Added " + count + " @MessageInfo() annotation" + (count == 1 ? "" : "s") + ".\" " + Util.getShortFileName(fileName));
                }
                toDo.add("mv " + Util.getShortFileName(outFileName) + " " + Util.getShortFileName(fileName));
                if (bd == null) continue;
                bd.addWarning("<code>" + Util.getShortFileName(fileName) + "</code> may be missing up to " + count + " additional <code>@MessageInfo()</code> annotations. Please ensure that these are added.");
                continue;
            }
            if (annotationsSeen != 0) continue;
            System.out.println("WARNING: " + Util.getShortFileName(fileName) + " does not appear to be constructing messages using java.util.logging.Level. " + (bd == null ? "" : "Check the @RegistryInfo(invoke=\"...\") annotation on " + bd.getQualifiedName() + "."));
            if (bd == null) continue;
            bd.addError("<code>" + Util.getShortFileName(fileName) + "</code> was listed as a file that contains " + "the <code>@MessageInfo()</code> annotations for this resouce bundle. " + "I did not see these annotations. Nor did I see candidate code for these annotations. " + "Please ensure that you have referenced the correct class in the " + "<code>@RegistryInfo(invoke=\"...\")</code> annotation on " + bd.getQualifiedName() + ".");
        }
        return toDo;
    }

    private static void explain(String message) {
        if (message != null && !message.equals("")) {
            System.out.println("ERROR: " + message);
        }
        System.out.println("Usage: java oracle.annotation.logging.ClassAnnotator <file1>.java ...");
        System.out.println("   This tool attempts to determine @MessageInfo annotation at the method level.");
        if (message != null && !message.equals("")) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    private static int annotateFile(File in, BundleDescriptor bd) throws IOException {
        String line;
        int annotated = 0;
        LineNumberReader lnr = new LineNumberReader(new FileReader(in));
        lastImportLine = 0;
        lastPublicLine = 0;
        annotationsSeen = 0;
        importMessageInfoSeen = false;
        importSeveritySeen = false;
        countPublicSinceAnnotation = 2;
        lines = new ArrayList<String>();
        appends = new ArrayList<String>();
        lines.add(null);
        while ((line = lnr.readLine()) != null) {
            lines.add(line);
        }
        ArrayList<String> constants = new ArrayList<String>();
        if (bd != null) {
            String[] otherKeys = bd.getUnregisteredKeys();
            for (int i = 0; i < otherKeys.length; ++i) {
                String keyConstant = bd.getKeyConstant(otherKeys[i]);
                constants.add("\"" + otherKeys[i] + "\"");
                if (keyConstant == null) continue;
                constants.add(keyConstant);
            }
        }
        for (int i = 1; i < lines.size(); ++i) {
            String key;
            String trimmed = lines.get(i).trim();
            if (trimmed.startsWith("import ")) {
                lastImportLine = i;
                if (trimmed.startsWith("import oracle.annotation.logging.MessageInfo") || trimmed.startsWith("import oracle.annotation.logging.MessageInfoCompileTime")) {
                    importMessageInfoSeen = true;
                } else if (trimmed.startsWith("import oracle.annotation.logging.Severity")) {
                    importSeveritySeen = true;
                } else if (trimmed.startsWith("import oracle.annotation.logging.*")) {
                    importMessageInfoSeen = true;
                    importSeveritySeen = true;
                }
            }
            if (trimmed.startsWith("public ")) {
                lastPublicLine = i;
                ++countPublicSinceAnnotation;
            }
            if (trimmed.startsWith("@MessageInfo(") || trimmed.startsWith("@MessageInfoCompileTime(")) {
                countPublicSinceAnnotation = 0;
                ++annotationsSeen;
            }
            if ((key = ClassAnnotator.checkForSeverity(i)) == null || bd != null && !constants.contains(key) || !ClassAnnotator.annotate(key, bd)) continue;
            ++annotated;
        }
        if (!(annotated <= 0 || importMessageInfoSeen && importSeveritySeen)) {
            String app = "\n";
            if (!importMessageInfoSeen) {
                app = app + "import oracle.annotation.logging.MessageInfo;\n";
            }
            if (!importSeveritySeen) {
                app = app + "import oracle.annotation.logging.Severity;\n";
            }
            appends.set(lastImportLine, app);
        }
        return annotated;
    }

    private static String checkForSeverity(int i) {
        int pos = lines.get(i).indexOf("Level.");
        if (pos >= 0) {
            String invoke = lines.get(i).substring(pos + "Level.".length()).trim();
            if (i + 1 < lines.size()) {
                invoke = invoke + " " + lines.get(i + 1).trim();
            }
            if (i + 2 < lines.size()) {
                invoke = invoke + " " + lines.get(i + 2).trim();
            }
            if ((pos = invoke.indexOf(",")) >= 0 && Util.isLevel(level = invoke.substring(0, pos).trim())) {
                invoke = invoke.substring(pos + 1);
                return Util.getFirstToken(invoke);
            }
        }
        return null;
    }

    private static boolean annotate(String key, BundleDescriptor bd) {
        if (countPublicSinceAnnotation <= 1) {
            if (bd != null) {
                bd.addError(Util.getShortFileName(fileName) + ":" + lastPublicLine + ": " + "constructs a message with Level." + level + " and key " + key + ". This is an unregistered message. " + "If you want to register this message, you will need to do so " + "by using the <code>@MessageInfo()</code> annotation against " + "a different method.");
            }
            return false;
        }
        int pos = lines.get(lastPublicLine).indexOf("public");
        String indent = lines.get(lastPublicLine).substring(0, pos);
        StringBuffer sb = new StringBuffer();
        sb.append(indent);
        sb.append("@MessageInfo(\n");
        sb.append(indent);
        sb.append("    id       = " + key + ",\n");
        if (level.equals("SEVERE") || level.equals("INCIDENT_ERROR")) {
            sb.append(indent);
            sb.append("    severity = Severity." + level + ",\n");
            sb.append(indent);
            sb.append("    cause    = \"edit_cause\",\n");
            sb.append(indent);
            sb.append("    action   = \"edit_action\"\n");
        } else {
            sb.append(indent);
            sb.append("    severity = Severity." + level + "\n");
        }
        sb.append(indent);
        sb.append(")");
        if (lastPublicLine > appends.size()) {
            for (int i = appends.size(); i < lastPublicLine; ++i) {
                appends.add(null);
            }
        }
        appends.set(lastPublicLine - 1, sb.toString());
        return true;
    }

    private static void writeFile(File f) throws IOException {
        PrintStream ps = new PrintStream(new FileOutputStream(f));
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (line != null) {
                ps.println(line);
            }
            if (i >= appends.size() || (line = appends.get(i)) == null) continue;
            ps.println(line);
        }
        ps.close();
    }
}

