/*
 * Decompiled with CFR 0.152.
 */
package oracle.annotation.logging.processor;

import com.sun.tools.javadoc.Main;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.annotation.logging.MessageInfo;
import oracle.annotation.logging.MessageInfoCompileTime;
import oracle.annotation.logging.RegistryInfo;
import oracle.annotation.logging.processor.AnnotationsProcessor;
import oracle.annotation.logging.processor.BundleDescriptor;
import oracle.annotation.logging.processor.ClassAnnotator;
import oracle.annotation.logging.processor.GoFishing;
import oracle.annotation.logging.processor.Merge;
import oracle.annotation.logging.processor.MessageDescriptor;
import oracle.annotation.logging.processor.PreJdk5AnnotationsProcessor;
import oracle.annotation.logging.processor.Util;

public class BundleProcessor {
    public static final String VERSION = "0.80";
    public static final String DATE = "04/24/2007";
    public static final String HOME_PAGE = "http://stjpg.us.oracle.com/Wiki.jsp?page=MessageBundleHowto";
    private static List<Integer> products = new ArrayList<Integer>();
    private static int xmlMessageEntries = 0;
    private static String wptgFileName;
    private static String component;
    private static String classpath;
    private static String outdir;
    private static String[] javadocArguments;
    private static List<String> messageFiles;

    public static void main(String[] args) {
        if (args.length > 1 && args[0].equalsIgnoreCase("-merge")) {
            Merge merge = new Merge();
            String[] restArgs = new String[args.length - 2];
            for (int i = 2; i < args.length; ++i) {
                restArgs[i - 2] = args[i];
            }
            merge.run(args[1], restArgs);
            return;
        }
        BundleProcessor.parseArguments(args);
        if (Util.getVerbose()) {
            System.out.print("INFO: Component " + component + ", source under ");
            String[] dirs = Util.getSrcdirs();
            for (int i = 0; i < dirs.length; ++i) {
                System.out.print(Util.getSrchome() + "/" + dirs[i]);
                if (i >= dirs.length - 1) continue;
                System.out.print(", ");
            }
            System.out.println();
        }
        String[] bundles = null;
        try {
            BundleProcessor.parseWptgFile();
            if (Util.getCheckWptg()) {
                System.exit(0);
            }
            bundles = messageFiles.toArray(new String[0]);
        }
        catch (IOException ioe) {
            System.out.println("ERROR: unable to read WPTG file " + wptgFileName + ": " + ioe + "\n       Annotation processing stopped.");
            System.exit(1);
        }
        if (bundles.length == 0) {
            System.out.println("WARNING: Component " + component + " has no bundles defined in " + wptgFileName + " - annotation processing skipped.");
            System.exit(0);
        }
        BundleDescriptor[] descriptors = BundleProcessor.getBundleDescriptors(bundles);
        descriptors = BundleProcessor.sortBundles(descriptors);
        HashMap<String, BundleDescriptor> mapInvokeToBundle = new HashMap<String, BundleDescriptor>();
        ArrayList<String> sourceFiles = new ArrayList<String>();
        for (BundleDescriptor bd : descriptors) {
            if (bd.getBundle() == null) continue;
            for (String f : bd.getInvoke()) {
                mapInvokeToBundle.put(f, bd);
                sourceFiles.add(f);
            }
        }
        String[] messageAnnotationFiles = sourceFiles.toArray(new String[0]);
        HashMap<String, AnnotationsProcessor.Entry[]> result = BundleProcessor.executeJavadoc(messageAnnotationFiles, new String[]{MessageInfo.class.getName(), MessageInfoCompileTime.class.getName()}, 6);
        for (String key : result.keySet()) {
            AnnotationsProcessor.Entry[] entries = result.get(key);
            BundleDescriptor bd = mapInvokeToBundle.get(key);
            if (bd == null) continue;
            for (AnnotationsProcessor.Entry entry : entries) {
                MessageDescriptor md = new MessageDescriptor(bd, entry);
            }
        }
        try {
            List<String> addAnnotationToFiles = ClassAnnotator.processFiles(messageAnnotationFiles, mapInvokeToBundle);
            if (addAnnotationToFiles.size() > 0) {
                System.out.println("INFO: Created modified sources with new annotations. Issue the following to replace the original files.");
                for (int i = 0; i < addAnnotationToFiles.size(); ++i) {
                    System.out.println(addAnnotationToFiles.get(i));
                }
            }
        }
        catch (IOException ioe) {
            System.out.println("ERROR: while checking on potentially missing @MessageInfo() annotations: " + ioe.toString());
        }
        if (Util.getFishing()) {
            HashMap<String, BundleDescriptor> unregistered = new HashMap<String, BundleDescriptor>();
            for (BundleDescriptor bd : descriptors) {
                String[] unregKeys;
                if (bd.getBundle() == null || bd.getProduct() <= 0) continue;
                for (String key : unregKeys = bd.getUnregisteredKeys()) {
                    unregistered.put(key, bd);
                    String cons = bd.getKeyConstant(key);
                    if (cons == null) continue;
                    unregistered.put(cons, bd);
                }
            }
            if (unregistered.size() > 0) {
                int i;
                int base = Util.getSrcdirs().length;
                String[] dirs = new String[base + Util.getResdirs().length];
                for (i = 0; i < base; ++i) {
                    dirs[i] = Util.getSrcdirs()[i];
                }
                for (i = 0; i < Util.getResdirs().length; ++i) {
                    dirs[base + i] = Util.getResdirs()[i];
                }
                String[] roots = new String[dirs.length];
                for (int i2 = 0; i2 < dirs.length; ++i2) {
                    roots[i2] = Util.getCanonicalFileName(Util.getSrchome() + "/" + dirs[i2]);
                }
                GoFishing.goFishing(roots, unregistered);
            }
        }
        try {
            BundleProcessor.printBundles(descriptors);
        }
        catch (IOException ioe) {
            System.out.println("ERROR: unable to write error registry bundles: " + ioe);
            System.exit(1);
        }
        BundleDescriptor.Stats stats = new BundleDescriptor.Stats();
        for (BundleDescriptor bd : descriptors) {
            stats.addBundle(bd);
        }
        if (stats.hadErrors()) {
            System.out.println("WARNING: message bundles require work - " + stats.toString());
        }
    }

    private static void parseWptgFile() throws IOException {
        String line;
        if (wptgFileName == null || wptgFileName.equals("")) {
            return;
        }
        File wptgFile = new File(wptgFileName);
        LineNumberReader lr = new LineNumberReader(new FileReader(wptgFile));
        String directory = "";
        while ((line = lr.readLine()) != null) {
            String msgFileName;
            File msgFile;
            String lt = line.trim();
            int pos1 = line.indexOf(":");
            int pos2 = line.indexOf(" ");
            if (lt.equals("") || lt.startsWith("#") || 0 < pos1 && pos1 < pos2) continue;
            if (lt.indexOf("/") >= 0) {
                directory = lt;
                if (directory.indexOf("%j") >= 0 || directory.endsWith(".java")) {
                    System.out.println("WARNING " + wptgFile + ":" + lr.getLineNumber() + ": I read this line as a directory entry, " + "but it appears to be a file entry. Please check!");
                    System.out.println("The line contains the following:");
                    System.out.println(directory);
                }
                if (!directory.endsWith("/")) continue;
                directory = directory.substring(0, directory.length() - 1);
                continue;
            }
            if (lt.indexOf("%j") < 0 || !lt.trim().endsWith(".java")) continue;
            pos1 = lt.indexOf(" ");
            if (pos1 > 0) {
                lt = lt.substring(0, pos1);
            }
            lt = lt.replace("%j", "");
            String verz = null;
            int pos = lt.lastIndexOf("/");
            if (line.startsWith(" ") || line.startsWith("\t")) {
                verz = directory;
            } else {
                verz = lt.substring(0, pos);
                lt = lt.substring(pos + 1);
            }
            boolean filterMatch = false;
            List<String> filterFiles = Util.getFilterFile();
            if (filterFiles != null) {
                String wptgEntry = "/" + verz + "/" + lt;
                for (String fil : filterFiles) {
                    if (!fil.endsWith(wptgEntry)) continue;
                    filterMatch = true;
                    break;
                }
            }
            boolean found = false;
            if (Util.getCheckWptg()) {
                if (filterFiles != null && !filterMatch) {
                    System.out.println("WARNING: " + wptgFileName + ":" + lr.getLineNumber() + ":  entry " + verz + "/" + lt + " appears to be obsolete. It is not matched by any entry in " + Util.getFilterFileName() + ".");
                }
            } else {
                for (String dir : Util.getSrcdirs()) {
                    if (!verz.startsWith(dir + "/")) continue;
                    found = true;
                }
                if (found && filterFiles != null && !filterMatch) {
                    found = false;
                    System.out.println("WARNING: " + wptgFileName + ":" + lr.getLineNumber() + ":  entry " + verz + "/" + lt + " appears to be obsolete and will be skipped. It is not matched by any entry in " + Util.getFilterFileName() + ".");
                }
            }
            if (!found) continue;
            if (Util.getVerbose()) {
                System.out.println("INFO: identified bundle " + Util.getShortFileName(Util.getSrchome() + "/" + verz + "/" + lt));
            }
            if ((msgFile = new File(msgFileName = Util.getSrchome() + "/" + verz + "/" + lt)).exists()) {
                messageFiles.add(msgFileName);
                continue;
            }
            System.out.println("SEVERE: " + verz + "/" + lt + " is listed in the WPTG file, but I am not able to access it. " + " You may need to adjust this at " + wptgFileName + ":" + lr.getLineNumber());
        }
        lr.close();
    }

    private static BundleDescriptor[] getBundleDescriptors(String[] bundles) {
        AnnotationsProcessor.Entry[] res;
        BundleDescriptor bd;
        int i;
        BundleDescriptor[] descriptors = new BundleDescriptor[bundles.length];
        for (int i2 = 0; i2 < bundles.length; ++i2) {
            descriptors[i2] = new BundleDescriptor(bundles[i2]);
        }
        HashMap<String, AnnotationsProcessor.Entry[]> results = BundleProcessor.executeJavadoc(bundles, new String[]{RegistryInfo.class.getName()}, 1);
        ArrayList<BundleDescriptor> jdk5AnnotationNotFound = new ArrayList<BundleDescriptor>();
        for (i = 0; i < descriptors.length; ++i) {
            bd = descriptors[i];
            AnnotationsProcessor.Entry[] entryArray = res = results == null ? null : results.get(bd.getFileName());
            if (res != null && res.length > 0) {
                bd.processAnnotations(res);
                continue;
            }
            jdk5AnnotationNotFound.add(bd);
        }
        results = BundleProcessor.executeFakeJavadoc(jdk5AnnotationNotFound, new String[]{RegistryInfo.class.getName()}, 1);
        for (i = 0; i < jdk5AnnotationNotFound.size(); ++i) {
            bd = (BundleDescriptor)jdk5AnnotationNotFound.get(i);
            res = results.get(bd.getFileName());
            bd.processAnnotations(res);
        }
        return descriptors;
    }

    private static HashMap<String, AnnotationsProcessor.Entry[]> executeJavadoc(String[] args, String[] annotationTag, int annotationLevel) {
        int i;
        int i2;
        if (args.length == 0) {
            return new HashMap<String, AnnotationsProcessor.Entry[]>();
        }
        int base = Util.getSrcdirs().length;
        String[] dirs = new String[base + Util.getResdirs().length];
        for (i2 = 0; i2 < base; ++i2) {
            dirs[i2] = Util.getSrcdirs()[i2];
        }
        for (i2 = 0; i2 < Util.getResdirs().length; ++i2) {
            dirs[base + i2] = Util.getResdirs()[i2];
        }
        String srcdirs = "";
        for (int i3 = 0; i3 < dirs.length; ++i3) {
            srcdirs = srcdirs + Util.getCanonicalFileName(Util.getSrchome() + "/" + dirs[i3]);
            if (i3 >= dirs.length - 1) continue;
            srcdirs = srcdirs + ":";
        }
        String[] initialArgs = new String[]{"-doclet", AnnotationsProcessor.class.getName(), "-sourcepath", srcdirs, "-quiet"};
        String[] javadocArgs = new String[initialArgs.length + args.length];
        for (i = 0; i < initialArgs.length; ++i) {
            javadocArgs[i] = initialArgs[i];
        }
        for (i = 0; i < args.length; ++i) {
            javadocArgs[initialArgs.length + i] = args[i];
        }
        AnnotationsProcessor.setFilter(annotationTag);
        AnnotationsProcessor.setAnnotationLevel(annotationLevel);
        if (Util.getVerbose()) {
            System.out.print("INFO: javadoc");
            for (i = 0; i < javadocArgs.length; ++i) {
                System.out.print(" " + javadocArgs[i]);
            }
            System.out.println();
        }
        int status = Main.execute((String[])javadocArgs);
        if (Util.getVerbose()) {
            System.out.println("       returns " + status);
        }
        return AnnotationsProcessor.getResults();
    }

    private static HashMap<String, AnnotationsProcessor.Entry[]> executeFakeJavadoc(List<BundleDescriptor> args, String[] annotationTag, int annotationLevel) {
        if (args.size() == 0) {
            return new HashMap<String, AnnotationsProcessor.Entry[]>();
        }
        PreJdk5AnnotationsProcessor.setFilter(annotationTag);
        PreJdk5AnnotationsProcessor.setAnnotationLevel(annotationLevel);
        String[] files = new String[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            files[i] = args.get(i).getFileName();
        }
        PreJdk5AnnotationsProcessor.process(files);
        return PreJdk5AnnotationsProcessor.getResults();
    }

    private static BundleDescriptor[] sortBundles(BundleDescriptor[] bundles) {
        boolean done = false;
        while (!done) {
            done = true;
            for (int i = 0; i < bundles.length - 1; ++i) {
                if (bundles[i].getProduct() <= bundles[i + 1].getProduct()) continue;
                BundleDescriptor tmp = bundles[i];
                bundles[i] = bundles[i + 1];
                bundles[i + 1] = tmp;
                done = false;
            }
        }
        int product = -1;
        for (int i = 0; i < bundles.length; ++i) {
            if (bundles[i].getProduct() == product) continue;
            products.add(new Integer(bundles[i].getProduct()));
            product = bundles[i].getProduct();
        }
        return bundles;
    }

    private static void openProduct(int idx, BundleDescriptor[] bds, StringBuffer xmlPrint, PrintStream htmlPrint) {
        String productName = Util.getProductName(bds[idx].getProduct());
        xmlPrint.append("   <component number='" + bds[idx].getProduct() + "'>");
        xmlPrint.append("\n");
        htmlPrint.println("<A name=\"prod-" + bds[idx].getProduct() + "\">" + "<H2>Product " + bds[idx].getProduct() + (productName == null ? "" : " - " + productName) + "</H2></A>");
        htmlPrint.println("<h4>Bundle Index</h4>");
        int totalGood = 0;
        int totalSkipped = 0;
        int totalUnregistered = 0;
        htmlPrint.println("<ul>");
        for (int i = idx; i < bds.length && bds[idx].getProduct() == bds[i].getProduct(); ++i) {
            String bundle = bds[i].getQualifiedName();
            String file = bds[i].getShortFileName();
            int unregistered = bds[i].getUnregisteredKeys().length;
            htmlPrint.print("<li><a href=\"#bundle:" + bundle + "\">" + bundle + "</a> ");
            htmlPrint.print(bds[i].getRegisteredSize() + " message" + (bds[i].getRegisteredSize() == 1 ? "" : "s"));
            if (unregistered > 0) {
                htmlPrint.print(" (and " + unregistered + " unreferenced entries)");
            }
            htmlPrint.println("</li>");
            if (bds[i].isMarked()) {
                totalGood += bds[i].getRegisteredSize();
            } else {
                totalSkipped += bds[i].getRegisteredSize();
            }
            totalUnregistered += unregistered;
        }
        htmlPrint.println("</ul>");
        htmlPrint.println("<b>Total " + totalGood + " message" + (totalGood == 1 ? "" : "s") + ".</b><br>");
        if (totalSkipped > 0) {
            htmlPrint.println("<i>Note that " + totalSkipped + " more messages were ignored, since their bundle does not carry the ODL marker.</i><br>");
        }
        if (totalUnregistered > 0) {
            htmlPrint.println("An additional  " + totalUnregistered + " entries were found in these bundles. " + "Since they are not referenced by <code>@MessageInfo()</code> code annotations, " + "they were ignored.<br>");
            htmlPrint.println("It is suggested that you check whether these entries contain messages that should be registered, or if these contain text that does not constitute a message. In the latter case, you can use a <code>@MessageInfo(severity=Severity.SKIP)</code> annotation to indicate entries that should not be considered messages.<br>");
        }
    }

    private static int printProduct(int idx, BundleDescriptor[] bds, StringBuffer xmlPrint, PrintStream htmlPrint) {
        int count = 0;
        int i = idx;
        while (i < bds.length && bds[i].getProduct() == bds[idx].getProduct()) {
            try {
                String klasse = bds[i].getQualifiedName();
                String file = bds[i].getShortFileName();
                String entries = bds[i].toXML(8);
                if (entries != "" && !entries.trim().equals("")) {
                    xmlPrint.append(entries);
                    xmlPrint.append("\n");
                    ++xmlMessageEntries;
                }
                htmlPrint.println("<a name=\"bundle:" + klasse + "\"><h2>Bundle " + klasse + "</h2></a>");
                htmlPrint.println("Contents from file <code>" + file + "</code></br>");
                if (bds[i].getBundleConstantsFileName() != null) {
                    htmlPrint.println("Symbolic constants for bundle keys defined in <code>" + Util.getShortFileName(bds[i].getBundleConstantsFileName()) + "</code></br>");
                }
                htmlPrint.print("Bundle contains " + bds[i].getRegisteredSize() + " message" + (bds[i].getRegisteredSize() == 1 ? "" : "s"));
                if (bds[i].getUnregisteredKeys().length > 0) {
                    htmlPrint.print(" and " + bds[i].getUnregisteredKeys().length + " additional entries not referenced by <code>@MessageInfo()</code> annotations.");
                }
                htmlPrint.println("</br>");
                htmlPrint.println("Messages on this bundle have been registered from the following classes:<br>");
                for (String f : bds[i].getInvoke()) {
                    htmlPrint.println("&nbsp;&nbsp;<code>" + Util.getShortFileName(f) + "</code><br>");
                }
                htmlPrint.println(bds[i].toHTML());
            }
            catch (Exception exn) {
                exn.printStackTrace();
            }
            ++i;
            ++count;
        }
        return count;
    }

    private static void closeProduct(BundleDescriptor bd, PrintStream xmlPrint, StringBuffer xmlMessages, PrintStream htmlPrint) {
        if (xmlMessageEntries > 0) {
            xmlPrint.print(xmlMessages.toString());
            xmlPrint.println("   </component>");
        }
        xmlMessages.setLength(0);
        xmlMessageEntries = 0;
    }

    private static void printBundles(BundleDescriptor[] bundles) throws IOException {
        int i;
        File htmlFile = new File(outdir + "/" + component + ".html");
        File xmlFile = new File(outdir + "/" + component + ".xml");
        PrintStream htmlPrint = new PrintStream(new FileOutputStream(htmlFile));
        PrintStream xmlPrint = new PrintStream(new FileOutputStream(xmlFile));
        StringBuffer xmlPrintBuffer = new StringBuffer();
        xmlPrint.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xmlPrint.println("<messages>");
        htmlPrint.println("<html>");
        htmlPrint.println("<head><title>Error Messages for " + component + "</title></head>");
        htmlPrint.println("<body>");
        htmlPrint.println("<H1>Error Messages for " + component + "</H1>");
        htmlPrint.print("Source root for source component " + component + ": ");
        String[] dirs = Util.getSrcdirs();
        for (i = 0; i < dirs.length; ++i) {
            htmlPrint.print("<code>$ADE_VIEW_ROOT/" + dirs[i] + "</code>");
            if (i >= dirs.length - 1) continue;
            htmlPrint.print(", ");
        }
        htmlPrint.println("<br>");
        htmlPrint.println("<b>XML error registry data:</b> ");
        htmlPrint.println("<code><a href=\"" + component + ".xml\">" + component + ".xml</a></code><br>");
        htmlPrint.println("Please register these messages at <A href=\"http://aseng.us.oracle.com/portal/pls/portal/REGAPP.ERRORMSG.main?app=diag\">http://aseng.us.oracle.com/portal/pls/portal/REGAPP.ERRORMSG.main?app=diag</a>");
        htmlPrint.println("<h3>Product Index</h3>");
        htmlPrint.println("<ul>");
        for (i = 0; i < products.size(); ++i) {
            if (products.get(i) <= 0) continue;
            String productName = Util.getProductName(products.get(i));
            htmlPrint.println("<li><a href=\"#prod-" + products.get(i) + "\">" + products.get(i) + (productName == null ? "" : " - " + productName) + "</a></li>");
        }
        htmlPrint.println("</ul>");
        int product = -1;
        boolean productOpen = false;
        int i2 = 0;
        while (i2 < bundles.length) {
            if (bundles[i2].getProduct() == -1) {
                ++i2;
                continue;
            }
            if (bundles[i2].getProduct() == 0) {
                htmlPrint.println("<h2>Bundle " + bundles[i2].getQualifiedName() + "</h2>");
                if (bundles[i2].getBundle() == null) {
                    htmlPrint.println("<H3>ACTION / TODO ITEM</H3>\n<b>Unable to load class <code>" + bundles[i2].getQualifiedName() + "</code> defined in source file <code>" + bundles[i2].getShortFileName() + "</code></b><br>");
                    htmlPrint.println("Please ensure that this is available on the classpath.<p>");
                } else {
                    htmlPrint.println("<b>NOTE:</b> File <code>" + bundles[i2].getShortFileName() + "</code> does not have any <code>@RegistryInfo()</code> annotation.<br>");
                    htmlPrint.println("This file is skipped with respect to processing of error registry information.<br>");
                    htmlPrint.println("Insert an annotation <code>@RegistryInfo(product=Product.SKIP)</code> to suppress this message.<p>");
                    htmlPrint.println();
                }
                ++i2;
                continue;
            }
            if (bundles[i2].getProduct() != product) {
                if (productOpen) {
                    BundleProcessor.closeProduct(bundles[i2 - 1], xmlPrint, xmlPrintBuffer, htmlPrint);
                }
                BundleProcessor.openProduct(i2, bundles, xmlPrintBuffer, htmlPrint);
                productOpen = true;
            }
            i2 += BundleProcessor.printProduct(i2, bundles, xmlPrintBuffer, htmlPrint);
        }
        if (productOpen) {
            BundleProcessor.closeProduct(bundles[bundles.length - 1], xmlPrint, xmlPrintBuffer, htmlPrint);
            System.out.println("INFO: Generated XML registry in " + xmlFile);
            xmlPrint.println("</messages>");
            xmlPrint.close();
        } else {
            xmlPrint.close();
            xmlFile.delete();
            System.out.println("INFO: Did not find any registered messages. No XML registry file was generated.");
        }
        htmlPrint.println("</body></html>");
        htmlPrint.close();
        System.out.println("INFO: Generated HTML report in  " + htmlFile);
    }

    public static void explain(String message) {
        if (message != null && !message.equals("")) {
            System.out.println("ERROR: " + message);
        }
        System.out.println("Message Bundle Registry Tool, version 0.80, 04/24/2007");
        System.out.println("   For more information, see also http://stjpg.us.oracle.com/Wiki.jsp?page=MessageBundleHowto");
        System.out.println("Synopsis: java -jar .../annotation.jar <options>");
        System.out.println("   Perform compile-time evaluation of registry-related annotations.");
        System.out.println("Or: java -jar .../annotation.jar -merge <dest-XML-file> <XML-file_or_dir_1> ... <XML-file_or_dir_n>");
        System.out.println("   Merge bundle registration XML files  (or dirs with XML files) into a single file <dest-XML-file>");
        System.out.println("Where <options> consist of the following:");
        System.out.println("    -adeview   <Value of $ADE_VIEW_ROOT env var> - required option");
        System.out.println("    -wptg      <Fully qualified location of wptg file in this label> - required option");
        System.out.println("    -srcdir    <Root dir of source tree relative to -adeview for bundles & sources> - required option");
        System.out.println("    -component <Name of source component. Should be unique in the label.> - required option");
        System.out.println("    -outdir    <Name of output dir for XML, HTML output. - required option");
        System.out.println("    -fishing   - ask tool to fish for source lines that may construct (unregistered) messages.");
        System.out.println("    -addFile   <Bundle source file> - add a message bundle that is not in");
        System.out.println("                 the -wptg file for processing. Can be specified more than once.");
        System.out.println("    -verbose   - turns on verbose output,  -debug for additional info");
        System.out.println("    -javadoc   - must be the last option. All arguments after this are");
        System.out.println("                 passed directly to javadoc.");
        System.out.println("Note: the -srcdir directory must be under $ADE_VIEW_ROOT and specified relative to $ADE_VIEW_ROOT");
        System.out.println("      This setting tells us which entries in the wptg file we need to look for.");
        if (message != null && !message.equals("")) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    private static void parseArguments(String[] args) {
        if (args.length == 0) {
            BundleProcessor.explain(null);
        }
        for (int i = 0; i < args.length; ++i) {
            try {
                if (args[i].equalsIgnoreCase("-adeview") || args[i].equalsIgnoreCase("-srchome")) {
                    Util.setSrchome(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-wptg")) {
                    wptgFileName = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-filter")) {
                    Util.setFilterFile(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-checkwptg")) {
                    Util.setCheckWptg(true);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-srcdir")) {
                    Util.setSrcdir(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-outdir")) {
                    outdir = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-component")) {
                    component = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-v") || args[i].equalsIgnoreCase("-verbose")) {
                    Util.setVerbose(true);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-noverbose")) {
                    Util.setVerbose(false);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-javadoc")) {
                    javadocArguments = new String[args.length - ++i];
                    int j = i;
                    while (j < args.length) {
                        BundleProcessor.javadocArguments[j] = args[i];
                        ++j;
                        ++i;
                    }
                    continue;
                }
                if (args[i].equalsIgnoreCase("-addfile")) {
                    String files = args[++i];
                    while (!files.equals("")) {
                        int pos = files.indexOf(":");
                        String f = null;
                        if (pos > 0) {
                            f = files.substring(0, pos).trim();
                            files = files.substring(pos + 1);
                        } else {
                            f = files.trim();
                            files = "";
                        }
                        if (f.equals("")) continue;
                        messageFiles.add(f);
                    }
                    continue;
                }
                if (args[i].equalsIgnoreCase("-classpath")) {
                    classpath = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-debug")) {
                    Util.setDebug(true);
                    Util.setVerbose(true);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-fishing")) {
                    Util.setFishing(true);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-nofishing")) {
                    Util.setFishing(false);
                    continue;
                }
                BundleProcessor.explain("Unrecognized argument: " + args[i]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aob) {
                BundleProcessor.explain("Missing argument for option " + args[args.length - 1]);
            }
        }
        if (Util.getSrchome() == null) {
            BundleProcessor.explain("Missing -adeview option.");
        } else if (wptgFileName == null && messageFiles.size() == 0) {
            BundleProcessor.explain("Missing -wptg option or -addFile <file>.java designation.");
        } else if (Util.getSrcdirs() == null) {
            BundleProcessor.explain("Missing -srcdir option.");
        } else if (component == null) {
            BundleProcessor.explain("Missing -component option.");
        } else if (outdir == null) {
            BundleProcessor.explain("Must specify -outdir option.");
        }
        if (Util.getSrchome().endsWith("/")) {
            Util.setSrchome(Util.getSrchome().substring(0, Util.getSrchome().length() - 1));
        }
        if (Util.getDebug() && classpath != null) {
            System.out.println(BundleProcessor.class.getName() + " classpath is: " + classpath);
        }
        try {
            Class<?> klasse = Class.forName("com.sun.javadoc.MethodDoc");
        }
        catch (Exception e) {
            BundleProcessor.explain("You need to ensure that tools.jar (typically located in $JAVA_HOME/lib/tools.jar) is in your classpath. - " + e.toString());
        }
        if (Util.getCheckWptg() && Util.getFilterFile() == null) {
            BundleProcessor.explain("If you specify the -checkwptg option, you must also specify -filter <filterFile> with a valid filter file.");
        }
    }

    static {
        javadocArguments = new String[0];
        messageFiles = new ArrayList<String>();
    }
}

