/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.security.redaction.controller;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.EditorActionControl;
import oracle.dbtools.security.redaction.dialogs.BaseRedactPolicyAction;
import oracle.dbtools.security.redaction.dialogs.ExpressionActionDialog;
import oracle.dbtools.security.redaction.dialogs.RedactConstants;
import oracle.dbtools.security.redaction.generator.RedactCodeGeneratorController;
import oracle.dbtools.security.redaction.model.RedactModel;

public class RedactController
implements PropertyChangeListener {
    RedactModel redactModel = null;
    RedactCodeGeneratorController codeController = null;
    ActionDialog actionDialog = null;

    public RedactController(RedactModel redactModel) {
        this.redactModel = redactModel;
        this.codeController = new RedactCodeGeneratorController(redactModel);
    }

    public RedactController(RedactModel redactModel, ActionDialog actionDialog) {
        this.redactModel = redactModel;
        this.actionDialog = actionDialog;
        this.codeController = new RedactCodeGeneratorController(redactModel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getNewValue();
        Object object2 = propertyChangeEvent.getOldValue();
        String string = propertyChangeEvent.getPropertyName();
        String string2 = propertyChangeEvent.getSource().getClass().getName();
        if (string == null) {
            System.out.println("propertyName = null.");
            return;
        }
        String string3 = ((ActionControl.Value)propertyChangeEvent.getNewValue()).get();
        this.updateModel(string, string3);
    }

    public String genCode(String string) {
        String string2 = null;
        if (string.equals("redaction_code_create")) {
            string2 = this.codeController.getCreateRedactScript();
        }
        if (string.equals("redaction_code_alter")) {
            string2 = this.codeController.getAlterRedactScript();
        }
        if (string.equals("redaction_code_drop")) {
            string2 = this.codeController.getDropRedactScript();
        }
        if (string.equals("redaction_code_enable_disable")) {
            string2 = this.codeController.getEnableDisableRedactScript();
        }
        return string2;
    }

    public void updateModel(String string, Object object) {
        String string2;
        if (string == null) {
            return;
        }
        if (object instanceof String) {
            string2 = (String)object;
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
            if (string.equals("redaction_policy_name")) {
                this.redactModel.setPolicyName(string2);
            }
            if (string.equals("redaction_policy_description")) {
                this.redactModel.setPolicyDescription(string2);
            }
            if (string.equals("redaction_schema_name")) {
                this.redactModel.setSchemaName(string2);
            }
            if (string.equals("redaction_object_name")) {
                this.redactModel.setObjectName(string2);
            }
            if (string.equals("redaction_column_name")) {
                this.redactModel.setColumnName(string2);
            }
            if (string.equals("redaction_column_description")) {
                this.redactModel.setColumnDescription(string2);
            }
            if (string.equals("redaction_policy_enabled")) {
                this.redactModel.setEnabled(string2);
            }
            if (string.equals("redaction_expression")) {
                this.redactModel.setExpression(string2);
            }
            if (string.equals("redaction_function_type_card_panel")) {
                if (string2.equals(RedactConstants.REDACTION_FUNCTION_TYPES[4])) {
                    this.redactModel.setIsRegexp("true");
                } else {
                    this.redactModel.setIsRegexp("false");
                }
                this.redactModel.setFunctionType(string2);
            }
            if (string.equals("redaction_alter_action")) {
                this.redactModel.setActionType(string2);
            }
            if (string.equals("redaction_function_parameters_none")) {
                this.redactModel.setFunctionParameterNone(string2);
            }
            if (string.equals("redaction_function_parameters_full")) {
                this.redactModel.setFunctionParameterFull(string2);
            }
            if (string.equals("redaction_function_parameters_partial")) {
                this.redactModel.setFunctionParameterPartial(string2);
            }
            if (string.equals("redaction_function_parameters_random")) {
                this.redactModel.setFunctionParameterRandom(string2);
            }
            if (string.equals("redaction_regexp_pattern")) {
                this.redactModel.setRegexpPattern(string2);
            }
            if (string.equals("redaction_regexp_replace_string")) {
                this.redactModel.setRegexpReplaceString(string2);
            }
            if (string.equals("redaction_regexp_match_parameter")) {
                this.redactModel.setRegexpMatchParameter(string2);
            }
            if (string.equals("redaction_expression_icon")) {
                System.out.println("before invoke Dialog.");
                new ExpressionActionDialog().invoke(this.redactModel, this);
                System.out.println("after invoke Dialog.");
            }
        }
        if (object instanceof Integer) {
            string2 = ((Integer)object).toString();
            if (string.equals("redaction_regexp_position")) {
                this.redactModel.setRegexpPosition(string2);
            }
            if (string.equals("redaction_regexp_occurrence")) {
                this.redactModel.setRegexpOccurrence(string2);
            }
        }
    }

    public void setActionType(String string) {
        this.redactModel.setActionType(string);
    }

    public void setExpression(String string) {
        this.redactModel.setExpression(string);
    }

    public void setDefaultExpression() {
        this.redactModel.setDefaultExpression();
    }

    public void setAdvancedExpression(String string) {
        this.redactModel.setAdvancedExpression(string);
    }

    public void setPreviousAdvancedExpression() {
        this.redactModel.setAdvancedExpression(this.redactModel.getAdvancedExpression());
    }

    public void setExpressionType(String string) {
        this.redactModel.setExpressionType(string);
    }

    public void setOtherUser(String string) {
        this.redactModel.setOtherUser(string);
    }

    public void setUserEnv(String string) {
        this.redactModel.setUserEnv(string);
    }

    public void setConditionChoice(String string) {
        this.redactModel.setConditionChoice(string);
    }

    public void updateExpressionOnDialog() {
        EditorActionControl editorActionControl = ((BaseRedactPolicyAction)this.actionDialog).getExpressionEditorCtl();
        editorActionControl.enableUI(true);
        editorActionControl.setEditable(true);
        editorActionControl.set(this.redactModel.getExpression());
        editorActionControl.enableUI(false);
        editorActionControl.setEditable(false);
    }
}

