/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import oracle.ewt.painter.AbstractWrappingPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;

public class FixedSizePainter
extends AbstractWrappingPainter {
    public static final int WIDTH_UNFIXED = -1;
    public static final int HEIGHT_UNFIXED = -1;
    private int _width;
    private int _height;
    private boolean _isFloating;

    public FixedSizePainter(int n, int n2) {
        this(null, n, n2);
    }

    public FixedSizePainter(Painter painter, int n, int n2) {
        super(painter);
        this._width = n;
        this._height = n2;
        this._isFloating = painter != null && n == -1 || n2 == -1;
    }

    public Dimension getSize(PaintContext paintContext, int n, int n2) {
        Dimension dimension = this._isFloating ? super.getSize(paintContext, n, n2) : new Dimension(n, n2);
        this._adjustSize(dimension);
        return dimension;
    }

    public Dimension getPreferredSize(PaintContext paintContext) {
        Dimension dimension = this._isFloating ? super.getPreferredSize(paintContext) : new Dimension(1, 1);
        this._adjustSize(dimension);
        return dimension;
    }

    public Dimension getMinimumSize(PaintContext paintContext) {
        Dimension dimension = this._isFloating ? super.getMinimumSize(paintContext) : new Dimension(1, 1);
        this._adjustSize(dimension);
        return dimension;
    }

    public Dimension getMaximumSize(PaintContext paintContext) {
        Dimension dimension = this._isFloating ? super.getMaximumSize(paintContext) : new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
        this._adjustSize(dimension);
        return dimension;
    }

    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Dimension dimension = new Dimension(n3, n4);
        this._adjustSize(dimension);
        if (dimension.width > 0 && dimension.height > 0) {
            super.paint(paintContext, graphics, n, n2, dimension.width, dimension.height);
        }
    }

    public Painter getPainterAt(PaintContext paintContext, int n, int n2, int n3, int n4, Painter painter) {
        Dimension dimension = new Dimension(n, n2);
        this._adjustSize(dimension);
        return super.getPainterAt(paintContext, dimension.width, dimension.height, n3, n4, painter);
    }

    public int getRepaintFlags(PaintContext paintContext) {
        int n = super.getRepaintFlags(paintContext);
        if (!this._isFloating) {
            n &= 0xFFFFFF7F;
        }
        return n;
    }

    public int getInvalidateFlags(PaintContext paintContext) {
        int n = super.getInvalidateFlags(paintContext);
        if (!this._isFloating) {
            n &= 0xFFFFFF7F;
        }
        return n;
    }

    private void _adjustSize(Dimension dimension) {
        if (this._width != -1) {
            dimension.width = this._width;
        }
        if (this._height != -1) {
            dimension.height = this._height;
        }
    }
}

