/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import oracle.ewt.grid.Grid;
import oracle.ewt.popup.ToolTipManager;
import oracle.ewt.util.InputEventUtils;

public abstract class CellInputHandler {
    public boolean validateFocus(Grid grid, int n, int n2) {
        return true;
    }

    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        boolean bl;
        if (InputEventUtils.isLeftMouseButton(mouseEvent) && !(bl = grid.requestFocus(n, n2, mouseEvent))) {
            mouseEvent.consume();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent, Grid grid, int n, int n2) {
    }

    public void mouseReleased(MouseEvent mouseEvent, Grid grid, int n, int n2) {
    }

    public void mouseEntered(MouseEvent mouseEvent, Grid grid, int n, int n2) {
    }

    public void mouseExited(MouseEvent mouseEvent, Grid grid, int n, int n2) {
    }

    public void mouseDragged(MouseEvent mouseEvent, Grid grid, int n, int n2) {
    }

    public void mouseMoved(MouseEvent mouseEvent, Grid grid, int n, int n2) {
    }

    public void keyPressed(KeyEvent keyEvent, Grid grid, int n, int n2) {
        if (keyEvent.getKeyCode() == 113 && keyEvent.getModifiers() == 0) {
            grid.startCellEdit(n, n2);
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 112 && keyEvent.isControlDown() && grid.getToolTipValue() != null) {
            ToolTipManager.getToolTipManager().show(grid, grid.getColumnPosition(n), grid.getRowPosition(n2));
            keyEvent.consume();
            return;
        }
    }

    public void keyTyped(KeyEvent keyEvent, Grid grid, int n, int n2) {
    }

    public void keyReleased(KeyEvent keyEvent, Grid grid, int n, int n2) {
        if (keyEvent.getKeyCode() == 112 && keyEvent.isControlDown() && grid.getToolTipValue() != null) {
            keyEvent.consume();
            return;
        }
    }

    public void focusGained(AWTEvent aWTEvent, Grid grid, int n, int n2) {
    }

    public void focusLost(AWTEvent aWTEvent, Grid grid, int n, int n2) {
    }

    public Component getEditControl(Grid grid, int n, int n2) {
        return null;
    }

    public Rectangle getEditControlBounds(Grid grid, int n, int n2) {
        return null;
    }

    public boolean isDirty(Grid grid, int n, int n2) {
        return true;
    }

    public void startEdit(Grid grid, int n, int n2, Object object) {
    }

    public void cancelEdit(Grid grid, int n, int n2) {
    }

    public Object commitEdit(Grid grid, int n, int n2) {
        return grid.getDataSource().getData(n, n2);
    }
}

