/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import java.io.IOException;
import java.io.PrintStream;
import java.rmi.AccessException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import oracle.kv.AuthenticationFailureException;
import oracle.kv.KVVersion;
import oracle.kv.PasswordCredentials;
import oracle.kv.impl.admin.AdminFaultException;
import oracle.kv.impl.admin.CommandService;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.rep.MasterRepNodeStats;
import oracle.kv.impl.rep.RepNodeStatus;
import oracle.kv.impl.rep.admin.RepNodeAdmin;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.AdminLoginManager;
import oracle.kv.impl.security.login.LoginHandle;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.login.RepNodeLoginManager;
import oracle.kv.impl.security.util.KVStoreLogin;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.sna.StorageNodeStatus;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.FormatUtils;
import oracle.kv.impl.util.HostPort;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.impl.util.registry.RemoteAPI;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class Ping {
    public static final String COMMAND_NAME = "ping";
    public static final String COMMAND_DESC = "attempts to contact a store to get status of running services";
    public static final String JSON_FLAG = "-json";
    public static final String COMMAND_ARGS = CommandParser.getHostUsage() + " " + CommandParser.getPortUsage() + " " + CommandParser.getUserUsage() + "\n\t" + CommandParser.getSecurityUsage() + "\n\t" + CommandParser.optional("-json");

    public static void main(String[] args) throws RemoteException {
        TopoAndParams topoAndParams;
        class PingParser
        extends CommandParser {
            private boolean json = false;

            PingParser(String[] args1) {
                super(args1);
            }

            @Override
            public void usage(String errorMsg) {
                if (errorMsg != null) {
                    System.err.println(errorMsg);
                }
                System.err.println("Usage: java -jar KVHOME/lib/kvstore.jar ping\n\t" + COMMAND_ARGS);
                System.exit(-1);
            }

            @Override
            protected boolean checkArg(String arg) {
                if (arg.equals(Ping.JSON_FLAG)) {
                    this.json = true;
                    return true;
                }
                return false;
            }

            @Override
            protected void verifyArgs() {
                if (this.getHostname() == null) {
                    this.missingArg("-host");
                }
                if (this.getRegistryPort() == 0) {
                    this.missingArg("-port");
                }
            }
        }
        PingParser pp = new PingParser(args);
        pp.parseArgs();
        KVStoreLogin storeLogin = new KVStoreLogin(pp.getUserName(), pp.getSecurityFile());
        try {
            storeLogin.loadSecurityProperties();
        }
        catch (IllegalArgumentException iae) {
            System.err.println(iae.getMessage());
        }
        PasswordCredentials loginCreds = null;
        if (storeLogin.foundSSLTransport()) {
            storeLogin.prepareRegistryCSF();
            try {
                loginCreds = storeLogin.makeShellLoginCredentials();
            }
            catch (IOException ioe) {
                System.err.println("Failed to get login credentials: " + ioe.getMessage());
                return;
            }
        }
        if ((topoAndParams = Ping.getTopologyAndParams(pp.getHostname(), pp.getRegistryPort(), pp.getVerbose(), true, loginCreds)) == null) {
            return;
        }
        Ping.pingTopology(topoAndParams.topo, topoAndParams.params, pp.getVerbose(), pp.json, System.err, Ping.getAdminLoginManager(pp.getHostname(), pp.getRegistryPort(), loginCreds));
    }

    public static void topologyOverviewToJson(Topology topology, ObjectNode jsonTop) {
        ObjectNode on = jsonTop.putObject("topology");
        on.put("storeName", topology.getKVStoreName());
        on.put("sequenceNumber", topology.getSequenceNumber());
        on.put("numPartitions", topology.getPartitionMap().getNPartitions());
        on.put("numStorageNodes", topology.getStorageNodeMap().size());
        on.put("time", System.currentTimeMillis());
        on.put("version", KVVersion.CURRENT_VERSION.getNumericVersionString());
    }

    public static String displayTopologyOverview(JsonNode jsonTop) {
        ObjectNode on = JsonUtils.getObject(jsonTop, "topology");
        if (on == null) {
            return "";
        }
        Long timeValue = JsonUtils.getLong(on, "time");
        String time = timeValue == null ? "?" : FormatUtils.formatDateAndTime(timeValue);
        return "store " + JsonUtils.getAsText(on, "storeName", "?") + " based upon topology sequence #" + JsonUtils.getAsText(on, "sequenceNumber", "?") + "\n" + JsonUtils.getAsText(on, "numPartitions", "?") + " partitions and " + JsonUtils.getAsText(on, "numStorageNodes", "?") + " storage nodes\n" + "Time: " + time + "   Version: " + JsonUtils.getAsText(on, "version", "?");
    }

    public static void shardOverviewToJson(Topology topology, RepNodeStatusFunction rnStatusFunc, ObjectNode jsonTop) {
        int totalRF = 0;
        int totalPrimaryRF = 0;
        for (Datacenter dc : topology.getDatacenterMap().getAll()) {
            int rf = dc.getRepFactor();
            totalRF += rf;
            if (!dc.getDatacenterType().isPrimary()) continue;
            totalPrimaryRF += rf;
        }
        int quorum = totalPrimaryRF / 2 + 1;
        int total = 0;
        int healthy = 0;
        int degraded = 0;
        int noQuorum = 0;
        int offline = 0;
        for (RepGroup rg : topology.getRepGroupMap().getAll()) {
            ++total;
            int onlineRNs = 0;
            int onlinePrimaryRNs = 0;
            for (RepNode rn : rg.getRepNodes()) {
                StorageNode sn = topology.get(rn.getStorageNodeId());
                Datacenter dc = topology.get(sn.getDatacenterId());
                RepNodeStatus status = rnStatusFunc.get(rn);
                if (status == null || !status.getReplicationState().isActive()) continue;
                ++onlineRNs;
                if (!dc.getDatacenterType().isPrimary()) continue;
                ++onlinePrimaryRNs;
            }
            if (onlineRNs >= totalRF) {
                ++healthy;
                continue;
            }
            if (onlinePrimaryRNs >= quorum) {
                ++degraded;
                continue;
            }
            if (onlineRNs > 0) {
                ++noQuorum;
                continue;
            }
            ++offline;
        }
        ObjectNode on = jsonTop.putObject("shardStatus");
        on.put("total", total);
        on.put("healthy", healthy);
        on.put("degraded", degraded);
        on.put("noQuorum", noQuorum);
        on.put("offline", offline);
    }

    public static String displayShardOverview(JsonNode jsonTop) {
        ObjectNode on = JsonUtils.getObject(jsonTop, "shardStatus");
        if (on == null) {
            return "";
        }
        return "Shard Status: total:" + JsonUtils.getAsText(on, "total", "?") + " healthy:" + JsonUtils.getAsText(on, "healthy", "?") + " degraded:" + JsonUtils.getAsText(on, "degraded", "?") + " noQuorum:" + JsonUtils.getAsText(on, "noQuorum", "?") + " offline:" + JsonUtils.getAsText(on, "offline", "?");
    }

    public static ObjectNode zoneOverviewToJson(Topology topology, Datacenter dc, RepNodeStatusFunction rnStatusFunc) {
        DatacenterId dcId = (DatacenterId)dc.getResourceId();
        int rf = dc.getRepFactor();
        int online = 0;
        boolean hasReplicas = false;
        Long maxDelay = null;
        Long maxCatchupTime = null;
        Collection repGroups = topology.getRepGroupMap().getAll();
        int total = rf * repGroups.size();
        for (RepGroup rg : repGroups) {
            MasterRepNodeStats masterStats = null;
            for (RepNode rn : rg.getRepNodes()) {
                RepNodeStatus rnStatus = rnStatusFunc.get(rn);
                if (rnStatus == null || !rnStatus.getReplicationState().isMaster()) continue;
                masterStats = rnStatus.getMasterRepNodeStats();
                break;
            }
            for (RepNode rn : rg.getRepNodes()) {
                RepNodeStatus status;
                StorageNode sn = topology.get(rn.getStorageNodeId());
                if (!dcId.equals(sn.getDatacenterId()) || (status = rnStatusFunc.get(rn)) == null || !status.getReplicationState().isActive()) continue;
                ++online;
                if (status.getReplicationState().isMaster()) continue;
                hasReplicas = true;
                Long delay = null;
                Long catchupTime = null;
                long networkRestoreTime = status.getNetworkRestoreTimeSecs();
                if (networkRestoreTime != 0L) {
                    catchupTime = networkRestoreTime;
                } else if (masterStats != null) {
                    String replicaName = ((RepNodeId)rn.getResourceId()).toString();
                    delay = (Long)masterStats.getReplicaDelayMillisMap().get(replicaName);
                    catchupTime = masterStats.getReplicaCatchupTimeSecs(replicaName);
                }
                if (delay != null && (maxDelay == null || delay > maxDelay)) {
                    maxDelay = delay;
                }
                if (!Ping.useForMaxTime(catchupTime, maxCatchupTime)) continue;
                maxCatchupTime = catchupTime;
            }
        }
        ObjectNode on = JsonUtils.createObjectNode();
        Ping.zoneNameToJson(dc, on);
        ObjectNode rnStatus = on.putObject("rnSummaryStatus");
        rnStatus.put("total", total);
        rnStatus.put("online", online);
        rnStatus.put("hasReplicas", hasReplicas);
        if (maxDelay != null) {
            rnStatus.put("maxDelayMillis", maxDelay);
        }
        if (maxCatchupTime != null) {
            rnStatus.put("maxCatchupTimeSecs", maxCatchupTime);
        }
        return on;
    }

    private static boolean useForMaxTime(Long time, Long maxTime) {
        if (time == null) {
            return false;
        }
        if (maxTime == null) {
            return true;
        }
        if (time >= 0L && maxTime < 0L) {
            return false;
        }
        if (time < 0L && maxTime >= 0L) {
            return true;
        }
        return time > maxTime;
    }

    public static String displayZoneOverview(JsonNode jsonZone) {
        ObjectNode jsonRN = JsonUtils.getObject(jsonZone, "rnSummaryStatus");
        if (jsonRN == null) {
            return "Zone " + Ping.displayZoneName(jsonZone);
        }
        boolean hasReplicas = JsonUtils.getBoolean(jsonRN, "hasReplicas", false);
        String maxDelay = !hasReplicas ? null : JsonUtils.getAsText(jsonRN, "maxDelayMillis", "?");
        Long maxCatchupValue = JsonUtils.getLong(jsonRN, "maxCatchupTimeSecs");
        String maxCatchup = !hasReplicas ? null : (maxCatchupValue == null ? "?" : (maxCatchupValue == Long.MAX_VALUE ? "-" : maxCatchupValue.toString()));
        return "Zone " + Ping.displayZoneName(jsonZone) + "   RN Status: total:" + JsonUtils.getAsText(jsonRN, "total", "?") + " online:" + JsonUtils.getAsText(jsonRN, "online", "?") + (maxDelay != null ? " maxDelayMillis:" + maxDelay : "") + (maxCatchup != null ? " maxCatchupTimeSecs:" + maxCatchup : "");
    }

    public static ObjectNode storageNodeToJson(Topology topology, StorageNode sn, StorageNodeStatus status) {
        ObjectNode on = JsonUtils.createObjectNode();
        on.put("resourceId", ((StorageNodeId)sn.getResourceId()).toString());
        on.put("hostname", sn.getHostname());
        on.put("registryPort", sn.getRegistryPort());
        Ping.zoneNameToJson(topology.get(sn.getDatacenterId()), on.putObject("zone"));
        if (status != null) {
            on.put("serviceStatus", status.getServiceStatus().toString());
            on.put("version", status.getKVVersion().toString());
        } else {
            on.put("serviceStatus", "UNREACHABLE");
        }
        return on;
    }

    public static String displayStorageNode(JsonNode node) {
        String serviceStatus = JsonUtils.getAsText(node, "serviceStatus", "UNREACHABLE");
        return "Storage Node [" + JsonUtils.getAsText(node, "resourceId", "?") + "] on " + JsonUtils.getAsText(node, "hostname", "?") + ":" + JsonUtils.getAsText(node, "registryPort", "?") + "    Zone: " + Ping.displayZoneName(JsonUtils.getObject(node, "zone")) + " " + (!"UNREACHABLE".equals(serviceStatus) ? "   Status: " + serviceStatus + "   Ver: " + JsonUtils.getAsText(node, "version", "?") : "UNREACHABLE");
    }

    private static void zoneNameToJson(Datacenter dc, ObjectNode node) {
        node.put("resourceId", ((DatacenterId)dc.getResourceId()).toString());
        node.put("name", dc.getName());
        node.put("type", dc.getDatacenterType().toString());
    }

    private static String displayZoneName(JsonNode node) {
        return "[name=" + JsonUtils.getAsText(node, "name", "?") + " id=" + JsonUtils.getAsText(node, "resourceId", "?") + " type=" + JsonUtils.getAsText(node, "type", "?") + "]";
    }

    public static ObjectNode adminToJson(AdminId aId, ConfigurableService.ServiceStatus status, ReplicatedEnvironment.State state) {
        ObjectNode on = JsonUtils.createObjectNode();
        on.put("resourceId", aId.toString());
        Ping.statusToJson(status, state, on);
        return on;
    }

    public static String displayAdmin(JsonNode node) {
        return "\tAdmin [" + JsonUtils.getAsText(node, "resourceId", "?") + "]\t\tStatus: " + Ping.displayStatus(node);
    }

    private static void statusToJson(RepNodeStatus status, ObjectNode on) {
        if (status == null) {
            on.put("status", "UNREACHABLE");
        } else {
            Ping.statusToJson(status.getServiceStatus(), status.getReplicationState(), on);
        }
    }

    private static void statusToJson(ConfigurableService.ServiceStatus status, ReplicatedEnvironment.State state, ObjectNode on) {
        on.put("status", status.toString());
        if (state != null) {
            on.put("state", state.toString());
        }
    }

    private static String displayStatus(JsonNode node) {
        String state = JsonUtils.getAsText(node, "state");
        return JsonUtils.getAsText(node, "status", "UNREACHABLE") + (state == null ? "" : "," + state);
    }

    public static ObjectNode repNodeToJson(RepNode rn, RepNodeStatus status, RepNodeStatus masterStatus, ConfigurableService.ServiceStatus expected) {
        MasterRepNodeStats stats;
        ObjectNode on = JsonUtils.createObjectNode();
        on.put("resourceId", ((RepNodeId)rn.getResourceId()).toString());
        Ping.statusToJson(status, on);
        if (expected != null) {
            on.put("expectedStatus", expected.toString());
        }
        if (status == null) {
            return on;
        }
        on.put("sequenceNumber", status.getVlsn());
        on.put("haPort", status.getHAPort());
        if (status.getReplicationState().isMaster()) {
            return on;
        }
        long networkRestoreTime = status.getNetworkRestoreTimeSecs();
        if (networkRestoreTime > 0L) {
            on.put("networkRestoreUnderway", true);
            on.put("catchupTimeSecs", networkRestoreTime);
            return on;
        }
        on.put("networkRestoreUnderway", false);
        if (masterStatus != null && (stats = masterStatus.getMasterRepNodeStats()) != null) {
            Long catchupRate;
            Long catchupTime;
            String replicaName = ((RepNodeId)rn.getResourceId()).toString();
            Long delay = (Long)stats.getReplicaDelayMillisMap().get(replicaName);
            if (delay != null) {
                on.put("delayMillis", delay);
            }
            if ((catchupTime = stats.getReplicaCatchupTimeSecs(replicaName)) != null) {
                on.put("catchupTimeSecs", catchupTime);
            }
            if ((catchupRate = stats.getReplicaCatchupRate(replicaName)) != null) {
                on.put("catchupRateMillisPerMinute", catchupRate);
            }
        }
        return on;
    }

    public static String displayRepNode(JsonNode node) {
        String stopped;
        String result = "\tRep Node [" + JsonUtils.getAsText(node, "resourceId", "?") + "]\tStatus: " + Ping.displayStatus(node);
        String string = stopped = "UNREACHABLE".equals(JsonUtils.getAsText(node, "expectedStatus")) ? " (Stopped)" : "";
        if (JsonUtils.getAsText(node, "status", "UNREACHABLE").equals("UNREACHABLE")) {
            return result + stopped;
        }
        Long sequenceNumber = JsonUtils.getLong(node, "sequenceNumber");
        result = result + " sequenceNumber:" + (sequenceNumber != null ? String.format("%,d", sequenceNumber) : "?") + " haPort:" + JsonUtils.getAsText(node, "haPort", "?");
        if ("MASTER".equals(JsonUtils.getAsText(node, "state"))) {
            return result + stopped;
        }
        Long catchupTimeValue = JsonUtils.getLong(node, "catchupTimeSecs");
        String catchupTime = catchupTimeValue == null ? "?" : (catchupTimeValue == Long.MAX_VALUE ? "-" : catchupTimeValue.toString());
        boolean networkRestoreUnderway = JsonUtils.getBoolean(node, "networkRestoreUnderway", false);
        return result + " delayMillis:" + JsonUtils.getAsText(node, "delayMillis", "?") + " catchupTimeSecs:" + catchupTime + (networkRestoreUnderway ? " networkRestoreUnderway" : "") + stopped;
    }

    public static void pingTopology(Topology topology, Parameters params, boolean verbose, boolean useJson, PrintStream ps, LoginManager adminLoginMgr) {
        ObjectNode jsonTop = Ping.pingTopologyToJson(topology, params, verbose, adminLoginMgr);
        if (useJson) {
            ObjectWriter writer = JsonUtils.createWriter(true);
            try {
                ps.println(writer.writeValueAsString(jsonTop));
            }
            catch (IOException e) {
                ps.println(e);
            }
        } else {
            ps.print("Pinging components of ");
            ps.println(Ping.displayTopologyOverview(jsonTop));
            ps.println(Ping.displayShardOverview(jsonTop));
            for (JsonNode jsonZone : JsonUtils.getArray(jsonTop, "zoneStatus")) {
                ps.println(Ping.displayZoneOverview(jsonZone));
            }
            for (JsonNode jsonSN : JsonUtils.getArray(jsonTop, "snStatus")) {
                ps.println(Ping.displayStorageNode(jsonSN));
                JsonNode jsonAdmin = jsonSN.get("adminStatus");
                if (jsonAdmin != null) {
                    ps.println(Ping.displayAdmin(jsonAdmin));
                }
                for (JsonNode jsonRN : JsonUtils.getArray(jsonSN, "rnStatus")) {
                    ps.println(Ping.displayRepNode(jsonRN));
                }
            }
        }
    }

    private static ObjectNode pingTopologyToJson(Topology topology, Parameters params, boolean verbose, LoginManager adminLoginMgr) {
        final HashMap snmap = new HashMap();
        final HashMap adminmap = new HashMap();
        final TreeMap rnmap = new TreeMap();
        Ping.forEachStorageNode(topology, verbose, new StorageNodeCallback(){

            @Override
            public void nodeCallback(StorageNode sn, StorageNodeStatus status) {
                snmap.put(sn, status);
            }
        });
        if (params != null) {
            Ping.forEachAdmin(params, verbose, adminLoginMgr, new AdminCallback(){

                @Override
                public void nodeCallback(AdminId aId, AdminInfo info) {
                    adminmap.put(aId, info);
                }
            });
        }
        Ping.forEachRepNode(topology, verbose, new RepNodeCallback(){

            @Override
            public void nodeCallback(RepNode rn, RepNodeStatus status) {
                rnmap.put(rn, status);
            }
        });
        ArrayList sns = new ArrayList(snmap.keySet());
        Collections.sort(sns, new Comparator<StorageNode>(){

            @Override
            public int compare(StorageNode o1, StorageNode o2) {
                return o1.getStorageNodeId().getStorageNodeId() - o2.getStorageNodeId().getStorageNodeId();
            }
        });
        HashMap<RepGroupId, RepNodeStatus> masterStatusMap = new HashMap<RepGroupId, RepNodeStatus>();
        for (Map.Entry e : rnmap.entrySet()) {
            RepNodeStatus status = (RepNodeStatus)e.getValue();
            if (status == null || !status.getReplicationState().isMaster()) continue;
            RepNode rn = (RepNode)e.getKey();
            masterStatusMap.put(rn.getRepGroupId(), status);
        }
        RepNodeStatusFunction rnfunc = new RepNodeStatusFunction(){

            @Override
            public RepNodeStatus get(RepNode rn) {
                return (RepNodeStatus)rnmap.get(rn);
            }
        };
        ObjectNode jsonTop = JsonUtils.createObjectNode();
        Ping.topologyOverviewToJson(topology, jsonTop);
        Ping.shardOverviewToJson(topology, rnfunc, jsonTop);
        ArrayNode jsonZones = jsonTop.putArray("zoneStatus");
        for (Datacenter dc : topology.getSortedDatacenters()) {
            jsonZones.add(Ping.zoneOverviewToJson(topology, dc, rnfunc));
        }
        ArrayNode jsonSNs = jsonTop.putArray("snStatus");
        for (StorageNode sn : sns) {
            StorageNodeStatus status = (StorageNodeStatus)snmap.get(sn);
            ObjectNode jsonSN = Ping.storageNodeToJson(topology, sn, status);
            jsonSNs.add(jsonSN);
            for (Map.Entry aentry : adminmap.entrySet()) {
                AdminInfo info = (AdminInfo)aentry.getValue();
                if (info == null || !sn.getStorageNodeId().equals(info.snId)) continue;
                jsonSN.put("adminStatus", Ping.adminToJson((AdminId)aentry.getKey(), info.status, info.state));
                break;
            }
            ArrayNode jsonRNs = jsonSN.putArray("rnStatus");
            for (Map.Entry rentry : rnmap.entrySet()) {
                RepNode rn = (RepNode)rentry.getKey();
                if (!sn.getStorageNodeId().equals(rn.getStorageNodeId())) continue;
                jsonRNs.add(Ping.repNodeToJson(rn, (RepNodeStatus)rentry.getValue(), (RepNodeStatus)masterStatusMap.get(rn.getRepGroupId()), null));
            }
        }
        return jsonTop;
    }

    public static Map<ResourceId, ConfigurableService.ServiceStatus> getTopologyStatus(Topology topology, Parameters params, LoginManager adminLoginMgr) {
        final HashMap<ResourceId, ConfigurableService.ServiceStatus> ret = new HashMap<ResourceId, ConfigurableService.ServiceStatus>();
        Ping.forEachStorageNode(topology, false, new StorageNodeCallback(){

            @Override
            public void nodeCallback(StorageNode sn, StorageNodeStatus status) {
                ret.put(sn.getResourceId(), status != null ? status.getServiceStatus() : ConfigurableService.ServiceStatus.UNREACHABLE);
            }
        });
        if (params != null) {
            Ping.forEachAdmin(params, false, adminLoginMgr, new AdminCallback(){

                @Override
                public void nodeCallback(AdminId aId, AdminInfo info) {
                    ret.put(aId, info != null ? info.status : ConfigurableService.ServiceStatus.UNREACHABLE);
                }
            });
        }
        Ping.forEachRepNode(topology, false, new RepNodeCallback(){

            @Override
            public void nodeCallback(RepNode rn, RepNodeStatus status) {
                ret.put(rn.getResourceId(), status != null ? status.getServiceStatus() : ConfigurableService.ServiceStatus.UNREACHABLE);
            }
        });
        return ret;
    }

    public static RepNode getMaster(Topology topology, RepGroupId rgId) {
        final ArrayList master = new ArrayList();
        Ping.forEachRepNode(topology, rgId, false, new RepNodeCallback(){

            @Override
            public void nodeCallback(RepNode rn, RepNodeStatus status) {
                if (status != null && status.getReplicationState().isMaster()) {
                    master.add(rn);
                }
            }
        });
        return master.size() == 1 ? (RepNode)master.get(0) : null;
    }

    public static RepNodeStatus getMasterStatus(Topology topology, RepGroupId rgId) {
        final ArrayList master = new ArrayList();
        Ping.forEachRepNode(topology, rgId, false, new RepNodeCallback(){

            @Override
            public void nodeCallback(RepNode rn, RepNodeStatus status) {
                if (status != null && status.getReplicationState().isMaster()) {
                    master.add(status);
                }
            }
        });
        return master.size() == 1 ? (RepNodeStatus)master.get(0) : null;
    }

    public static Map<RepNodeId, RepNodeStatus> getRepNodeStatus(Topology topology, RepGroupId rgId) {
        final HashMap<RepNodeId, RepNodeStatus> statusMap = new HashMap<RepNodeId, RepNodeStatus>();
        Ping.forEachRepNode(topology, rgId, false, new RepNodeCallback(){

            @Override
            public void nodeCallback(RepNode rn, RepNodeStatus status) {
                statusMap.put(rn.getResourceId(), status);
            }
        });
        return statusMap;
    }

    private static void forEachStorageNode(Topology topology, boolean verbose, StorageNodeCallback callback) {
        RegistryUtils regUtils = new RegistryUtils(topology, null);
        for (StorageNode sn : topology.getStorageNodeMap().getAll()) {
            StorageNodeStatus status;
            block5: {
                status = null;
                try {
                    StorageNodeAgentAPI sna = regUtils.getStorageNodeAgent((StorageNodeId)sn.getResourceId());
                    status = sna.ping();
                }
                catch (RemoteException re) {
                    if (verbose) {
                        System.err.println("Ping failed for " + sn.getResourceId() + ": " + re.getMessage());
                        re.printStackTrace();
                    }
                }
                catch (NotBoundException e) {
                    if (!verbose) break block5;
                    System.err.println("No RMI service for SN: " + sn.getResourceId() + " message: " + e.getMessage());
                }
            }
            callback.nodeCallback(sn, status);
        }
    }

    private static void forEachAdmin(Parameters params, boolean verbose, LoginManager adminLoginMgr, AdminCallback callback) {
        for (AdminId aId : params.getAdminIds()) {
            AdminInfo info;
            block8: {
                StorageNodeId snId = params.get(aId).getStorageNodeId();
                StorageNodeParams snp = params.get(snId);
                info = null;
                try {
                    CommandServiceAPI admin = RegistryUtils.getAdmin(snp.getHostname(), snp.getRegistryPort(), adminLoginMgr);
                    info = new AdminInfo(snId, admin.ping(), admin.getAdminState());
                }
                catch (AdminFaultException afe) {
                    if (afe.getFaultClassName().equals(SessionAccessException.class.getName())) {
                        if (verbose) {
                            System.err.println("Ping failed for " + aId + ": " + afe.getMessage());
                        }
                    }
                    throw afe;
                }
                catch (RemoteException re) {
                    if (verbose) {
                        System.err.println("Ping failed for " + aId + ": " + re.getMessage());
                        re.printStackTrace();
                    }
                }
                catch (NotBoundException e) {
                    if (!verbose) break block8;
                    System.err.println("No RMI service for Admin: " + aId + " message: " + e.getMessage());
                }
            }
            callback.nodeCallback(aId, info);
        }
    }

    private static void forEachRepNode(Topology topology, boolean verbose, RepNodeCallback callback) {
        RegistryUtils regUtils = new RegistryUtils(topology, null);
        for (RepGroup rg : topology.getRepGroupMap().getAll()) {
            for (RepNode rn : rg.getRepNodes()) {
                RepNodeStatus status;
                block6: {
                    status = null;
                    try {
                        RepNodeAdminAPI rna = regUtils.getRepNodeAdmin((RepNodeId)rn.getResourceId());
                        status = rna.ping();
                    }
                    catch (RemoteException re) {
                        if (verbose) {
                            System.err.println("Ping failed for " + rn.getResourceId() + ": " + re.getMessage());
                            re.printStackTrace();
                        }
                    }
                    catch (NotBoundException e) {
                        if (!verbose) break block6;
                        System.err.println("No RMI service for RN: " + rn.getResourceId() + " message: " + e.getMessage());
                    }
                }
                callback.nodeCallback(rn, status);
            }
        }
    }

    private static void forEachRepNode(Topology topology, RepGroupId rgId, boolean verbose, RepNodeCallback callback) {
        RepGroup group = topology.get(rgId);
        if (group == null) {
            return;
        }
        RegistryUtils regUtils = new RegistryUtils(topology, null);
        for (RepNode rn : group.getRepNodes()) {
            RepNodeStatus status;
            block6: {
                status = null;
                try {
                    RepNodeAdminAPI rna = regUtils.getRepNodeAdmin((RepNodeId)rn.getResourceId());
                    status = rna.ping();
                }
                catch (RemoteException re) {
                    if (verbose) {
                        System.err.println("Ping failed for " + rn.getResourceId() + ": " + re.getMessage());
                        re.printStackTrace();
                    }
                }
                catch (NotBoundException e) {
                    if (!verbose) break block6;
                    System.err.println("No RMI service for RN: " + rn.getResourceId() + " message: " + e.getMessage());
                }
            }
            callback.nodeCallback(rn, status);
        }
    }

    public static Topology getTopology(String snHostname, int snRegistryPort) throws RemoteException, AccessException {
        TopoAndParams topoAndParams = Ping.getTopologyAndParams(snHostname, snRegistryPort, false, false, null);
        return topoAndParams != null ? topoAndParams.topo : null;
    }

    private static TopoAndParams getTopologyAndParams(String snHostname, int snRegistryPort, boolean verbose, boolean getParams, PasswordCredentials loginCreds) throws RemoteException, AccessException {
        RemoteException exception = null;
        try {
            Registry snRegistry = RegistryUtils.getRegistry(snHostname, snRegistryPort, null);
            ArrayList<String> serviceNames = new ArrayList<String>();
            Collections.addAll(serviceNames, snRegistry.list());
            if (serviceNames.contains("snaService")) {
                System.err.println("SNA at hostname: " + snHostname + ", registry port: " + snRegistryPort + " is not registered." + "\n\tNo further information is available");
                return null;
            }
            if (getParams && serviceNames.remove("commandService")) {
                serviceNames.add(0, "commandService");
            }
            Topology topology = null;
            for (String serviceName : serviceNames) {
                if (RegistryUtils.isStorageNodeAgentLogin(serviceName)) continue;
                Remote stub = null;
                try {
                    RemoteAPI admin;
                    stub = snRegistry.lookup(serviceName);
                    if (stub instanceof CommandService) {
                        admin = Ping.getAdmin((CommandService)stub, snHostname, snRegistryPort, loginCreds);
                        return new TopoAndParams(((CommandServiceAPI)admin).getTopology(), getParams ? ((CommandServiceAPI)admin).getParameters() : null);
                    }
                    if (topology != null || !(stub instanceof RepNodeAdmin) || (topology = ((RepNodeAdminAPI)(admin = Ping.getRNAdmin((RepNodeAdmin)stub, snHostname, snRegistryPort, loginCreds))).getTopology()) == null || getParams) continue;
                    return new TopoAndParams(topology, null);
                }
                catch (AuthenticationFailureException afe) {
                    System.err.println("Login failed.");
                    return null;
                }
                catch (Exception e) {
                    if (!verbose) continue;
                    System.err.println("Failed to " + (stub == null ? "lookup" : "connect to") + " service " + serviceName + " Exception message:" + e.getMessage());
                    e.printStackTrace();
                }
            }
            if (topology != null) {
                for (StorageNode sn : topology.getStorageNodeMap().getAll()) {
                    try {
                        CommandServiceAPI admin = Ping.getAdmin(sn.getHostname(), sn.getRegistryPort(), loginCreds);
                        return new TopoAndParams(topology, admin.getParameters());
                    }
                    catch (Exception e) {
                        if (!verbose) continue;
                        System.err.println("Failed to connect to admin service on " + sn.getHostname() + ":" + sn.getRegistryPort() + " Exception message:" + e.getMessage());
                        e.printStackTrace();
                    }
                }
                return new TopoAndParams(topology, null);
            }
            System.err.println("SNA at hostname: " + snHostname + " registry port: " + snRegistryPort + " has no available Admins or RNs registered.");
        }
        catch (ConnectIOException cioe) {
            exception = cioe;
        }
        catch (ConnectException ce) {
            exception = ce;
        }
        if (exception != null) {
            System.err.println("Could not connect to registry at " + snHostname + ":" + snRegistryPort + ": " + ((Throwable)exception).getMessage());
        }
        return null;
    }

    private static LoginManager getAdminLoginManager(String snHostname, int snRegistryPort, PasswordCredentials loginCreds) {
        return loginCreds != null ? KVStoreLogin.getAdminLoginMgr(snHostname, snRegistryPort, loginCreds) : null;
    }

    private static CommandServiceAPI getAdmin(CommandService cs, String snHostname, int snRegistryPort, PasswordCredentials loginCreds) throws RemoteException {
        LoginHandle loginHandle = null;
        if (loginCreds != null) {
            AdminLoginManager loginMgr = KVStoreLogin.getAdminLoginMgr(snHostname, snRegistryPort, loginCreds);
            loginHandle = loginMgr.getHandle(new HostPort(snHostname, snRegistryPort), ResourceId.ResourceType.ADMIN);
        }
        return CommandServiceAPI.wrap(cs, loginHandle);
    }

    private static CommandServiceAPI getAdmin(String snHostname, int snRegistryPort, PasswordCredentials loginCreds) throws NotBoundException, RemoteException {
        LoginManager loginMgr = Ping.getAdminLoginManager(snHostname, snRegistryPort, loginCreds);
        return RegistryUtils.getAdmin(snHostname, snRegistryPort, loginMgr);
    }

    private static RepNodeAdminAPI getRNAdmin(RepNodeAdmin admin, String snHostname, int snRegistryPort, PasswordCredentials loginCreds) throws RemoteException {
        LoginHandle loginHandle = null;
        if (loginCreds != null) {
            RepNodeLoginManager loginMgr = KVStoreLogin.getRepNodeLoginMgr(snHostname, snRegistryPort, loginCreds, null);
            loginHandle = loginMgr.getHandle(new HostPort(snHostname, snRegistryPort), ResourceId.ResourceType.REP_NODE);
        }
        return RepNodeAdminAPI.wrap(admin, loginHandle);
    }

    private static class TopoAndParams {
        final Topology topo;
        final Parameters params;

        TopoAndParams(Topology topo, Parameters params) {
            this.topo = topo;
            this.params = params;
        }
    }

    public static interface RepNodeStatusFunction {
        public RepNodeStatus get(RepNode var1);
    }

    private static interface RepNodeCallback {
        public void nodeCallback(RepNode var1, RepNodeStatus var2);
    }

    private static interface AdminCallback {
        public void nodeCallback(AdminId var1, AdminInfo var2);
    }

    private static class AdminInfo {
        final StorageNodeId snId;
        final ConfigurableService.ServiceStatus status;
        final ReplicatedEnvironment.State state;

        AdminInfo(StorageNodeId snId, ConfigurableService.ServiceStatus status, ReplicatedEnvironment.State state) {
            this.snId = snId;
            this.status = status;
            this.state = state;
        }
    }

    private static interface StorageNodeCallback {
        public void nodeCallback(StorageNode var1, StorageNodeStatus var2);
    }
}

