/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.shell;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.kv.Direction;
import oracle.kv.FaultException;
import oracle.kv.KVStore;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.StoreIteratorException;
import oracle.kv.impl.admin.client.CommandShell;
import oracle.kv.shell.CommandUtils;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.Table;
import oracle.kv.table.TableAPI;
import oracle.kv.table.TableIterator;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellException;

public class DeleteCommand
extends CommandWithSubs {
    static final String START_FLAG = "-start";
    static final String END_FLAG = "-end";
    static final String COMMAND_OVERVIEW = "The delete command encapsulates commands that delete " + eol + "key/value pairs from a store and rows from a table";
    private static final List<? extends CommandWithSubs.SubCommand> subs = Arrays.asList(new DeleteKVCommand(), new DeleteTableCommand());

    public DeleteCommand() {
        super(subs, "delete", 3, 2);
    }

    @Override
    protected String getCommandOverview() {
        return COMMAND_OVERVIEW;
    }

    static class DeleteTableCommand
    extends CommandWithSubs.SubCommand {
        static final String COMMAND_NAME = "table";
        static final String TABLE_FLAG = "-name";
        static final String TABLE_FLAG_DESC = "-name <name>";
        static final String FIELD_FLAG = "-field";
        static final String FIELD_FLAG_DESC = "-field <name>";
        static final String VALUE_FLAG = "-value";
        static final String VALUE_FLAG_DESC = "-value <value>";
        static final String NULL_VALUE_FLAG = "-null-value";
        static final String NULL_VALUE_FLAG_DESC = "-null-value";
        static final String ANCESTOR_FLAG = "-ancestor";
        static final String ANCESTOR_FLAG_DESC = "-ancestor <name>";
        static final String CHILD_FLAG = "-child";
        static final String CHILD_FLAG_DESC = "-child <name>";
        static final String INDEX_FLAG = "-index";
        static final String INDEX_FLAG_DESC = "-index <name>";
        static final String JSON_FLAG = "-json";
        static final String JSON_FLAG_DESC = "-json <string>";
        static final String DELETE_ALL_FLAG = "-delete-all";
        static final String DELETE_ALL_FLAG_DESC = "-delete-all";
        static final String START_FLAG_DESC = "-start <value>";
        static final String END_FLAG_DESC = "-end <value>";
        static final String COMMAND_SYNTAX = "delete table -name <name>" + eolt + "[" + "-field <name>" + " " + "-value <value>" + "]+" + eolt + "[" + "-field <name>" + " [" + "-start <value>" + "] [" + "-end <value>" + "]]" + eolt + "[" + "-ancestor <name>" + "]+ [" + "-child <name>" + "]+" + eolt + "[" + "-json <string>" + "] [" + "-delete-all" + "]";
        static final String COMMAND_DESCRIPTION = "Deletes one or more rows from the named table.  The table name" + eolt + "is a dot-separated name with the " + "format tableName[.childTableName]+." + eolt + "-field" + " and " + "-value" + " pairs are used to " + "specify a primary key to use for" + eolt + "the deletion." + eolt + "-field" + ", " + "-start" + " and " + "-end" + " flags " + "can be used to specify a range of keys to" + eolt + "be deleted." + eolt + "-ancestor" + " and " + "-child" + " flags can be used " + "to delete rows from specified" + eolt + "ancestor and/or descendant tables as well as the target" + " table." + eolt + "-json" + " indicates that the key field values are " + "in JSON format." + eolt + "-delete-all" + " is used to delete all rows in a table.";

        DeleteTableCommand() {
            super(COMMAND_NAME, 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            String tableName = null;
            String frFieldName = null;
            String rgStart = null;
            String rgEnd = null;
            String jsonString = null;
            boolean deleteAll = false;
            ArrayList<String> lstAncestor = new ArrayList<String>();
            ArrayList<String> lstChild = new ArrayList<String>();
            HashMap<String, String> mapVals = new HashMap<String, String>();
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (TABLE_FLAG.equals(arg)) {
                    tableName = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (FIELD_FLAG.equals(arg)) {
                    String fname = Shell.nextArg(args, i++, this);
                    if (++i < args.length) {
                        arg = args[i];
                        if (VALUE_FLAG.equals(arg)) {
                            String fVal = Shell.nextArg(args, i++, this);
                            mapVals.put(fname, fVal);
                            continue;
                        }
                        while (i < args.length) {
                            arg = args[i];
                            if (DeleteCommand.START_FLAG.equals(arg)) {
                                rgStart = Shell.nextArg(args, i++, this);
                            } else {
                                if (!DeleteCommand.END_FLAG.equals(arg)) break;
                                rgEnd = Shell.nextArg(args, i++, this);
                            }
                            ++i;
                        }
                        if (rgStart == null && rgEnd == null) {
                            shell.invalidArgument(arg + ", " + VALUE_FLAG + " or " + DeleteCommand.START_FLAG + " | " + DeleteCommand.END_FLAG + " is reqired", this);
                        }
                        frFieldName = fname;
                        --i;
                        continue;
                    }
                    shell.requiredArg("-value or -start | -end", this);
                    continue;
                }
                if (ANCESTOR_FLAG.equals(arg)) {
                    lstAncestor.add(Shell.nextArg(args, i++, this));
                    continue;
                }
                if (CHILD_FLAG.equals(arg)) {
                    lstChild.add(Shell.nextArg(args, i++, this));
                    continue;
                }
                if (JSON_FLAG.equals(arg)) {
                    jsonString = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-delete-all".equals(arg)) {
                    deleteAll = true;
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (tableName == null) {
                shell.requiredArg(TABLE_FLAG, this);
            }
            if (mapVals.isEmpty() && frFieldName == null && jsonString == null && !deleteAll) {
                shell.requiredArg("-field | -json | -delete-all", this);
            }
            TableAPI tableImpl = ((CommandShell)shell).getStore().getTableAPI();
            Table table = CommandUtils.findTable(tableImpl, tableName);
            PrimaryKey key = null;
            if (jsonString == null) {
                key = table.createPrimaryKey();
                for (Map.Entry entry : mapVals.entrySet()) {
                    String fname = (String)entry.getKey();
                    CommandUtils.putIndexKeyValues(key, table, fname, (String)entry.getValue());
                }
            } else {
                key = CommandUtils.createKeyFromJson(table, null, jsonString).asPrimaryKey();
            }
            MultiRowOptions mro = null;
            if (rgStart != null || rgEnd != null || !lstAncestor.isEmpty() || !lstChild.isEmpty()) {
                mro = CommandUtils.createMultiRowOptions(tableImpl, table, key, lstAncestor, lstChild, frFieldName, rgStart, rgEnd);
            }
            return this.doDeleteOperation(tableImpl, key, mro);
        }

        private String doDeleteOperation(final TableAPI tableImpl, final PrimaryKey key, final MultiRowOptions mro) throws ShellException {
            final StringBuilder sb = new StringBuilder();
            new CommandUtils.RunTableAPIOperation(){

                @Override
                void doOperation() throws ShellException {
                    long nDel = 0L;
                    if (mro == null && CommandUtils.matchFullPrimaryKey(key)) {
                        if (tableImpl.delete(key, null, null)) {
                            nDel = 1L;
                        }
                    } else {
                        nDel = CommandUtils.matchFullMajorKey(key) ? (long)tableImpl.multiDelete(key, mro, null) : DeleteTableCommand.this.deleteKeys(tableImpl, key, mro);
                    }
                    sb.append(nDel);
                    sb.append(nDel > 1L ? " rows " : " row ");
                    sb.append("deleted.");
                }
            }.run();
            return sb.toString();
        }

        private long deleteKeys(TableAPI tableImpl, PrimaryKey key, MultiRowOptions mro) throws ShellException {
            TableIterator<PrimaryKey> itr = tableImpl.tableKeysIterator(key, mro, null);
            long nDel = 0L;
            try {
                while (itr.hasNext()) {
                    if (!tableImpl.delete((PrimaryKey)itr.next(), null, null)) continue;
                    ++nDel;
                }
            }
            catch (StoreIteratorException sie) {
                Throwable t = sie.getCause();
                if (t != null && t instanceof FaultException) {
                    throw (FaultException)t;
                }
                throw new ShellException(t != null ? t.getMessage() : sie.getMessage());
            }
            finally {
                itr.close();
            }
            return nDel;
        }

        @Override
        protected String getCommandSyntax() {
            return COMMAND_SYNTAX;
        }

        @Override
        protected String getCommandDescription() {
            return COMMAND_DESCRIPTION;
        }
    }

    static class DeleteKVCommand
    extends CommandWithSubs.SubCommand {
        static final String COMMAND_NAME = "kv";
        static final String KEY_FLAG = "-key";
        static final String KEY_FLAG_DESC = "-key <key>";
        static final String MULTI_FLAG = "-all";
        static final String MULTI_FLAG_DESC = "-all";
        static final String START_FLAG_DESC = "-start <prefixString>";
        static final String END_FLAG_DESC = "-end <prefixString>";
        static final String COMMAND_SYNTAX = "delete kv [-key <key>] [-start <prefixString>] [-end <prefixString>] [-all]";
        static final String COMMAND_DESCRIPTION = "Deletes one or more keys. If -all is specified, deletes all" + eolt + "keys starting at the specified key. " + "If no key is specified" + eolt + "delete all keys in the store." + eolt + "-start" + " and " + "-end" + " flags can be used for " + "restricting the range used " + eolt + "for deletion.";

        DeleteKVCommand() {
            super(COMMAND_NAME, 2);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            boolean all = false;
            Key key = null;
            String keyString = null;
            String rangeStart = null;
            String rangeEnd = null;
            KVStore store = ((CommandShell)shell).getStore();
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (KEY_FLAG.equals(arg)) {
                    keyString = Shell.nextArg(args, i++, this);
                    try {
                        key = CommandUtils.createKeyFromURI(keyString);
                    }
                    catch (IllegalArgumentException iae) {
                        shell.invalidArgument(iae.getMessage(), this);
                    }
                    continue;
                }
                if (DeleteCommand.START_FLAG.equals(arg)) {
                    rangeStart = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (DeleteCommand.END_FLAG.equals(arg)) {
                    rangeEnd = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-all".equals(arg)) {
                    all = true;
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (key == null && !all) {
                shell.requiredArg(KEY_FLAG, this);
            }
            String returnValue = null;
            if (key != null && !all) {
                try {
                    if (store.delete(key)) {
                        returnValue = "Key deleted: " + keyString;
                    }
                    returnValue = "Key deletion failed: " + keyString;
                }
                catch (Exception e) {
                    throw new ShellException("Exception from NoSQL DB in delete:" + eolt + e.getMessage(), e);
                }
            } else {
                KeyRange kr = null;
                if (rangeStart != null || rangeEnd != null) {
                    try {
                        kr = new KeyRange(rangeStart, true, rangeEnd, true);
                    }
                    catch (IllegalArgumentException iae) {
                        shell.invalidArgument(iae.getLocalizedMessage(), this);
                    }
                }
                long numdeleted = 0L;
                try {
                    if (key != null && key.getMinorPath() != null && key.getMinorPath().size() > 0) {
                        numdeleted = store.multiDelete(key, kr, null);
                    } else {
                        Iterator<Key> it = store.storeKeysIterator(Direction.UNORDERED, 100, key, kr, null);
                        if (!it.hasNext() && key != null) {
                            numdeleted = store.multiDelete(key, kr, null);
                        } else {
                            while (it.hasNext()) {
                                if (!store.delete(it.next())) continue;
                                ++numdeleted;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new ShellException("Exception from NoSQL DB in delete:" + eolt + e.getMessage(), e);
                }
                returnValue = numdeleted + (numdeleted > 1L ? " Keys " : " Key ") + "deleted starting at " + (keyString == null ? "root" : keyString);
            }
            return returnValue;
        }

        @Override
        protected String getCommandSyntax() {
            return COMMAND_SYNTAX;
        }

        @Override
        protected String getCommandDescription() {
            return COMMAND_DESCRIPTION;
        }
    }
}

