/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import oracle.kv.KVVersion;

public class VersionUtil {
    private VersionUtil() {
    }

    public static int compareMinorVersion(KVVersion v1, KVVersion v2) {
        return new KVVersion(v1.getOracleMajor(), v1.getOracleMinor(), v1.getMajor(), v1.getMinor(), 0, null).compareTo(new KVVersion(v2.getOracleMajor(), v2.getOracleMinor(), v2.getMajor(), v2.getMinor(), 0, null));
    }

    public static void checkUpgrade(KVVersion previousVersion) {
        VersionUtil.checkUpgrade(previousVersion, KVVersion.PREREQUISITE_VERSION, KVVersion.CURRENT_VERSION);
    }

    public static void checkUpgrade(KVVersion previousVersion, KVVersion prerequisiteVersion, KVVersion targetVersion) {
        if (previousVersion.compareTo(prerequisiteVersion) < 0) {
            throw new IllegalStateException("The previous software version " + previousVersion.getNumericVersionString() + " does not satisfy the prerequisite for " + targetVersion.getNumericVersionString() + " which requires version " + prerequisiteVersion.getNumericVersionString() + " or later.");
        }
        if (VersionUtil.compareMinorVersion(previousVersion, targetVersion) > 0) {
            throw new IllegalStateException("The previous software version " + previousVersion.getNumericVersionString() + " is a newer minor version than " + targetVersion.getNumericVersionString());
        }
    }
}

