/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oracle.kv.impl.admin.param.SecurityParams;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterState;
import oracle.kv.impl.security.PasswordManager;
import oracle.kv.impl.security.PasswordStore;
import oracle.kv.impl.security.PasswordStoreException;
import oracle.kv.impl.security.util.ConsolePasswordReader;
import oracle.kv.impl.security.util.PasswordReader;
import oracle.kv.impl.security.util.SecurityUtils;
import oracle.kv.impl.util.ConfigUtils;
import oracle.kv.impl.util.SecurityConfigCommand;
import oracle.kv.impl.util.SecurityShell;
import oracle.kv.util.shell.Shell;

public class SecurityConfigCreator {
    private static final String PREFERRED_PROTOCOLS = "TLSv1.2,TLSv1.1,TLSv1";
    private static final int MIN_STORE_PASSPHRASE_LEN = 6;
    private String kvRoot;
    private final IOHelper ioHelper;
    private final ParsedConfig config;
    private final String pwdMgrClass;
    private static final String SHARED_KEY_ALIAS = "shared";
    private static final String SSL_CERT_DN = "CN=NoSQL";
    private static final String SSL_CLIENT_PEER = "CN=NoSQL";
    private static final String SSL_SERVER_PEER = "CN=NoSQL";
    private static final String INTERNAL_AUTH_SSL = "ssl";
    private static final String CERT_MODE_SHARED = "shared";
    private static final String CERT_MODE_SERVER = "server";
    private static final String PWD_ALIAS_KEYSTORE = "keystore";

    public SecurityConfigCreator(String kvRoot, ParsedConfig parsedConfig, IOHelper ioHelper) {
        this.kvRoot = kvRoot;
        this.ioHelper = ioHelper;
        this.config = parsedConfig;
        this.pwdMgrClass = SecurityConfigCommand.getPwdmgrClass(this.config.getPwdmgr());
    }

    public boolean createConfig() throws PasswordStoreException, Exception {
        this.config.populateDefaults();
        PasswordManager pwdMgr = this.resolvePwdMgr();
        if (pwdMgr == null) {
            return false;
        }
        File securityDir = this.prepareSecurityDir();
        if (securityDir == null) {
            return false;
        }
        char[] keyStorePassword = this.config.getKeystorePassword();
        if (keyStorePassword != null) {
            if (!this.validKeystorePassword(keyStorePassword)) {
                return false;
            }
        } else {
            try {
                keyStorePassword = this.promptForKeyStorePassword();
                if (keyStorePassword == null) {
                    this.ioHelper.println("No keystore password specified");
                    return false;
                }
            }
            catch (IOException ioe) {
                this.ioHelper.println("I/O error reading password: " + ioe.getMessage());
                return false;
            }
        }
        SecurityParams sp = this.makeSecurityParams();
        Properties keyStoreProperties = new Properties();
        keyStoreProperties.setProperty("distinguishedName", "CN=NoSQL");
        SecurityUtils.initKeyStore(securityDir, sp, keyStorePassword, keyStoreProperties);
        PasswordStore pwdStore = this.makePasswordStore(securityDir, sp);
        pwdStore.setSecret(PWD_ALIAS_KEYSTORE, keyStorePassword);
        pwdStore.save();
        pwdStore.discard();
        File securityXmlFile = new File(securityDir.getPath(), "security.xml");
        ConfigUtils.createSecurityConfig(sp, securityXmlFile);
        File securityFile = new File(securityDir.getPath(), "client.security");
        Properties securityProps = sp.getClientAccessProps();
        String trustStoreRef = securityProps.getProperty("oracle.kv.ssl.trustStore");
        if (trustStoreRef != null) {
            File srcFile = new File(securityDir, trustStoreRef);
            File destFile = new File(securityDir, "client.trust");
            SecurityUtils.copyOwnerWriteFile(srcFile, destFile);
            securityProps.put("oracle.kv.ssl.trustStore", "client.trust");
        }
        String securityComment = "Security property settings for communication with KVStore servers";
        ConfigUtils.storeProperties(securityProps, "Security property settings for communication with KVStore servers", securityFile);
        List<File> createdFiles = this.findSecurityFiles(securityDir);
        this.ioHelper.println("Created files");
        for (File f : createdFiles) {
            this.ioHelper.println("    " + f.getPath());
        }
        return true;
    }

    private List<File> findSecurityFiles(File securityDir) {
        ArrayList<File> result = new ArrayList<File>();
        this.findFiles(securityDir, result);
        return result;
    }

    private void findFiles(File securityDir, List<File> found) {
        for (File f : securityDir.listFiles()) {
            if (f.isDirectory()) {
                this.findFiles(f, found);
                continue;
            }
            found.add(f);
        }
    }

    private PasswordManager resolvePwdMgr() {
        try {
            return PasswordManager.load(this.pwdMgrClass);
        }
        catch (ClassNotFoundException cnfe) {
            this.ioHelper.println("Unable to locate password manager class '" + this.pwdMgrClass + "'");
            return null;
        }
        catch (Exception exc) {
            this.ioHelper.println("Creation of password manager class failed: " + exc.getMessage());
            return null;
        }
    }

    private File prepareSecurityDir() {
        File securityDir;
        File kvRootDir = new File(this.kvRoot);
        if (!kvRootDir.exists()) {
            this.ioHelper.println("The directory " + kvRootDir.getPath() + " does not exist");
            return null;
        }
        if (!kvRootDir.isAbsolute()) {
            kvRootDir = kvRootDir.getAbsoluteFile();
            this.kvRoot = kvRootDir.getPath();
        }
        if ((securityDir = new File(this.kvRoot, this.config.getSecurityDir())).exists()) {
            if (!this.directoryEmpty(securityDir)) {
                this.ioHelper.println("The directory " + securityDir.getPath() + " exists and is not empty");
                return null;
            }
        } else if (!securityDir.mkdir()) {
            this.ioHelper.println("Unable to create the directory " + securityDir.getPath());
            return null;
        }
        return securityDir;
    }

    private boolean directoryEmpty(File dir) {
        String[] entries = dir.list();
        return entries != null && entries.length == 0;
    }

    private PasswordStore makePasswordStore(File securityDir, SecurityParams sp) {
        PasswordManager pwdMgr = null;
        try {
            pwdMgr = PasswordManager.load(this.pwdMgrClass);
        }
        catch (ClassNotFoundException cnfe) {
            this.ioHelper.println("Unable to locate password manager class '" + this.pwdMgrClass + "'");
            return null;
        }
        catch (Exception exc) {
            this.ioHelper.println("Creation of password manager class failed: " + exc.getMessage());
            return null;
        }
        File storeLoc = new File(securityDir, new File(this.pwdMgrClass.equals("oracle.kv.impl.security.wallet.WalletManager") ? sp.getWalletDir() : sp.getPasswordFile()).getPath());
        PasswordStore pwdStore = pwdMgr.getStoreHandle(storeLoc);
        try {
            pwdStore.create(null);
            return pwdStore;
        }
        catch (IOException ioe) {
            this.ioHelper.println("Error creating password store: " + ioe.getMessage());
            return null;
        }
    }

    private SecurityParams makeSecurityParams() {
        SecurityParams sp = new SecurityParams();
        sp.setSecurityEnabled(true);
        if (this.pwdMgrClass.equals("oracle.kv.impl.security.wallet.WalletManager")) {
            sp.setWalletDir("store.wallet");
        } else {
            sp.setPasswordFile("store.passwd");
            sp.setPasswordClass(this.pwdMgrClass);
        }
        sp.setKeystorePasswordAlias(PWD_ALIAS_KEYSTORE);
        sp.setKeystoreFile("store.keys");
        sp.setTruststoreFile("store.trust");
        sp.setInternalAuth(INTERNAL_AUTH_SSL);
        sp.setCertMode("shared");
        sp.addTransportMap("client");
        sp.setTransType("client", INTERNAL_AUTH_SSL);
        sp.setTransServerKeyAlias("client", "shared");
        sp.setTransServerIdentityAllowed("client", "dnmatch(CN=NoSQL)");
        sp.setTransClientAllowProtocols("client", PREFERRED_PROTOCOLS);
        sp.addTransportMap("internal");
        sp.setTransType("internal", INTERNAL_AUTH_SSL);
        sp.setTransServerKeyAlias("internal", "shared");
        sp.setTransClientKeyAlias("internal", "shared");
        sp.setTransClientAuthRequired("internal", true);
        sp.setTransClientIdentityAllowed("internal", "dnmatch(CN=NoSQL)");
        sp.setTransServerIdentityAllowed("internal", "dnmatch(CN=NoSQL)");
        sp.setTransClientAllowProtocols("internal", PREFERRED_PROTOCOLS);
        sp.addTransportMap("ha");
        sp.setTransType("ha", INTERNAL_AUTH_SSL);
        sp.setTransServerKeyAlias("ha", "shared");
        sp.setTransClientAuthRequired("ha", true);
        sp.setTransClientIdentityAllowed("ha", "dnmatch(CN=NoSQL)");
        sp.setTransServerIdentityAllowed("ha", "dnmatch(CN=NoSQL)");
        sp.setTransAllowProtocols("ha", PREFERRED_PROTOCOLS);
        ParameterMap pmap = sp.getMap();
        List<ParsedConfig.ParamSetting> settings = this.config.getUserParams();
        for (ParsedConfig.ParamSetting setting : settings) {
            ParameterState pstate = setting.pstate;
            if (pstate.appliesTo(ParameterState.Info.TRANSPORT)) {
                if (setting.transportName == null) {
                    for (ParameterMap tmap : sp.getTransportMaps()) {
                        tmap.setParameter(setting.paramName, setting.paramValue);
                    }
                    continue;
                }
                ParameterMap tmap = sp.getTransportMap(setting.transportName);
                tmap.setParameter(setting.paramName, setting.paramValue);
                continue;
            }
            pmap.setParameter(setting.paramName, setting.paramValue);
        }
        return sp;
    }

    private char[] promptForKeyStorePassword() throws IOException {
        char[] pwd;
        while ((pwd = this.ioHelper.readPassword("Enter a password for the Java KeyStore:")) != null && pwd.length != 0) {
            if (!this.validKeystorePassword(pwd)) continue;
            char[] pwd2 = this.ioHelper.readPassword("Re-enter the KeyStore password for verification:");
            if (pwd2 != null && SecurityUtils.passwordsMatch(pwd, pwd2)) {
                return pwd;
            }
            this.ioHelper.println("The passwords do not match");
        }
        return null;
    }

    private boolean validKeystorePassword(char[] pwd) {
        if (pwd.length < 6) {
            this.ioHelper.println("The keystore password must be at least 6 characters long");
            return false;
        }
        return true;
    }

    static class GenericIOHelper
    implements IOHelper {
        private PrintStream printStream;
        private PasswordReader passwordReader;

        GenericIOHelper(PrintStream printStream) {
            this(printStream, new ConsolePasswordReader());
        }

        GenericIOHelper(PrintStream printStream, PasswordReader passwordReader) {
            this.printStream = printStream;
            this.passwordReader = passwordReader;
        }

        @Override
        public char[] readPassword(String prompt) throws IOException {
            return this.passwordReader.readPassword(prompt);
        }

        @Override
        public void println(String s) {
            this.printStream.println(s);
        }
    }

    static class ShellIOHelper
    implements IOHelper {
        private Shell shell;
        private PasswordReader passwordReader;

        ShellIOHelper(Shell shell) {
            this.shell = shell;
            this.passwordReader = null;
            if (shell instanceof SecurityShell) {
                this.passwordReader = ((SecurityShell)shell).getPasswordReader();
            }
            if (this.passwordReader == null) {
                this.passwordReader = new ConsolePasswordReader();
            }
        }

        @Override
        public char[] readPassword(String prompt) throws IOException {
            return this.passwordReader.readPassword(prompt);
        }

        @Override
        public void println(String s) {
            this.shell.println(s);
        }
    }

    public static interface IOHelper {
        public char[] readPassword(String var1) throws IOException;

        public void println(String var1);
    }

    public static class ParsedConfig {
        private String pwdmgr;
        private String secDir;
        private char[] ksPassword;
        private String certMode;
        private List<ParamSetting> userParams = new ArrayList<ParamSetting>();

        public void setPwdmgr(String pwdmgrVal) {
            this.pwdmgr = pwdmgrVal;
        }

        public String getPwdmgr() {
            return this.pwdmgr;
        }

        public void setKeystorePassword(char[] ksPwdVal) {
            this.ksPassword = ksPwdVal;
        }

        public char[] getKeystorePassword() {
            return this.ksPassword;
        }

        public void setSecurityDir(String securityDir) {
            this.secDir = securityDir;
        }

        public String getSecurityDir() {
            return this.secDir;
        }

        public void setCertMode(String certModeVal) {
            if (certModeVal != null && !"shared".equals(certModeVal) && !SecurityConfigCreator.CERT_MODE_SERVER.equals(certModeVal)) {
                throw new IllegalArgumentException("The value '" + certModeVal + "' is not a valid " + "certificate mode.  Only " + "shared" + " and " + SecurityConfigCreator.CERT_MODE_SERVER + " are allowed.");
            }
            this.certMode = certModeVal;
        }

        public String getCertMode() {
            return this.certMode;
        }

        public void addParam(String paramSetting) {
            int equalIdx = paramSetting.indexOf("=");
            if (equalIdx < 0) {
                throw new IllegalArgumentException("Invalid parameter setting - missing '='");
            }
            String param = paramSetting.substring(0, equalIdx);
            String value = paramSetting.substring(equalIdx + 1);
            String[] paramSplit = param.split(":");
            if (paramSplit.length > 2) {
                throw new IllegalArgumentException("Invalid parameter name format: " + param);
            }
            String paramName = paramSplit[paramSplit.length - 1];
            String transport = paramSplit.length > 1 ? paramSplit[0] : null;
            ParameterState pstate = ParameterState.lookup(paramName);
            if (pstate == null) {
                throw new IllegalArgumentException("The name " + paramName + " is not a valid parameter name");
            }
            if (!pstate.appliesTo(ParameterState.Info.SECURITY) && !pstate.appliesTo(ParameterState.Info.TRANSPORT)) {
                throw new IllegalArgumentException("The name " + paramName + " is not a valid parameter for " + "a security configuration");
            }
            if (transport != null) {
                if (!pstate.appliesTo(ParameterState.Info.TRANSPORT)) {
                    throw new IllegalArgumentException(paramName + " is not a transport parameter");
                }
                if (!("client".equals(transport) || "internal".equals(transport) || "ha".equals(transport))) {
                    throw new IllegalArgumentException(transport + " is not a valid transport name");
                }
            }
            this.userParams.add(new ParamSetting(pstate, transport, paramName, value));
        }

        public List<ParamSetting> getUserParams() {
            return this.userParams;
        }

        public void populateDefaults() {
            if (this.getSecurityDir() == null) {
                this.setSecurityDir("security");
            }
            if (this.getCertMode() == null) {
                this.setCertMode("shared");
            }
        }

        public class ParamSetting {
            final ParameterState pstate;
            final String transportName;
            final String paramName;
            final String paramValue;

            ParamSetting(ParameterState pstate, String transportName, String paramName, String paramValue) {
                this.pstate = pstate;
                this.transportName = transportName;
                this.paramName = paramName;
                this.paramValue = paramValue;
            }
        }
    }
}

