/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import oracle.kv.impl.security.PasswordManager;
import oracle.kv.impl.security.PasswordStore;
import oracle.kv.impl.security.PasswordStoreException;
import oracle.kv.impl.security.util.PasswordReader;
import oracle.kv.impl.security.util.SecurityUtils;
import oracle.kv.impl.util.SecurityShell;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellException;

class PwdfileCommand
extends CommandWithSubs {
    PwdfileCommand() {
        super(Arrays.asList(new PwdfileCreate(), new PwdfileSecret(), new PwdfileLogin()), "pwdfile", 4, 1);
    }

    @Override
    public String getCommandOverview() {
        return "The pwdfile command allows creation and modification of an Oracle NoSQL pwdfile.";
    }

    private static PasswordStore openStore(File pwdfileLoc, Shell shell) throws Exception {
        PasswordManager pwdMgr = PasswordManager.load("oracle.kv.impl.security.filestore.FileStoreManager");
        PasswordStore pwdfile = pwdMgr.getStoreHandle(pwdfileLoc);
        if (!pwdfile.exists()) {
            throw new ShellException("The store does not yet exist");
        }
        pwdfile.open(null);
        return pwdfile;
    }

    private static final class PwdfileLogin
    extends CommandWithSubs.SubCommand {
        private static final String LOGIN_COMMAND_NAME = "login";
        private static final String LOGIN_COMMAND_DESC = "Manipulate logins in an Oracle Pwdfile.";
        private static final String LOGIN_COMMAND_ARGS = "-file <pwdfile> -set [-secret <secret>] |-delete -database <db> -user <username>";

        private PwdfileLogin() {
            super(LOGIN_COMMAND_NAME, 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Action action;
            String file = null;
            String user = null;
            String db = null;
            String secret = null;
            EnumSet<Action> actions = EnumSet.noneOf(Action.class);
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-file".equals(arg)) {
                    file = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-database".equals(arg) || "-db".equals(arg)) {
                    db = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-user".equals(arg)) {
                    user = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-set".equals(arg)) {
                    actions.add(Action.SET);
                    continue;
                }
                if ("-list".equals(arg)) {
                    actions.add(Action.LIST);
                    continue;
                }
                if ("-delete".equals(arg)) {
                    actions.add(Action.DELETE);
                    continue;
                }
                if ("-secret".equals(arg)) {
                    secret = Shell.nextArg(args, i++, this);
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (file == null || actions.size() != 1) {
                shell.badArgCount(this);
            }
            if (((action = (Action)((Object)actions.iterator().next())) == Action.SET || action == Action.DELETE) && db == null) {
                shell.badArgCount(this);
            }
            if (action == Action.SET && user == null) {
                shell.badArgCount(this);
            }
            if (action == Action.LIST && (db != null || user != null)) {
                shell.badArgCount(this);
            }
            return this.doLogin(file, action, user, db, secret, shell);
        }

        @Override
        public String getCommandSyntax() {
            return "pwdfile login -file <pwdfile> -set [-secret <secret>] |-delete -database <db> -user <username>";
        }

        @Override
        public String getCommandDescription() {
            return LOGIN_COMMAND_DESC;
        }

        @Override
        protected boolean isHidden() {
            return true;
        }

        private String doLogin(String file, Action action, String user, String db, String secretArg, Shell shell) throws ShellException {
            try {
                PasswordStore pwdfile = PwdfileCommand.openStore(new File(file), shell);
                PasswordReader pwdReader = ((SecurityShell)shell).getPasswordReader();
                PasswordStore.LoginId loginId = new PasswordStore.LoginId(db, user);
                if (action == Action.SET) {
                    char[] verifySecret;
                    char[] secret;
                    if (secretArg != null) {
                        verifySecret = secret = secretArg.toCharArray();
                    } else {
                        secret = pwdReader.readPassword("Enter the secret value to store: ");
                        verifySecret = pwdReader.readPassword("Re-enter the secret value for verification: ");
                    }
                    if (SecurityUtils.passwordsMatch(secret, verifySecret)) {
                        if (pwdfile.setLogin(loginId, secret)) {
                            shell.println("Login updated");
                        } else {
                            shell.println("Login created");
                        }
                        pwdfile.save();
                    } else {
                        shell.println("The passwords do not match");
                    }
                } else if (action == Action.DELETE) {
                    PasswordStore.LoginId pwdfileLoginId = pwdfile.getLoginId(loginId.getDatabase());
                    if (pwdfileLoginId != null) {
                        if (loginId.getUser() == null || loginId.getUser().equals(pwdfileLoginId.getUser())) {
                            pwdfile.deleteLogin(loginId.getDatabase());
                            pwdfile.save();
                            shell.println("Login deleted");
                        } else {
                            shell.println("The specified user does not match the pwdfile entry");
                        }
                    } else {
                        shell.println("Login did not exist");
                    }
                } else if (action == Action.LIST) {
                    Collection<PasswordStore.LoginId> logins = pwdfile.getLogins();
                    if (logins.size() == 0) {
                        shell.println("The pwdfile contains no logins");
                    } else {
                        shell.println("The pwdfile contains the following logins:");
                        for (PasswordStore.LoginId lid : logins) {
                            shell.println("   " + lid.getDatabase() + " as " + lid.getUser());
                        }
                    }
                }
                return "";
            }
            catch (ShellException se) {
                throw se;
            }
            catch (PasswordStoreException pwse) {
                throw new ShellException("PasswordStore error: " + pwse.getMessage(), pwse);
            }
            catch (Exception e) {
                throw new ShellException("Unknown error: " + e.getMessage(), e);
            }
        }
    }

    private static final class PwdfileSecret
    extends CommandWithSubs.SubCommand {
        private static final String SECRET_COMMAND_NAME = "secret";
        private static final String SECRET_COMMAND_DESC = "Manipulate secrets in a password file.";
        private static final String SECRET_COMMAND_ARGS = "-file <pwdfile> {-set -alias <aliasname> [ -secret <secret> ]} | {-delete -alias <aliasname>} | {-list}";

        private PwdfileSecret() {
            super(SECRET_COMMAND_NAME, 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Action action;
            String file = null;
            String alias = null;
            String secret = null;
            EnumSet<Action> actions = EnumSet.noneOf(Action.class);
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-file".equals(arg)) {
                    file = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-alias".equals(arg)) {
                    alias = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-set".equals(arg)) {
                    actions.add(Action.SET);
                    continue;
                }
                if ("-list".equals(arg)) {
                    actions.add(Action.LIST);
                    continue;
                }
                if ("-delete".equals(arg)) {
                    actions.add(Action.DELETE);
                    continue;
                }
                if ("-secret".equals(arg)) {
                    secret = Shell.nextArg(args, i++, this);
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (file == null || actions.size() != 1) {
                shell.badArgCount(this);
            }
            if (((action = (Action)((Object)actions.iterator().next())) == Action.SET || action == Action.DELETE) && alias == null) {
                shell.badArgCount(this);
            }
            if (action == Action.LIST && alias != null) {
                shell.badArgCount(this);
            }
            return this.doSecret(file, action, alias, secret, shell);
        }

        @Override
        public String getCommandSyntax() {
            return "pwdfile secret -file <pwdfile> {-set -alias <aliasname> [ -secret <secret> ]} | {-delete -alias <aliasname>} | {-list}";
        }

        @Override
        public String getCommandDescription() {
            return SECRET_COMMAND_DESC;
        }

        private String doSecret(String file, Action action, String alias, String secretArg, Shell shell) throws ShellException {
            try {
                PasswordStore pwdfile = PwdfileCommand.openStore(new File(file), shell);
                PasswordReader pwdReader = ((SecurityShell)shell).getPasswordReader();
                if (action == Action.SET) {
                    char[] verifySecret;
                    char[] secret;
                    if (secretArg != null) {
                        verifySecret = secret = secretArg.toCharArray();
                    } else {
                        secret = pwdReader.readPassword("Enter the secret value to store: ");
                        verifySecret = pwdReader.readPassword("Re-enter the secret value for verification: ");
                    }
                    if (SecurityUtils.passwordsMatch(secret, verifySecret)) {
                        if (pwdfile.setSecret(alias, secret)) {
                            shell.println("Secret updated");
                        } else {
                            shell.println("Secret created");
                        }
                        pwdfile.save();
                    } else {
                        shell.println("The passwords do not match");
                    }
                } else if (action == Action.DELETE) {
                    if (pwdfile.deleteSecret(alias)) {
                        pwdfile.save();
                        shell.println("Secret deleted");
                    } else {
                        shell.println("Secret did not exist");
                    }
                } else if (action == Action.LIST) {
                    Collection<String> secretAliases = pwdfile.getSecretAliases();
                    if (secretAliases.size() == 0) {
                        shell.println("The pwdfile contains no secrets");
                    } else {
                        shell.println("The pwdfile contains the following secrets:");
                        for (String s : secretAliases) {
                            shell.println("   " + s);
                        }
                    }
                }
                return "OK";
            }
            catch (ShellException se) {
                throw se;
            }
            catch (PasswordStoreException pwse) {
                throw new ShellException("PasswordStore error: " + pwse.getMessage(), pwse);
            }
            catch (Exception e) {
                throw new ShellException("Unknown error: " + e.getMessage(), e);
            }
        }
    }

    private static final class PwdfileCreate
    extends CommandWithSubs.SubCommand {
        private static final String CREATE_COMMAND_NAME = "create";
        private static final String CREATE_COMMAND_DESC = "Creates a new password file.";
        private static final String CREATE_COMMAND_ARGS = "-file <pwdfile>";

        private PwdfileCreate() {
            super(CREATE_COMMAND_NAME, 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            String file = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-file".equals(arg)) {
                    file = Shell.nextArg(args, i++, this);
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (file == null) {
                shell.requiredArg("-file", this);
            }
            return this.doCreate(file, shell);
        }

        private String doCreate(String file, Shell shell) throws ShellException {
            try {
                PasswordManager pwdMgr = PasswordManager.load("oracle.kv.impl.security.filestore.FileStoreManager");
                File pwdfileLoc = new File(file);
                PasswordStore pwdfile = pwdMgr.getStoreHandle(pwdfileLoc);
                if (pwdfile.exists()) {
                    return "A pwdfile already exists at that location";
                }
                char[] pwd = null;
                pwdfile.create(pwd);
                return "Created";
            }
            catch (PasswordStoreException pwse) {
                throw new ShellException("PasswordStore error: " + pwse.getMessage(), pwse);
            }
            catch (Exception e) {
                throw new ShellException("Unexpected error: " + e.getMessage(), e);
            }
        }

        @Override
        public String getCommandSyntax() {
            return "pwdfile create -file <pwdfile>";
        }

        @Override
        public String getCommandDescription() {
            return CREATE_COMMAND_DESC;
        }
    }

    private static enum Action {
        SET,
        DELETE,
        LIST;

    }
}

