/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.je.LockMode;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.TopologyHolder;

public class TopologyServerUtil {
    public static void persist(Topology topology, EntityStore estore, Transaction txn) {
        PrimaryIndex ti = estore.getPrimaryIndex(String.class, TopologyHolder.class);
        ti.put(txn, (Object)new TopologyHolder(topology));
    }

    public static Topology fetch(EntityStore estore, Transaction txn) {
        PrimaryIndex ti = estore.getPrimaryIndex(String.class, TopologyHolder.class);
        TopologyHolder holder = (TopologyHolder)ti.get(txn, (Object)TopologyHolder.getKey(), LockMode.READ_UNCOMMITTED);
        return holder == null ? null : holder.getTopology();
    }

    public static Topology fetchCommitted(EntityStore estore, Transaction txn) {
        PrimaryIndex ti = estore.getPrimaryIndex(String.class, TopologyHolder.class);
        TopologyHolder holder = (TopologyHolder)ti.get(txn, (Object)TopologyHolder.getKey(), LockMode.READ_COMMITTED);
        return holder == null ? null : holder.getTopology();
    }
}

