/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.sna;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.kv.impl.measurement.ProxiedServiceStatusChange;
import oracle.kv.impl.mgmt.MgmtAgent;
import oracle.kv.impl.monitor.AgentRepository;
import oracle.kv.impl.sna.ManagedService;
import oracle.kv.impl.sna.ProcessMonitor;
import oracle.kv.impl.sna.ServiceManager;
import oracle.kv.impl.sna.StorageNodeAgent;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.ConfigurableService;

public class ProcessServiceManager
extends ServiceManager {
    private AgentRepository agentRepository;
    private ProcessMonitor monitor;
    private final MgmtAgent mgmtAgent;
    private static String pathToJava;
    private final StorageNodeAgent sna;

    public ProcessServiceManager(StorageNodeAgent sna, ManagedService service) {
        super(sna, service);
        this.sna = sna;
        this.mgmtAgent = sna.getMgmtAgent();
        this.agentRepository = null;
        this.monitor = null;
        this.registered(sna);
    }

    @Override
    public void registered(StorageNodeAgent sna1) {
        if (this.agentRepository == null) {
            this.agentRepository = sna1.getMonitorAgent() != null ? sna1.getMonitorAgent().getAgentRepository() : null;
        }
    }

    @Override
    public void start() throws Exception {
        List<String> command = this.createExecArgs();
        if (this.logger != null) {
            this.logger.info("Executing process with arguments: " + command);
        }
        this.monitor = new ServiceProcessMonitor(this, command);
        this.monitor.startProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            if (this.monitor != null) {
                this.monitor.stopProcess(false);
            }
        }
        catch (InterruptedException ie) {
        }
        finally {
            this.monitor.destroyProcess();
            try {
                this.monitor.waitProcess(0L);
            }
            catch (InterruptedException ignored) {}
        }
    }

    @Override
    public void waitFor(int millis) {
        try {
            if (this.monitor != null && !this.monitor.waitProcess(millis)) {
                this.logger.info("Service did not exiting cleanly in " + millis + " milliseconds, it will be killed");
                this.stop();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void dontRestart() {
        if (this.monitor != null) {
            this.monitor.dontRestart();
        }
    }

    @Override
    public boolean isRunning() {
        if (this.monitor != null) {
            return this.monitor.isRunning();
        }
        return false;
    }

    @Override
    public void reset() {
        List<String> command = this.createExecArgs();
        this.monitor.reset(command, this.service.getServiceName());
    }

    @Override
    public boolean forceOK(boolean force) {
        return force;
    }

    @Override
    public void resetLogger(Logger logger1) {
        this.logger = logger1;
        this.monitor.resetLogger(this.logger);
    }

    void destroy() {
        if (this.monitor != null) {
            this.monitor.destroyProcess();
            try {
                this.monitor.waitProcess(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private String findJava() {
        String path;
        String home = System.getProperty("java.home");
        String cp = System.getProperty("java.class.path");
        String execString = path = home + File.separator + "bin" + File.separator + "java";
        if (cp != null) {
            execString = execString + " -cp " + cp;
        }
        execString = execString + " " + this.getClass().getName() + "$TestJavaExec";
        try {
            Process process = Runtime.getRuntime().exec(execString);
            process.waitFor();
            if (process.exitValue() == 75) {
                return path;
            }
        }
        catch (Exception e) {
            this.logger.info("Unable to exec test process: " + execString + ", exception: " + e);
        }
        return "java";
    }

    private synchronized String getPathToJava() {
        if (pathToJava == null) {
            pathToJava = this.findJava();
            this.logger.info("Using java program: " + pathToJava + " to execute managed processes");
        }
        return pathToJava;
    }

    private void addJavaMiscArgs(List<String> command, String jvmArgs) {
        String miscParams = "";
        if (this.service.getDefaultJavaArgs(jvmArgs) != null) {
            miscParams = this.service.getDefaultJavaArgs(jvmArgs);
        }
        if (jvmArgs != null) {
            miscParams = miscParams + " " + jvmArgs;
        }
        if (miscParams.length() != 0) {
            String[] args;
            for (String arg : args = miscParams.trim().split("\\s+")) {
                arg = arg.replaceAll("^\"|\"$", "");
                arg = arg.replaceAll("^'|'$", "");
                command.add(arg);
            }
        }
    }

    private void addJavaExtraArgs(List<String> command) {
        String jvmExtraArgs = System.getProperty("oracle.kv.jvm.extraargs");
        if (jvmExtraArgs != null) {
            for (String arg : ProcessServiceManager.splitExtraArgs(jvmExtraArgs)) {
                command.add(arg);
            }
            command.add("-Doracle.kv.jvm.extraargs=" + jvmExtraArgs);
        }
    }

    private static String[] splitExtraArgs(String extraArgs) {
        return extraArgs.split(";");
    }

    private void addLoggingArgs(List<String> command, String loggingConfig) {
        if (loggingConfig == null || loggingConfig.length() == 0) {
            return;
        }
        String logConfigFile = this.service.createLoggingConfigFile(loggingConfig);
        if (logConfigFile != null) {
            command.add("-Djava.util.logging.config.file=" + logConfigFile);
        }
    }

    private boolean addAssertions(List<String> command) {
        command.add("-ea");
        return true;
    }

    private List<String> createExecArgs() {
        ArrayList<String> command = new ArrayList<String>();
        String customStartupPrefix = this.sna.getCustomProcessStartupPrefix();
        if (customStartupPrefix != null && !customStartupPrefix.isEmpty()) {
            command.add(customStartupPrefix);
        }
        command.add(this.getPathToJava());
        command.add("-cp");
        command.add(System.getProperty("java.class.path"));
        String jvmArgs = this.service.getJVMArgs();
        String loggingConfig = this.service.getLoggingConfig();
        this.addJavaMiscArgs(command, jvmArgs);
        this.addJavaExtraArgs(command);
        assert (this.addAssertions(command));
        if (loggingConfig != null) {
            this.addLoggingArgs(command, loggingConfig);
        } else {
            String logConfig = System.getProperty("java.util.logging.config.file");
            if (logConfig != null) {
                command.add("-Djava.util.logging.config.file=" + logConfig);
            }
        }
        return this.service.addExecArgs(command);
    }

    public static class TestJavaExec {
        public static final int EXITCODE = 75;

        public static void main(String[] args) {
            System.exit(75);
        }
    }

    class ServiceProcessMonitor
    extends ProcessMonitor {
        private final ServiceManager mgr;

        public ServiceProcessMonitor(ServiceManager mgr, List<String> command) {
            super(command, -1, ProcessServiceManager.this.service.getServiceName(), ProcessServiceManager.this.logger);
            this.mgr = mgr;
        }

        private void generateStatusChange(ConfigurableService.ServiceStatus status) {
            if (ProcessServiceManager.this.agentRepository != null) {
                ResourceId rid = ProcessServiceManager.this.getService().getResourceId();
                ProxiedServiceStatusChange sc = new ProxiedServiceStatusChange(rid, status);
                ProcessServiceManager.this.agentRepository.add(sc);
                ProcessServiceManager.this.mgmtAgent.proxiedStatusChange(sc);
            }
        }

        @Override
        protected void onExit(int exitCode) {
            ProcessServiceManager.this.service.setStartupBuffer(this.startupBuffer);
            ResourceId rId = ProcessServiceManager.this.service.getResourceId();
            if (rId instanceof RepNodeId && ProcessServiceManager.this.sna.getMasterBalanceManager() != null) {
                ProcessServiceManager.this.sna.getMasterBalanceManager().noteExit((RepNodeId)rId);
            }
            if (exitCode != 0) {
                this.generateStatusChange(ConfigurableService.ServiceStatus.ERROR_NO_RESTART);
            } else {
                this.generateStatusChange(ConfigurableService.ServiceStatus.STOPPED);
            }
        }

        @Override
        protected void onRestart() {
            ResourceId rId = ProcessServiceManager.this.service.getResourceId();
            if (rId instanceof RepNodeId) {
                ProcessServiceManager.this.sna.getMasterBalanceManager().noteExit((RepNodeId)rId);
            }
            this.generateStatusChange(ConfigurableService.ServiceStatus.ERROR_RESTARTING);
            ProcessServiceManager.this.service.resetHandles();
            ProcessServiceManager.this.service.resetParameters(false);
            if (ProcessServiceManager.this.service.resetOnRestart()) {
                this.mgr.reset();
            }
        }

        @Override
        protected void afterStart() {
            this.mgr.notifyStarted();
        }
    }
}

