/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.sna;

import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import oracle.kv.impl.admin.AdminService;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.BootstrapParams;
import oracle.kv.impl.sna.ManagedAdmin;
import oracle.kv.impl.sna.StorageNodeAgent;
import oracle.kv.impl.util.ConfigUtils;
import oracle.kv.impl.util.server.LoggerUtils;

public class ManagedBootstrapAdmin
extends ManagedAdmin {
    private final String bootstrapConfigFile;

    public ManagedBootstrapAdmin(StorageNodeAgent sna) {
        super(new File(sna.getBootstrapDir()), sna.getSecurityDir(), sna.makeBootstrapAdminName());
        this.bootstrapConfigFile = sna.getBootstrapFile();
    }

    public ManagedBootstrapAdmin(String rootDir, String secDir, String configFile, String serviceName) throws Exception {
        super(new File(rootDir), ManagedBootstrapAdmin.nullableFile(secDir), serviceName);
        this.bootstrapConfigFile = configFile;
        this.logger = LoggerUtils.getLogger(AdminService.class, serviceName);
    }

    public void resetAsManagedAdmin(AdminParams newAp, File newRoot, File newSecDir, File newSNDir, String newName, Logger logger1) {
        this.ap = newAp;
        this.kvRootDir = newRoot;
        this.kvSecDir = newSecDir;
        this.kvSNDir = newSNDir;
        this.kvName = newName;
        this.params = this.ap.getMap();
        this.serviceName = this.ap.getAdminId().getFullName();
        this.logger = logger1;
    }

    @Override
    public void start(boolean threads) {
        File configPath = new File(this.kvSNDir, this.bootstrapConfigFile);
        this.logger.fine("Starting BootstrapAdmin using configuration file " + configPath);
        BootstrapParams bp = ConfigUtils.getBootstrapParams(configPath);
        this.sp = this.getSecurityParameters();
        this.sp.initRMISocketPolicies();
        if (!threads) {
            BootstrapParams.initRegistryCSF(this.sp);
        }
        AdminService as = new AdminService(bp, this.sp, threads);
        as.start();
    }

    @Override
    public boolean resetOnRestart() {
        return true;
    }

    @Override
    public void additionalExecArgs(List<String> command) {
        command.add("-config");
        command.add(this.bootstrapConfigFile);
    }

    @Override
    public int additionalArgs(String[] args, int index) {
        args[index++] = "-config";
        args[index++] = this.bootstrapConfigFile;
        return index;
    }
}

