/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.util.List;
import javax.security.auth.Subject;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.LoginToken;
import oracle.kv.impl.security.login.SessionId;
import oracle.kv.impl.security.login.TokenCache;
import oracle.kv.impl.security.login.TokenResolver;
import oracle.kv.impl.security.metadata.KVStoreUser;
import oracle.kv.impl.security.util.CacheBuilder;

public class TokenVerifier {
    private final TokenResolver tokenResolver;
    private volatile TokenCache tokenCache;

    public TokenVerifier(CacheBuilder.CacheConfig cacheConfig, TokenResolver tokenResolver) {
        this.tokenResolver = tokenResolver;
        this.tokenCache = cacheConfig == null ? null : new TokenCache(cacheConfig, tokenResolver);
    }

    public Subject verifyToken(LoginToken token) throws SessionAccessException {
        Subject subject;
        Subject subject2 = subject = null == this.tokenCache ? null : this.tokenCache.lookup(token);
        if (subject != null) {
            return subject;
        }
        subject = this.tokenResolver.resolve(token);
        if (subject != null && this.tokenCache != null) {
            this.tokenCache.add(token, subject);
        }
        return subject;
    }

    public boolean updateLoginCacheSize(int newSize) {
        if (newSize == this.tokenCache.getCacheSize()) {
            return false;
        }
        long entryLifeTime = this.tokenCache.getEntryLifeTime();
        TokenCache oldCache = this.tokenCache;
        this.tokenCache = new TokenCache(new CacheBuilder.CacheConfig().capacity(newSize).entryLifetime(entryLifeTime), this.tokenResolver);
        if (oldCache != null) {
            oldCache.stop(false);
        }
        return true;
    }

    public boolean updateLoginCacheTimeout(long newTimeoutInMillis) {
        if (this.tokenCache == null || newTimeoutInMillis == this.tokenCache.getEntryLifeTime()) {
            return false;
        }
        this.tokenCache.setEntryLifeTime(newTimeoutInMillis);
        return true;
    }

    public boolean updateLoginCacheSessions(KVStoreUser user) {
        if (this.tokenCache == null) {
            return false;
        }
        Subject newSubject = user.makeKVSubject();
        List<SessionId> sessIds = this.tokenCache.lookupSessionByUser(user.getName());
        if (sessIds.size() == 0) {
            return false;
        }
        for (SessionId id : sessIds) {
            this.tokenCache.updateSessionSubject(id, newSubject);
        }
        return true;
    }
}

