/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class LoginErrorTracker {
    private static final int BUCKET_COUNT = 20;
    private long acctErrLockoutInt;
    private int acctErrLockoutCnt;
    private long acctErrLockoutTMO;
    private final long trackerStartTime;
    private final long bucketSize;
    private final ConcurrentHashMap<String, UserRecord> userMap;
    private final Logger logger;

    public LoginErrorTracker(long accountErrorLockoutInterval, int accountErrorLockoutCount, long accountErrorLockoutTimeout, Logger logger) {
        this.acctErrLockoutInt = accountErrorLockoutInterval;
        this.acctErrLockoutCnt = accountErrorLockoutCount;
        this.acctErrLockoutTMO = accountErrorLockoutTimeout;
        this.bucketSize = this.acctErrLockoutInt / 20L;
        this.userMap = new ConcurrentHashMap();
        this.trackerStartTime = System.currentTimeMillis();
        this.logger = logger;
    }

    public boolean isAccountLocked(String username, String clientHost) {
        String userKey = this.userMapKey(username, clientHost);
        UserRecord userRecord = this.userMap.get(userKey);
        if (userRecord == null || !userRecord.checkLockedOut()) {
            return false;
        }
        if (userRecord.tryUnlock()) {
            if (this.logger != null) {
                this.logger.info("The lockout on the account for user " + username + " from " + clientHost + " has been lifted.");
            }
            return false;
        }
        return true;
    }

    void noteLoginError(String username, String clientHost) {
        UserRecord existingRecord;
        String userKey = this.userMapKey(username, clientHost);
        UserRecord userRecord = this.userMap.get(userKey);
        if (userRecord == null && (existingRecord = this.userMap.putIfAbsent(userKey, userRecord = new UserRecord())) != null) {
            userRecord = existingRecord;
        }
        if (userRecord.noteError() && this.logger != null) {
            this.logger.info("Account for user " + username + " from " + clientHost + " has been temporarily locked out " + "due to excessive login errors.");
        }
    }

    void noteLoginSuccess(String username, String clientHost) {
        String userKey = this.userMapKey(username, clientHost);
        UserRecord userRecord = this.userMap.get(userKey);
        if (userRecord != null) {
            userRecord.clearErrors();
        }
    }

    private String userMapKey(String username, String clientHost) {
        return username + ":" + clientHost;
    }

    private final class UserRecord {
        private final int[] errorBuckets = new int[20];
        private int firstBucketIdx = 0;
        private long lockoutStartTime = 0L;
        private volatile boolean isLockedOut = false;

        private UserRecord() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean noteError() {
            long now = System.currentTimeMillis();
            UserRecord userRecord = this;
            synchronized (userRecord) {
                int nowBucketIdx = (int)((now - LoginErrorTracker.this.trackerStartTime) / LoginErrorTracker.this.bucketSize);
                this.alignBuckets(nowBucketIdx);
                if (this.errorBuckets[nowBucketIdx - this.firstBucketIdx] < Integer.MAX_VALUE) {
                    int n = nowBucketIdx - this.firstBucketIdx;
                    this.errorBuckets[n] = this.errorBuckets[n] + 1;
                }
                if (this.errorCountsExceeded(nowBucketIdx)) {
                    this.lockoutStartTime = System.currentTimeMillis();
                    this.isLockedOut = true;
                }
            }
            return this.isLockedOut;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearErrors() {
            UserRecord userRecord = this;
            synchronized (userRecord) {
                Arrays.fill(this.errorBuckets, 0);
            }
        }

        private boolean checkLockedOut() {
            return this.isLockedOut;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean tryUnlock() {
            long now = System.currentTimeMillis();
            UserRecord userRecord = this;
            synchronized (userRecord) {
                if (!this.isLockedOut) {
                    return false;
                }
                if (now - this.lockoutStartTime > LoginErrorTracker.this.acctErrLockoutTMO) {
                    int nowBucketIdx = (int)((now - LoginErrorTracker.this.trackerStartTime) / LoginErrorTracker.this.bucketSize);
                    this.alignBuckets(nowBucketIdx);
                    if (!this.errorCountsExceeded(nowBucketIdx)) {
                        this.isLockedOut = false;
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean errorCountsExceeded(int nowBucketIdx) {
            int lastBucketIdx;
            assert (Thread.holdsLock(this));
            long errorTotal = 0L;
            for (int i = lastBucketIdx = nowBucketIdx - this.firstBucketIdx; i >= 0; --i) {
                errorTotal += (long)this.errorBuckets[i];
            }
            return errorTotal >= (long)LoginErrorTracker.this.acctErrLockoutCnt;
        }

        private void alignBuckets(int nowBucketIdx) {
            assert (Thread.holdsLock(this));
            int lastBucketIdx = this.firstBucketIdx + 19;
            if (nowBucketIdx > lastBucketIdx) {
                int keepBuckets = lastBucketIdx - (nowBucketIdx - 20);
                if (keepBuckets <= 0) {
                    Arrays.fill(this.errorBuckets, 0);
                    this.firstBucketIdx = nowBucketIdx;
                } else {
                    int loseBuckets = 20 - keepBuckets;
                    for (int i = 0; i < keepBuckets; ++i) {
                        this.errorBuckets[i] = this.errorBuckets[loseBuckets + i];
                    }
                    Arrays.fill(this.errorBuckets, keepBuckets, 20, 0);
                    this.firstBucketIdx += loseBuckets;
                }
            } else if (nowBucketIdx < this.firstBucketIdx) {
                int keepBuckets = 20 - (this.firstBucketIdx - nowBucketIdx);
                if (keepBuckets <= 0) {
                    Arrays.fill(this.errorBuckets, 0);
                    this.firstBucketIdx = nowBucketIdx;
                } else {
                    int loseBuckets = 20 - keepBuckets;
                    for (int i = 0; i < keepBuckets; ++i) {
                        this.errorBuckets[20 - i] = this.errorBuckets[20 - loseBuckets - i];
                    }
                    Arrays.fill(this.errorBuckets, 0, loseBuckets, 0);
                    this.firstBucketIdx = nowBucketIdx - 20 + 1;
                }
            }
        }
    }
}

