/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicatedEnvironmentStats;
import com.sleepycat.je.rep.impl.networkRestore.NetworkBackupStats;
import com.sleepycat.je.rep.utilint.HostPortPair;
import java.io.Serializable;
import oracle.kv.impl.rep.MasterRepNodeStats;
import oracle.kv.impl.rep.migration.PartitionMigrationStatus;
import oracle.kv.impl.util.ConfigurableService;

public class RepNodeStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ConfigurableService.ServiceStatus status;
    private final ReplicatedEnvironment.State state;
    private final long vlsn;
    private final String haHostPort;
    private final PartitionMigrationStatus[] migrationStatus;
    private final int haPort;
    private final MasterRepNodeStats masterRepNodeStats;
    private final NetworkBackupStats networkRestoreStats;

    public RepNodeStatus(ConfigurableService.ServiceStatus status, ReplicatedEnvironment.State state, long vlsn, String haHostPort, PartitionMigrationStatus[] migrationStatus, ReplicatedEnvironmentStats replicatedEnvStats, NetworkBackupStats networkRestoreStats) {
        this.status = status;
        this.state = state;
        this.vlsn = vlsn;
        this.haHostPort = haHostPort;
        this.migrationStatus = migrationStatus;
        this.haPort = HostPortPair.getPort((String)haHostPort);
        this.masterRepNodeStats = MasterRepNodeStats.create(replicatedEnvStats);
        this.networkRestoreStats = networkRestoreStats;
    }

    public ConfigurableService.ServiceStatus getServiceStatus() {
        return this.status;
    }

    public ReplicatedEnvironment.State getReplicationState() {
        return this.state;
    }

    public long getVlsn() {
        return this.vlsn;
    }

    public int getHAPort() {
        return this.haPort;
    }

    public String getHAHostPort() {
        return this.haHostPort;
    }

    public PartitionMigrationStatus[] getPartitionMigrationStatus() {
        return this.migrationStatus == null ? new PartitionMigrationStatus[]{} : this.migrationStatus;
    }

    public MasterRepNodeStats getMasterRepNodeStats() {
        return this.masterRepNodeStats;
    }

    public NetworkBackupStats getNetworkRestoreStats() {
        return this.networkRestoreStats;
    }

    public long getNetworkRestoreTimeSecs() {
        if (this.networkRestoreStats != null) {
            long remainingBytes = this.networkRestoreStats.getExpectedBytes() - this.networkRestoreStats.getTransferredBytes();
            double transferRate = this.networkRestoreStats.getTransferRate();
            return (long)Math.ceil((double)remainingBytes / transferRate);
        }
        return 0L;
    }

    public String toString() {
        return (Object)((Object)this.status) + "," + (Object)((Object)this.state);
    }
}

