/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep;

import java.util.logging.Logger;
import javax.security.auth.Subject;
import oracle.kv.LoginCredentials;
import oracle.kv.PasswordCredentials;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.SecurityParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.api.RequestDispatcher;
import oracle.kv.impl.api.TopologyManager;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.rep.login.FailoverSessionManager;
import oracle.kv.impl.rep.login.KVSessionManager;
import oracle.kv.impl.security.AccessChecker;
import oracle.kv.impl.security.AccessCheckerImpl;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.KVBuiltInRoleResolver;
import oracle.kv.impl.security.KVStoreUserPrincipal;
import oracle.kv.impl.security.PasswordExpiredException;
import oracle.kv.impl.security.ProxyCredentials;
import oracle.kv.impl.security.RoleInstance;
import oracle.kv.impl.security.RoleResolver;
import oracle.kv.impl.security.SignatureHelper;
import oracle.kv.impl.security.TopoSignatureHelper;
import oracle.kv.impl.security.UserVerifier;
import oracle.kv.impl.security.login.InternalLoginManager;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.login.LoginUpdater;
import oracle.kv.impl.security.login.TokenResolverImpl;
import oracle.kv.impl.security.login.TokenVerifier;
import oracle.kv.impl.security.login.TopoTopoResolver;
import oracle.kv.impl.security.login.TopologyResolver;
import oracle.kv.impl.security.metadata.KVStoreUser;
import oracle.kv.impl.security.metadata.SecurityMDChange;
import oracle.kv.impl.security.metadata.SecurityMDUpdater;
import oracle.kv.impl.security.metadata.SecurityMetadata;
import oracle.kv.impl.security.util.CacheBuilder;
import oracle.kv.impl.topo.Topology;

public class RepNodeSecurity
implements LoginUpdater.GlobalParamsUpdater,
LoginUpdater.ServiceParamsUpdater,
SecurityMDUpdater.UserChangeUpdater,
SecurityMDUpdater.RoleChangeUpdater {
    private final RepNodeService repNodeService;
    private final AccessCheckerImpl accessChecker;
    private final TokenResolverImpl tokenResolver;
    private final TopoTopoResolver.TopoMgrTopoHandle topoMgrHandle;
    private final TopoTopoResolver topoResolver;
    private final InternalLoginManager loginMgr;
    private final String storeName;
    private final TokenVerifier tokenVerifier;
    private final Logger logger;
    private final UserVerifier userVerifier;
    private final SignatureHelper<Topology> topoSignatureHelper;
    private KVSessionManager kvSessionManager;
    private static final int CHECKER_SUBJECT_CACHE_SIZE = 100;

    public RepNodeSecurity(RepNodeService rnService, Logger logger) {
        this.repNodeService = rnService;
        this.logger = logger;
        RepNodeService.Params params = rnService.getParams();
        SecurityParams secParams = params.getSecurityParams();
        this.storeName = params.getGlobalParams().getKVStoreName();
        this.kvSessionManager = null;
        if (secParams.isSecure()) {
            this.userVerifier = new RepNodeUserVerifier();
            StorageNodeParams snParams = params.getStorageNodeParams();
            String hostname = snParams.getHostname();
            int registryPort = snParams.getRegistryPort();
            this.topoMgrHandle = new TopoTopoResolver.TopoMgrTopoHandle(null);
            TopologyResolver.SNInfo localSNInfo = new TopologyResolver.SNInfo(hostname, registryPort, rnService.getStorageNodeId());
            this.topoResolver = new TopoTopoResolver(this.topoMgrHandle, localSNInfo, logger);
            this.loginMgr = new InternalLoginManager(this.topoResolver);
            this.tokenResolver = new TokenResolverImpl(hostname, registryPort, this.storeName, this.topoResolver, this.loginMgr, logger);
            RepNodeParams rp = rnService.getRepNodeParams();
            int tokenCacheCapacity = rp.getLoginCacheSize();
            GlobalParams gp = rnService.getParams().getGlobalParams();
            long tokenCacheEntryLifetime = gp.getLoginCacheTimeoutUnit().toMillis(gp.getLoginCacheTimeout());
            CacheBuilder.CacheConfig tokenCacheConfig = new CacheBuilder.CacheConfig().capacity(tokenCacheCapacity).entryLifetime(tokenCacheEntryLifetime);
            this.tokenVerifier = new TokenVerifier(tokenCacheConfig, this.tokenResolver);
            long subjCacheTimeout = gp.getSessionTimeout();
            CacheBuilder.CacheConfig subjectCacheConfig = new CacheBuilder.CacheConfig().capacity(100).entryLifetime(subjCacheTimeout);
            this.accessChecker = new AccessCheckerImpl(this.tokenVerifier, new RepNodeRoleResolver(), subjectCacheConfig, logger);
            this.topoSignatureHelper = TopoSignatureHelper.buildFromSecurityParams(secParams);
        } else {
            this.userVerifier = null;
            this.accessChecker = null;
            this.tokenResolver = null;
            this.topoMgrHandle = null;
            this.topoResolver = null;
            this.loginMgr = null;
            this.tokenVerifier = null;
            this.topoSignatureHelper = null;
        }
    }

    void setDispatcher(RequestDispatcher dispatcher) {
        if (this.tokenResolver != null) {
            this.kvSessionManager = new KVSessionManager(dispatcher, this.repNodeService.getRepNodeParams(), this.loginMgr, this.storeName, FailoverSessionManager.PERSISTENT_PREFIX, 16, this.userVerifier, this.logger);
            this.tokenResolver.setPersistentResolver(this.kvSessionManager);
        }
    }

    void startup() {
        if (this.kvSessionManager != null) {
            this.kvSessionManager.start();
        }
    }

    public void stop() {
        if (this.kvSessionManager != null) {
            this.kvSessionManager.stop();
        }
    }

    public AccessChecker getAccessChecker() {
        return this.accessChecker;
    }

    public LoginManager getLoginManager() {
        return this.loginMgr;
    }

    public KVSessionManager getKVSessionManager() {
        return this.kvSessionManager;
    }

    public UserVerifier getUserVerifier() {
        return this.userVerifier;
    }

    public SignatureHelper<Topology> getTopoSignatureHelper() {
        return this.topoSignatureHelper;
    }

    void setTopologyManager(TopologyManager topoMgr) {
        if (this.topoMgrHandle != null) {
            this.topoMgrHandle.setTopoMgr(topoMgr);
        }
    }

    @Override
    public void newServiceParameters(ParameterMap map) {
        if (this.tokenVerifier == null) {
            return;
        }
        RepNodeParams rp = new RepNodeParams(map);
        int newCapacity = rp.getLoginCacheSize();
        if (this.tokenVerifier.updateLoginCacheSize(newCapacity)) {
            this.logger.info(String.format("RNSecurity: loginCacheSize has been updated to %d", newCapacity));
        }
    }

    @Override
    public void newGlobalParameters(ParameterMap map) {
        if (this.tokenVerifier == null) {
            return;
        }
        GlobalParams gp = new GlobalParams(map);
        long newLifeTime = gp.getLoginCacheTimeoutUnit().toMillis(gp.getLoginCacheTimeout());
        if (this.tokenVerifier.updateLoginCacheTimeout(newLifeTime)) {
            this.logger.info(String.format("RNSecurity: loginCacheTimeout has been updated to %d ms", newLifeTime));
        }
    }

    @Override
    public void newUserDefinition(SecurityMDChange mdChange) {
        if (!(mdChange.getElement() instanceof KVStoreUser)) {
            throw new AssertionError();
        }
        KVStoreUser user = (KVStoreUser)mdChange.getElement();
        if (this.tokenVerifier == null) {
            return;
        }
        if (this.tokenVerifier.updateLoginCacheSessions(user)) {
            this.logger.info(String.format("RNSecurity: update sessions in login cache with metadata %d", mdChange.getSeqNum()));
        }
        if (this.accessChecker.updateUserDefinition(user)) {
            this.logger.fine(String.format("RNSecurity: updated user %s definition in access checker privilege cache", user.getName()));
        }
    }

    @Override
    public void newRoleDefinition(SecurityMDChange mdChange) {
        if (!(mdChange.getElement() instanceof RoleInstance)) {
            throw new AssertionError();
        }
        RoleInstance role = (RoleInstance)mdChange.getElement();
        if (this.accessChecker == null) {
            return;
        }
        if (this.accessChecker.updateRoleDefinition(role)) {
            this.logger.fine(String.format("RNSecurity: update role %s definition in access checker privilege cache", role.name()));
        }
    }

    private class RepNodeRoleResolver
    implements RoleResolver {
        private RepNodeRoleResolver() {
        }

        @Override
        public RoleInstance resolve(String roleName) {
            RoleInstance roleInstance = KVBuiltInRoleResolver.resolveRole(roleName);
            if (roleInstance == null) {
                SecurityMetadata secMd = RepNodeSecurity.this.repNodeService.getSecurityMetadata();
                if (secMd == null) {
                    return null;
                }
                roleInstance = secMd.getRole(roleName);
            }
            return roleInstance;
        }
    }

    private class RepNodeUserVerifier
    implements UserVerifier {
        private RepNodeUserVerifier() {
        }

        @Override
        public Subject verifyUser(LoginCredentials creds) {
            SecurityMetadata secMd = RepNodeSecurity.this.repNodeService.getSecurityMetadata();
            if (secMd == null) {
                RepNodeSecurity.this.logger.info("Unable to verify user credentials with no security metadata available");
                return null;
            }
            KVStoreUser user = secMd.getUser(creds.getUsername());
            if (user == null) {
                RepNodeSecurity.this.logger.info("User password credentials are not valid");
                return null;
            }
            if (creds instanceof PasswordCredentials) {
                PasswordCredentials pwCreds = (PasswordCredentials)creds;
                if (!user.verifyPassword(pwCreds.getPassword())) {
                    RepNodeSecurity.this.logger.info("User password credentials are not valid");
                    return null;
                }
                if (user.isPasswordExpired()) {
                    RepNodeSecurity.this.logger.info("User password credentials are expired");
                    throw new PasswordExpiredException(String.format("The password of %s has expired, it is required to change the password.", user.getName()));
                }
            } else if (!(creds instanceof ProxyCredentials)) {
                RepNodeSecurity.this.logger.info("Encountered unsupported login credentials of type " + creds.getClass());
                return null;
            }
            return user.makeKVSubject();
        }

        @Override
        public Subject verifyUser(Subject subj) {
            KVStoreUserPrincipal userPrinc = ExecutionContext.getSubjectUserPrincipal(subj);
            if (userPrinc == null) {
                return null;
            }
            SecurityMetadata secMd = RepNodeSecurity.this.repNodeService.getSecurityMetadata();
            if (secMd == null) {
                RepNodeSecurity.this.logger.info("Unable to verify user with no security metadata available");
                return null;
            }
            KVStoreUser user = secMd.getUser(userPrinc.getName());
            if (user == null || !user.isEnabled()) {
                RepNodeSecurity.this.logger.info("User " + userPrinc.getName() + " is not valid");
                return null;
            }
            return subj;
        }
    }
}

