/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicatedEnvironmentStats;
import com.sleepycat.utilint.LatencyStat;
import com.sleepycat.utilint.StatsTracker;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.measurement.EnvStats;
import oracle.kv.impl.measurement.JVMStats;
import oracle.kv.impl.measurement.LatencyInfo;
import oracle.kv.impl.measurement.PerfStatType;
import oracle.kv.impl.measurement.RepEnvStats;
import oracle.kv.impl.measurement.ReplicationState;
import oracle.kv.impl.monitor.AgentRepository;
import oracle.kv.impl.monitor.views.PerfEvent;
import oracle.kv.impl.param.DurationParameter;
import oracle.kv.impl.param.ParameterListener;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterUtils;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.rep.monitor.StatsPacket;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.util.KVThreadFactory;
import oracle.kv.impl.util.RateLimitingLogger;
import oracle.kv.impl.util.server.LoggerUtils;

public class OperationsStatsTracker
implements ParameterListener {
    private static final int WAIT_FOR_HANDLE = 100;
    private final AgentRepository monitorBuffer;
    private final ScheduledExecutorService collector;
    private Future<?> collectorFuture;
    protected List<Listener> listeners = new ArrayList<Listener>();
    private volatile SummarizingStatsTracker tracker;
    private long trackingStart;
    private long lastEnd;
    private long lastEndOfLog = 0L;
    private final StatsConfig config = new StatsConfig().setClear(true);
    private final Logger logger;
    private final RepNodeService repNodeService;
    private static final int LOG_SAMPLE_PERIOD_MS = 300000;
    private static final int MAX_LOG_TYPES = 5;
    private final RateLimitingLogger<String> eventLogger;

    public OperationsStatsTracker(RepNodeService repNodeService, ParameterMap map, AgentRepository monitorBuffer) {
        this.repNodeService = repNodeService;
        this.monitorBuffer = monitorBuffer;
        RepNodeService.Params params = repNodeService.getParams();
        this.logger = LoggerUtils.getLogger(OperationsStatsTracker.class, params);
        this.eventLogger = new RateLimitingLogger(300000, 5, this.logger);
        CollectorThreadFactory factory = new CollectorThreadFactory(this.logger, params.getRepNodeParams().getRepNodeId());
        this.collector = new ScheduledThreadPoolExecutor(1, factory);
        this.initialize(map);
    }

    public OperationsStatsTracker() {
        this.tracker = new SummarizingStatsTracker(null, 0, 0L, 0, 1000);
        this.monitorBuffer = null;
        this.collector = null;
        this.collectorFuture = null;
        this.logger = null;
        this.eventLogger = null;
        this.repNodeService = null;
        this.trackingStart = 0L;
    }

    private void initialize(ParameterMap map) {
        if (this.collectorFuture != null) {
            this.logger.fine("Cancelling current operationStatsCollector");
            this.collectorFuture.cancel(true);
        }
        this.tracker = new SummarizingStatsTracker(this.logger, map.get("activeThreshold").asInt(), ParameterUtils.getThreadDumpIntervalMillis(map), map.get("threadDumpMax").asInt(), ParameterUtils.getMaxTrackedLatencyMillis(map));
        DurationParameter dp = (DurationParameter)map.get("statsInterval");
        Start start = OperationsStatsTracker.calculateStart(Calendar.getInstance(), (int)dp.getAmount(), dp.getUnit());
        this.logger.fine("Starting operationStatsCollector " + start);
        this.collectorFuture = this.collector.scheduleAtFixedRate(new CollectStats(), start.delay, start.interval, start.unit);
        this.trackingStart = this.lastEnd = System.currentTimeMillis();
    }

    public StatsTracker<InternalOperation.OpCode> getStatsTracker() {
        return this.tracker;
    }

    @Override
    public synchronized void newParameters(ParameterMap oldMap, ParameterMap newMap) {
        if (this.paramsDiffer(oldMap, newMap, "statsInterval") || this.paramsDiffer(oldMap, newMap, "threadDumpMax") || this.paramsDiffer(oldMap, newMap, "activeThreshold") || this.paramsDiffer(oldMap, newMap, "maxTrackedLatency") || this.paramsDiffer(oldMap, newMap, "threadDumpInterval")) {
            this.initialize(newMap);
        }
    }

    private boolean paramsDiffer(ParameterMap map1, ParameterMap map2, String param) {
        return map1.get(param).equals(map2.get(param));
    }

    static Start calculateStart(Calendar now, int configuredInterval, TimeUnit configuredUnit) {
        Start start = new Start();
        start.unit = configuredUnit;
        start.interval = configuredInterval;
        switch (configuredUnit) {
            case HOURS: {
                if (configuredInterval <= 24) break;
                start.unit = TimeUnit.DAYS;
                start.interval = configuredInterval / 24;
                if (configuredInterval % 24 <= 0) break;
                ++start.interval;
                break;
            }
            case MINUTES: {
                if (configuredInterval <= 60) break;
                start.unit = TimeUnit.HOURS;
                start.interval = configuredInterval / 60;
                if (configuredInterval % 60 <= 0) break;
                ++start.interval;
                break;
            }
            case SECONDS: {
                if (configuredInterval <= 60) break;
                start.unit = TimeUnit.MINUTES;
                start.interval = configuredInterval / 60;
                if (configuredInterval % 60 <= 0) break;
                ++start.interval;
                break;
            }
        }
        switch (start.unit) {
            case HOURS: {
                OperationsStatsTracker.nextStart(start, now, 10, 24);
                break;
            }
            case MINUTES: {
                OperationsStatsTracker.nextStart(start, now, 12, 60);
                break;
            }
            case SECONDS: {
                OperationsStatsTracker.nextStart(start, now, 13, 60);
                break;
            }
        }
        return start;
    }

    private static void nextStart(Start start, Calendar now, int calField, int numTotalUnits) {
        if (numTotalUnits % start.interval != 0) {
            start.delay = 0;
            return;
        }
        int nowUnits = now.get(calField);
        int nextStartUnit = nowUnits / start.interval + 1;
        start.delay = nextStartUnit * start.interval - nowUnits;
    }

    public void close() {
        this.collectorFuture.cancel(true);
    }

    public synchronized void pushStats() {
        this.logger.fine("Collecting latency stats");
        long useStart = this.lastEnd;
        long useEnd = System.currentTimeMillis();
        StatsPacket packet = new StatsPacket(useStart, useEnd);
        for (InternalOperation.OpCode op : InternalOperation.OpCode.values()) {
            LatencyStat stat = this.tracker.getIntervalLatency().get((Object)op);
            packet.add(new LatencyInfo(op.getIntervalMetric(), useStart, useEnd, stat.calculate()));
            stat = this.tracker.getCumulativeLatency().get((Object)op);
            packet.add(new LatencyInfo(op.getCumulativeMetric(), this.trackingStart, useEnd, stat.calculate()));
        }
        LatencyStat singleOpsInterval = this.tracker.getSingleOpsIntervalStat();
        packet.add(new LatencyInfo(PerfStatType.USER_SINGLE_OP_INT, useStart, useEnd, singleOpsInterval.calculate()));
        packet.add(new LatencyInfo(PerfStatType.USER_SINGLE_OP_CUM, this.trackingStart, useEnd, this.tracker.getSingleOpsCumulativeStat().calculate()));
        LatencyStat multiOpsInterval = this.tracker.getMultiOpsIntervalStat();
        packet.add(new LatencyInfo(PerfStatType.USER_MULTI_OP_INT, useStart, useEnd, multiOpsInterval.calculate()));
        packet.add(new LatencyInfo(PerfStatType.USER_MULTI_OP_CUM, this.trackingStart, useEnd, this.tracker.getMultiOpsCumulativeStat().calculate()));
        packet.add(new ReplicationState(useStart, useEnd, this.getReplicationState()));
        if (this.repNodeService.getParams().getRepNodeParams().getCollectEnvStats()) {
            EnvironmentStats envStats;
            ReplicatedEnvironment repEnv = this.repNodeService.getRepNode().getEnv(100L);
            if (repEnv != null && repEnv.isValid() && (envStats = repEnv.getStats(this.config)).getEndOfLog() != this.lastEndOfLog) {
                packet.add(new EnvStats(useStart, useEnd, envStats));
                ReplicatedEnvironmentStats repStats = repEnv.getRepStats(this.config);
                packet.add(new RepEnvStats(useStart, useEnd, repStats));
                this.lastEndOfLog = envStats.getEndOfLog();
            }
            packet.add(new JVMStats(useStart, useEnd));
        }
        this.lastEnd = useEnd;
        this.logThresholdAlerts(Level.WARNING, packet);
        this.tracker.clearLatency();
        this.monitorBuffer.add(packet);
        this.sendPacket(packet);
        this.logger.fine(packet.toString());
    }

    private ReplicatedEnvironment.State getReplicationState() {
        ReplicatedEnvironment.State state = ReplicatedEnvironment.State.UNKNOWN;
        try {
            ReplicatedEnvironment env = this.repNodeService.getRepNode().getEnv(100L);
            if (env != null) {
                try {
                    state = env.getState();
                }
                catch (IllegalStateException ise) {
                    state = ReplicatedEnvironment.State.DETACHED;
                }
            }
        }
        catch (EnvironmentFailureException environmentFailureException) {
            // empty catch block
        }
        return state;
    }

    public void addListener(Listener lst) {
        this.listeners.add(lst);
    }

    public void removeListener(Listener lst) {
        this.listeners.remove(lst);
    }

    private void sendPacket(StatsPacket packet) {
        for (Listener lst : this.listeners) {
            lst.receiveStats(packet);
        }
    }

    private void logThresholdAlerts(Level level, StatsPacket packet) {
        LatencyInfo multiOpIntervalLatencyInfo;
        if (this.logger == null || this.eventLogger == null || this.repNodeService == null || level == null || packet == null) {
            return;
        }
        if (!this.logger.isLoggable(level)) {
            return;
        }
        RepNodeParams params = this.repNodeService.getRepNodeParams();
        if (params == null) {
            return;
        }
        int ceiling = params.getLatencyCeiling();
        int floor = params.getThroughputFloor();
        long threshold = params.getCommitLagThreshold();
        long lag = PerfEvent.getCommitLagMs(packet.getRepEnvStats());
        LatencyInfo singleOpIntervalLatencyInfo = packet.get(PerfStatType.USER_SINGLE_OP_INT);
        if (PerfEvent.latencyCeilingExceeded(ceiling, singleOpIntervalLatencyInfo)) {
            this.eventLogger.log("single-op-interval-latency", level, "single op interval latency above ceiling [" + ceiling + "]");
        }
        if (PerfEvent.throughputFloorExceeded(floor, singleOpIntervalLatencyInfo)) {
            this.eventLogger.log("single-op-interval-throughput", level, "single op interval throughput below floor [" + floor + "]");
        }
        if (PerfEvent.latencyCeilingExceeded(ceiling, multiOpIntervalLatencyInfo = packet.get(PerfStatType.USER_MULTI_OP_INT))) {
            this.eventLogger.log("multi-op-interval-latency", level, "multi-op interval latency above ceiling [" + ceiling + "]");
        }
        if (PerfEvent.throughputFloorExceeded(floor, multiOpIntervalLatencyInfo)) {
            this.eventLogger.log("multi-op-interval-throughput", level, "multi-op interval throughput below floor [" + floor + "]");
        }
        if (PerfEvent.commitLagThresholdExceeded(lag, threshold)) {
            this.eventLogger.log("replica-lag", level, "replica lag exceeds threshold [replicaLagMs=" + lag + " threshold=" + threshold + "]");
        }
    }

    public static interface Listener {
        public void receiveStats(StatsPacket var1);
    }

    private class SummarizingStatsTracker
    extends StatsTracker<InternalOperation.OpCode> {
        private final LatencyStat singleOpsInterval;
        private final LatencyStat singleOpsCumulative;
        private final LatencyStat multiOpsInterval;
        private final LatencyStat multiOpsCumulative;

        public SummarizingStatsTracker(Logger stackTraceLogger, int activeThreadThreshold, long threadDumpIntervalMillis, int threadDumpMax, int maxTrackedLatencyMillis) {
            super(InternalOperation.OpCode.values(), stackTraceLogger, activeThreadThreshold, threadDumpIntervalMillis, threadDumpMax, maxTrackedLatencyMillis);
            this.singleOpsInterval = new LatencyStat(maxTrackedLatencyMillis);
            this.singleOpsCumulative = new LatencyStat(maxTrackedLatencyMillis);
            this.multiOpsInterval = new LatencyStat(maxTrackedLatencyMillis);
            this.multiOpsCumulative = new LatencyStat(maxTrackedLatencyMillis);
        }

        @Override
        public void markFinish(InternalOperation.OpCode opType, long startTime, int numRecords) {
            super.markFinish(opType, startTime, numRecords);
            if (numRecords == 0) {
                return;
            }
            if (opType == null) {
                return;
            }
            long elapsed = System.nanoTime() - startTime;
            PerfStatType ptype = opType.getIntervalMetric();
            if (ptype.getParent().equals((Object)PerfStatType.USER_SINGLE_OP_INT)) {
                this.singleOpsInterval.set(elapsed);
                this.singleOpsCumulative.set(elapsed);
            } else if (ptype.getParent().equals((Object)PerfStatType.USER_MULTI_OP_INT)) {
                this.multiOpsInterval.set(numRecords, elapsed);
                this.multiOpsCumulative.set(numRecords, elapsed);
            }
        }

        @Override
        public void clearLatency() {
            super.clearLatency();
            this.singleOpsInterval.clear();
            this.multiOpsInterval.clear();
        }

        LatencyStat getSingleOpsIntervalStat() {
            return this.singleOpsInterval;
        }

        LatencyStat getSingleOpsCumulativeStat() {
            return this.singleOpsCumulative;
        }

        LatencyStat getMultiOpsIntervalStat() {
            return this.multiOpsInterval;
        }

        LatencyStat getMultiOpsCumulativeStat() {
            return this.multiOpsCumulative;
        }
    }

    private class CollectorThreadFactory
    extends KVThreadFactory {
        private final RepNodeId repNodeId;

        CollectorThreadFactory(Logger logger, RepNodeId repNodeId) {
            super(null, logger);
            this.repNodeId = repNodeId;
        }

        @Override
        public String getName() {
            return this.repNodeId + "_MonitorAgentCollector";
        }
    }

    private class CollectStats
    implements Runnable {
        private CollectStats() {
        }

        @Override
        public void run() {
            OperationsStatsTracker.this.pushStats();
        }
    }

    static class Start {
        int delay;
        int interval;
        TimeUnit unit;

        Start() {
        }
    }
}

