/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.mgmt;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.measurement.ProxiedServiceStatusChange;
import oracle.kv.impl.measurement.ServiceStatusChange;
import oracle.kv.impl.mgmt.AdminStatusReceiver;
import oracle.kv.impl.mgmt.MgmtAgent;
import oracle.kv.impl.mgmt.RepNodeStatusReceiver;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.rep.monitor.StatsPacket;
import oracle.kv.impl.sna.ServiceManager;
import oracle.kv.impl.sna.StorageNodeAgent;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.PortRange;
import oracle.kv.impl.util.ServiceStatusTracker;
import oracle.kv.impl.util.registry.RegistryUtils;

public abstract class AgentInternal
implements MgmtAgent {
    protected final StorageNodeAgent sna;
    private final Map<RepNodeId, RepNodeStatusReceiver> rnStatusReceivers = new HashMap<RepNodeId, RepNodeStatusReceiver>();
    private final List<ServiceManager.Listener> smListeners = new ArrayList<ServiceManager.Listener>();
    private ServiceStatusTracker snaStatusTracker;
    private AdminStatusReceiver adminStatusReceiver = null;

    protected AgentInternal(StorageNodeAgent sna) {
        this.sna = sna;
    }

    @Override
    public void setSnaStatusTracker(ServiceStatusTracker tracker) {
        if (this.snaStatusTracker == tracker) {
            return;
        }
        this.snaStatusTracker = tracker;
        this.snaStatusTracker.addListener(new StatusListener());
        ServiceStatusChange s = new ServiceStatusChange(this.snaStatusTracker.getServiceStatus());
        this.updateSNStatus(s, s);
    }

    @Override
    public void shutdown() {
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.unexportAll();
        this.clearSmListeners();
    }

    protected abstract void updateSNStatus(ServiceStatusChange var1, ServiceStatusChange var2);

    protected void addServiceManagerListener(final RepNodeId rnId, ServiceManager mgr) {
        if (mgr.isRunning()) {
            this.installRepNodeStatusReceiver(rnId);
        }
        ServiceManager serviceManager = mgr;
        serviceManager.getClass();
        ServiceManager.Listener listener = new ServiceManager.Listener(serviceManager){

            @Override
            public void startupCallback() {
                AgentInternal.this.installRepNodeStatusReceiver(rnId);
            }
        };
        this.smListeners.add(listener);
    }

    protected void addAdminServiceManagerListener(ServiceManager mgr) {
        if (mgr.isRunning()) {
            this.installAdminStatusReceiver();
        }
        ServiceManager.Listener listener = new ServiceManager.Listener(mgr){

            @Override
            public void startupCallback() {
                AgentInternal.this.installAdminStatusReceiver();
            }
        };
        this.smListeners.add(listener);
    }

    public void installRepNodeStatusReceiver(RepNodeId rnId) {
        ConfigurableService.ServiceStatus[] targets = new ConfigurableService.ServiceStatus[]{ConfigurableService.ServiceStatus.UNREACHABLE};
        RepNodeAdminAPI rnai = this.sna.waitForRepNodeAdmin(rnId, targets);
        if (rnai == null) {
            return;
        }
        try {
            RepNodeStatusReceiver rnsr = this.getRepNodeStatusReceiver(rnId);
            rnai.installStatusReceiver(rnsr);
        }
        catch (RemoteException e) {
            this.sna.getLogger().log(Level.WARNING, "Error installing RepNodeStatusReceiver for " + rnId.getFullName() + ".", e);
        }
    }

    private RepNodeStatusReceiver getRepNodeStatusReceiver(RepNodeId rnid) throws RemoteException {
        RepNodeStatusReceiver rnsr = this.rnStatusReceivers.get(rnid);
        if (rnsr != null) {
            this.unexportStatusReceiver(rnsr, true);
        }
        rnsr = new RepNodeStatusReceiverImpl(rnid);
        this.rnStatusReceivers.put(rnid, rnsr);
        return rnsr;
    }

    protected void unexportStatusReceiver(RepNodeId rnid) {
        RepNodeStatusReceiver rnsr = this.rnStatusReceivers.get(rnid);
        if (rnsr != null) {
            this.unexportStatusReceiver(rnsr, true);
        }
    }

    private void unexportStatusReceiver(RepNodeStatusReceiver rnsr, boolean remove) {
        try {
            UnicastRemoteObject.unexportObject(rnsr, true);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (remove) {
            this.rnStatusReceivers.remove(rnsr);
        }
    }

    public void installAdminStatusReceiver() {
        CommandServiceAPI cs = this.sna.waitForAdmin(ConfigurableService.ServiceStatus.UNREACHABLE, 120);
        if (cs == null) {
            return;
        }
        try {
            AdminStatusReceiver asr = this.getAdminStatusReceiver();
            cs.installStatusReceiver(asr);
        }
        catch (RemoteException e) {
            this.sna.getLogger().log(Level.WARNING, "Error installing AdminStatusReceiver.", e);
        }
    }

    private AdminStatusReceiver getAdminStatusReceiver() throws RemoteException {
        if (this.adminStatusReceiver != null) {
            this.unexportAdminStatusReceiver();
        }
        this.adminStatusReceiver = new AdminStatusReceiverImpl();
        return this.adminStatusReceiver;
    }

    protected void unexportAdminStatusReceiver() {
        try {
            UnicastRemoteObject.unexportObject(this.adminStatusReceiver, true);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.adminStatusReceiver = null;
    }

    public abstract void updateAdminParameters(ParameterMap var1);

    public abstract void updateAdminStatus(ServiceStatusChange var1, boolean var2);

    protected void unexportAll() {
        for (RepNodeId rnid : this.rnStatusReceivers.keySet()) {
            this.unexportStatusReceiver(this.rnStatusReceivers.get(rnid), false);
        }
        this.rnStatusReceivers.clear();
    }

    protected abstract void updateRepNodeStatus(RepNodeId var1, ServiceStatusChange var2);

    protected abstract void updateRepNodePerfStats(RepNodeId var1, StatsPacket var2);

    protected abstract void updateRepNodeParameters(RepNodeId var1, ParameterMap var2);

    @Override
    public void proxiedStatusChange(ProxiedServiceStatusChange sc) {
        ResourceId rid = sc.getTarget(this.sna.getStorageNodeId());
        if (rid instanceof RepNodeId) {
            RepNodeId rnid = (RepNodeId)rid;
            this.updateRepNodeStatus(rnid, sc);
        }
        if (rid instanceof AdminId) {
            this.updateAdminStatus(sc, false);
        }
    }

    private void clearSmListeners() {
        for (ServiceManager.Listener listener : this.smListeners) {
            listener.removeSelf();
        }
        this.smListeners.clear();
    }

    public int getSnId() {
        return this.sna.getStorageNodeId().getStorageNodeId();
    }

    public int getRegistryPort() {
        return this.sna.getRegistryPort();
    }

    public int getFreePort() {
        String rangeString = this.sna.getServicePortRange();
        List<Integer> range = PortRange.getRange(rangeString);
        return RegistryUtils.findFreePort(range.get(0), range.get(1), this.getHostname());
    }

    public boolean restrictPortRange() {
        return this.sna.getServicePortRange() != null;
    }

    public String getStoreName() {
        return AgentInternal.nullToEmptyString(this.sna.getStoreName());
    }

    public String getHostname() {
        return AgentInternal.nullToEmptyString(this.sna.getHostname());
    }

    public String getHAHostname() {
        return AgentInternal.nullToEmptyString(this.sna.getHAHostname());
    }

    public String getBootstrapDir() {
        return AgentInternal.nullToEmptyString(this.sna.getBootstrapDir());
    }

    public String getBootstrapFile() {
        return AgentInternal.nullToEmptyString(this.sna.getBootstrapFile());
    }

    public String getKvConfigFile() {
        return AgentInternal.nullToEmptyString(this.sna.getKvConfigFile().toString());
    }

    public int getAdminHttpPort() {
        return this.sna.getBootstrapParams().getAdminHttpPort();
    }

    public boolean isHostingAdmin() {
        return this.sna.getBootstrapParams().isHostingAdmin();
    }

    public String getRootDir() {
        return AgentInternal.nullToEmptyString(this.sna.getBootstrapParams().getRootdir());
    }

    public Integer getCapacity() {
        return this.sna.getCapacity();
    }

    public Integer getLogFileLimit() {
        return this.sna.getLogFileLimit();
    }

    public Integer getLogFileCount() {
        return this.sna.getLogFileCount();
    }

    public String getSnHaPortRange() {
        return AgentInternal.nullToEmptyString(this.sna.getHAPortRange());
    }

    public int getNumCpus() {
        return this.sna.getNumCpus();
    }

    public int getMemoryMB() {
        return this.sna.getMemoryMB();
    }

    public String getMountPointsString() {
        return AgentInternal.nullToEmptyString(this.sna.getMountPointsString());
    }

    private static String nullToEmptyString(String s) {
        return s == null ? "" : s;
    }

    private class AdminStatusReceiverImpl
    extends UnicastRemoteObject
    implements AdminStatusReceiver {
        private static final long serialVersionUID = 1L;

        protected AdminStatusReceiverImpl() throws RemoteException {
        }

        @Override
        public void updateAdminStatus(ServiceStatusChange newStatus, boolean isMaster) {
            AgentInternal.this.updateAdminStatus(newStatus, isMaster);
        }

        @Override
        public void receiveNewParams(ParameterMap newMap) throws RemoteException {
            AgentInternal.this.updateAdminParameters(newMap);
        }
    }

    private class RepNodeStatusReceiverImpl
    extends UnicastRemoteObject
    implements RepNodeStatusReceiver {
        private static final long serialVersionUID = 1L;
        RepNodeId rnid;

        RepNodeStatusReceiverImpl(RepNodeId rnid) throws RemoteException {
            this.rnid = rnid;
        }

        @Override
        public void updateRnStatus(ServiceStatusChange newStatus) {
            AgentInternal.this.updateRepNodeStatus(this.rnid, newStatus);
        }

        @Override
        public void receiveStats(StatsPacket packet) throws RemoteException {
            AgentInternal.this.updateRepNodePerfStats(this.rnid, packet);
        }

        @Override
        public void receiveNewParams(ParameterMap newMap) throws RemoteException {
            AgentInternal.this.updateRepNodeParameters(this.rnid, newMap);
        }

        @Override
        public String toString() {
            return this.rnid.getFullName();
        }
    }

    class StatusListener
    implements ServiceStatusTracker.Listener {
        StatusListener() {
        }

        @Override
        public void update(ServiceStatusChange prevStatus, ServiceStatusChange newStatus) {
            AgentInternal.this.updateSNStatus(prevStatus, newStatus);
        }
    }
}

